/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.CommentEmitter;
import com.sun.gluegen.FunctionEmitter;
import com.sun.gluegen.JavaConfiguration;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.cgram.types.ArrayType;
import com.sun.gluegen.cgram.types.CompoundType;
import com.sun.gluegen.cgram.types.EnumType;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;

public class JavaMethodBindingEmitter
extends FunctionEmitter {
    public static final FunctionEmitter.EmissionModifier PUBLIC = new FunctionEmitter.EmissionModifier("public");
    public static final FunctionEmitter.EmissionModifier PROTECTED = new FunctionEmitter.EmissionModifier("protected");
    public static final FunctionEmitter.EmissionModifier PRIVATE = new FunctionEmitter.EmissionModifier("private");
    public static final FunctionEmitter.EmissionModifier ABSTRACT = new FunctionEmitter.EmissionModifier("abstract");
    public static final FunctionEmitter.EmissionModifier FINAL = new FunctionEmitter.EmissionModifier("final");
    public static final FunctionEmitter.EmissionModifier NATIVE = new FunctionEmitter.EmissionModifier("native");
    public static final FunctionEmitter.EmissionModifier SYNCHRONIZED = new FunctionEmitter.EmissionModifier("synchronized");
    protected final CommentEmitter defaultJavaCommentEmitter = new DefaultCommentEmitter();
    protected final CommentEmitter defaultInterfaceCommentEmitter = new InterfaceCommentEmitter();
    private String runtimeExceptionType;
    private String unsupportedExceptionType;
    protected boolean emitBody;
    protected boolean eraseBufferAndArrayTypes;
    protected boolean directNIOOnly;
    protected boolean forImplementingMethodCall;
    protected boolean forDirectBufferImplementation;
    protected boolean forIndirectBufferAndArrayImplementation;
    protected boolean isUnimplemented;
    protected boolean tagNativeBinding;
    protected MethodBinding binding;
    protected List prologue;
    protected List epilogue;
    private String returnedArrayLengthExpression;
    private static final String COMPOUND_ARRAY_SUFFIX = "_buf_array_copy";
    private JavaConfiguration cfg;

    public JavaMethodBindingEmitter(MethodBinding binding, PrintWriter output, String runtimeExceptionType, String unsupportedExceptionType, boolean emitBody, boolean tagNativeBinding, boolean eraseBufferAndArrayTypes, boolean directNIOOnly, boolean forImplementingMethodCall, boolean forDirectBufferImplementation, boolean forIndirectBufferAndArrayImplementation, boolean isUnimplemented, boolean isInterface, JavaConfiguration configuration) {
        super(output, isInterface);
        this.binding = binding;
        this.runtimeExceptionType = runtimeExceptionType;
        this.unsupportedExceptionType = unsupportedExceptionType;
        this.emitBody = emitBody;
        this.tagNativeBinding = tagNativeBinding;
        this.eraseBufferAndArrayTypes = eraseBufferAndArrayTypes;
        this.directNIOOnly = directNIOOnly;
        this.forImplementingMethodCall = forImplementingMethodCall;
        this.forDirectBufferImplementation = forDirectBufferImplementation;
        this.forIndirectBufferAndArrayImplementation = forIndirectBufferAndArrayImplementation;
        this.isUnimplemented = isUnimplemented;
        if (forImplementingMethodCall) {
            this.setCommentEmitter(this.defaultJavaCommentEmitter);
        } else {
            this.setCommentEmitter(this.defaultInterfaceCommentEmitter);
        }
        this.cfg = configuration;
    }

    public JavaMethodBindingEmitter(JavaMethodBindingEmitter arg) {
        super(arg);
        this.binding = arg.binding;
        this.runtimeExceptionType = arg.runtimeExceptionType;
        this.unsupportedExceptionType = arg.unsupportedExceptionType;
        this.emitBody = arg.emitBody;
        this.tagNativeBinding = arg.tagNativeBinding;
        this.eraseBufferAndArrayTypes = arg.eraseBufferAndArrayTypes;
        this.directNIOOnly = arg.directNIOOnly;
        this.forImplementingMethodCall = arg.forImplementingMethodCall;
        this.forDirectBufferImplementation = arg.forDirectBufferImplementation;
        this.forIndirectBufferAndArrayImplementation = arg.forIndirectBufferAndArrayImplementation;
        this.isUnimplemented = arg.isUnimplemented;
        this.prologue = arg.prologue;
        this.epilogue = arg.epilogue;
        this.returnedArrayLengthExpression = arg.returnedArrayLengthExpression;
        this.cfg = arg.cfg;
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    public boolean isForImplementingMethodCall() {
        return this.forImplementingMethodCall;
    }

    public boolean isForDirectBufferImplementation() {
        return this.forDirectBufferImplementation;
    }

    public boolean isForIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    @Override
    public String getName() {
        return this.binding.getName();
    }

    protected String getArgumentName(int i) {
        return this.binding.getArgumentName(i);
    }

    public String getRuntimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public String getUnsupportedExceptionType() {
        return this.unsupportedExceptionType;
    }

    public void setReturnedArrayLengthExpression(String expr) {
        this.returnedArrayLengthExpression = expr;
    }

    public void setPrologue(List prologue) {
        this.prologue = prologue;
    }

    public void setEpilogue(List epilogue) {
        this.epilogue = epilogue;
    }

    public boolean signatureOnly() {
        return !this.emitBody;
    }

    public void setEmitBody(boolean emitBody) {
        this.emitBody = emitBody;
    }

    public void setEraseBufferAndArrayTypes(boolean erase) {
        this.eraseBufferAndArrayTypes = erase;
    }

    public void setForImplementingMethodCall(boolean impl) {
        this.forImplementingMethodCall = impl;
    }

    public void setForDirectBufferImplementation(boolean direct) {
        this.forDirectBufferImplementation = direct;
    }

    public void setForIndirectBufferAndArrayImplementation(boolean indirect) {
        this.forIndirectBufferAndArrayImplementation = indirect;
    }

    @Override
    protected void emitReturnType(PrintWriter writer) {
        writer.print(this.getReturnTypeString(false));
    }

    protected String erasedTypeString(JavaType type, boolean skipBuffers) {
        if (this.eraseBufferAndArrayTypes) {
            if (type.isNIOBuffer()) {
                if (!skipBuffers) {
                    return "Object";
                }
                if (!type.isNIOByteBuffer()) {
                    return "java.nio.ByteBuffer";
                }
            } else if (type.isPrimitiveArray()) {
                if (!skipBuffers) {
                    return "Object";
                }
            } else {
                if (type.isNIOBufferArray()) {
                    return "Object[]";
                }
                if (type.isCompoundTypeWrapper()) {
                    return "java.nio.ByteBuffer";
                }
                if (type.isArrayOfCompoundTypeWrappers()) {
                    if (skipBuffers) {
                        return "java.nio.ByteBuffer";
                    }
                    return "java.nio.ByteBuffer[]";
                }
            }
        }
        if (type.isArrayOfCompoundTypeWrappers()) {
            return type.getName() + "[]";
        }
        return type.getName();
    }

    protected String getReturnTypeString(boolean skipArray) {
        if (skipArray || this.getReturnedArrayLengthExpression() == null && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers() || this.eraseBufferAndArrayTypes && this.binding.getJavaReturnType().isCompoundTypeWrapper() && this.getReturnedArrayLengthExpression() != null) {
            return this.erasedTypeString(this.binding.getJavaReturnType(), true);
        }
        return this.erasedTypeString(this.binding.getJavaReturnType(), true) + "[]";
    }

    @Override
    protected void emitName(PrintWriter writer) {
        if (this.forImplementingMethodCall) {
            if (this.forIndirectBufferAndArrayImplementation) {
                writer.print(this.getImplMethodName(false));
            } else {
                writer.print(this.getImplMethodName(true));
            }
        } else {
            writer.print(this.getName());
        }
    }

    @Override
    protected int emitArguments(PrintWriter writer) {
        boolean needComma = false;
        int numEmitted = 0;
        if (this.forImplementingMethodCall && this.binding.hasContainingType()) {
            writer.print("java.nio.ByteBuffer ");
            writer.print(JavaMethodBindingEmitter.javaThisArgumentName());
            ++numEmitted;
            needComma = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType type = this.binding.getJavaArgumentType(i);
            if (type.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (type.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (needComma) {
                writer.print(", ");
            }
            writer.print(this.erasedTypeString(type, false));
            writer.print(" ");
            writer.print(this.getArgumentName(i));
            ++numEmitted;
            needComma = true;
            if (this.forDirectBufferImplementation || this.forIndirectBufferAndArrayImplementation) {
                if (type.isNIOBuffer()) {
                    writer.print(", int " + this.byteOffsetArgName(i));
                } else if (type.isNIOBufferArray()) {
                    writer.print(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!type.isPrimitiveArray()) continue;
            writer.print(", int " + this.offsetArgName(i));
        }
        return numEmitted;
    }

    protected String getImplMethodName(boolean direct) {
        if (direct) {
            return this.binding.getName() + "0";
        }
        return this.binding.getName() + "1";
    }

    protected String byteOffsetArgName(int i) {
        return this.byteOffsetArgName(this.getArgumentName(i));
    }

    protected String byteOffsetArgName(String s) {
        return s + "_byte_offset";
    }

    protected String byteOffsetArrayArgName(int i) {
        return this.getArgumentName(i) + "_byte_offset_array";
    }

    protected String offsetArgName(int i) {
        return this.getArgumentName(i) + "_offset";
    }

    @Override
    protected void emitBody(PrintWriter writer) {
        if (!this.emitBody) {
            writer.println(';');
        } else {
            MethodBinding binding = this.getBinding();
            writer.println();
            writer.println("  {");
            if (this.isUnimplemented) {
                writer.println("    throw new " + this.getUnsupportedExceptionType() + "(\"Unimplemented\");");
            } else {
                this.emitPrologueOrEpilogue(this.prologue, writer);
                this.emitPreCallSetup(binding, writer);
                this.emitReturnVariableSetupAndCall(binding, writer);
            }
            writer.println("  }");
        }
    }

    protected void emitPrologueOrEpilogue(List code, PrintWriter writer) {
        if (code != null) {
            String[] argumentNames = this.argumentNameArray();
            for (String str : code) {
                try {
                    MessageFormat fmt = new MessageFormat(str);
                    writer.println("    " + fmt.format(argumentNames));
                }
                catch (IllegalArgumentException e) {
                    writer.println("    " + str);
                }
            }
        }
    }

    protected void emitPreCallSetup(MethodBinding binding, PrintWriter writer) {
        this.emitArrayLengthAndNIOBufferChecks(binding, writer);
        this.emitCompoundArrayCopies(binding, writer);
    }

    protected void emitArrayLengthAndNIOBufferChecks(MethodBinding binding, PrintWriter writer) {
        boolean numBufferOffsetArrayArgs = false;
        boolean firstBuffer = true;
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            String argName;
            Type type = binding.getCArgumentType(i);
            if (type.isArray()) {
                ArrayType arrayType = type.asArray();
                writer.println("    if (" + this.getArgumentName(i) + ".length < " + arrayType.getLength() + ")");
                writer.println("      throw new " + this.getRuntimeExceptionType() + "(\"Length of array \\\"" + this.getArgumentName(i) + "\\\" was less than the required " + arrayType.getLength() + "\");");
                continue;
            }
            JavaType javaType = binding.getJavaArgumentType(i);
            if (javaType.isNIOBuffer()) {
                if (this.directNIOOnly) {
                    writer.println("    if (!BufferFactory.isDirect(" + this.getArgumentName(i) + "))");
                    writer.println("      throw new " + this.getRuntimeExceptionType() + "(\"Argument \\\"" + this.getArgumentName(i) + "\\\" was not a direct buffer\");");
                    continue;
                }
                if (firstBuffer) {
                    firstBuffer = false;
                    writer.println("    boolean _direct = BufferFactory.isDirect(" + this.getArgumentName(i) + ");");
                    continue;
                }
                writer.println("    if (" + this.getArgumentName(i) + " != null && _direct != BufferFactory.isDirect(" + this.getArgumentName(i) + "))");
                writer.println("      throw new " + this.getRuntimeExceptionType() + "(\"Argument \\\"" + this.getArgumentName(i) + "\\\" : Buffers passed to this method must all be either direct or indirect\");");
                continue;
            }
            if (javaType.isNIOBufferArray()) {
                argName = this.getArgumentName(i);
                String arrayName = this.byteOffsetArrayArgName(i);
                writer.println("    int[] " + arrayName + " = new int[" + argName + ".length];");
                writer.println("    if (" + argName + " != null) {");
                writer.println("      for (int _ctr = 0; _ctr < " + argName + ".length; _ctr++) {");
                writer.println("        if (!BufferFactory.isDirect(" + argName + "[_ctr])) {");
                writer.println("          throw new " + this.getRuntimeExceptionType() + "(\"Element \" + _ctr + \" of argument \\\"" + this.getArgumentName(i) + "\\\" was not a direct buffer\");");
                writer.println("        }");
                writer.print("        " + arrayName + "[_ctr] = BufferFactory.getDirectBufferByteOffset(");
                writer.println(argName + "[_ctr]);");
                writer.println("      }");
                writer.println("    }");
                continue;
            }
            if (!javaType.isPrimitiveArray()) continue;
            argName = this.getArgumentName(i);
            String offsetArg = this.offsetArgName(i);
            writer.println("    if(" + argName + " != null && " + argName + ".length <= " + offsetArg + ")");
            writer.print("      throw new " + this.getRuntimeExceptionType());
            writer.println("(\"array offset argument \\\"" + offsetArg + "\\\" (\" + " + offsetArg + " + \") equals or exceeds array length (\" + " + argName + ".length + \")\");");
        }
    }

    protected void emitCompoundArrayCopies(MethodBinding binding, PrintWriter writer) {
        if (binding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < binding.getNumArguments(); ++i) {
                JavaType javaType = binding.getJavaArgumentType(i);
                if (!javaType.isArrayOfCompoundTypeWrappers()) continue;
                String argName = this.getArgumentName(i);
                String tempArrayName = argName + COMPOUND_ARRAY_SUFFIX;
                writer.println("    ByteBuffer[] " + tempArrayName + " = new ByteBuffer[" + argName + ".length];");
                writer.println("    for (int _ctr = 0; _ctr < + " + argName + ".length; _ctr++) {");
                writer.println("      " + javaType.getName() + " _tmp = " + argName + "[_ctr];");
                writer.println("      " + tempArrayName + "[_ctr] = ((_tmp == null) ? null : _tmp.getBuffer());");
                writer.println("    }");
            }
        }
    }

    protected void emitCall(MethodBinding binding, PrintWriter writer, boolean direct) {
        writer.print(this.getImplMethodName(direct));
        writer.print("(");
        this.emitCallArguments(binding, writer, direct);
        writer.print(")");
    }

    protected void emitReturnVariableSetupAndCall(MethodBinding binding, PrintWriter writer) {
        writer.print("    ");
        JavaType returnType = binding.getJavaReturnType();
        boolean needsResultAssignment = false;
        if (!returnType.isVoid()) {
            if (returnType.isCompoundTypeWrapper() || returnType.isNIOBuffer()) {
                writer.println("java.nio.ByteBuffer _res;");
                needsResultAssignment = true;
            } else if (returnType.isArrayOfCompoundTypeWrappers()) {
                writer.println("java.nio.ByteBuffer[] _res;");
                needsResultAssignment = true;
            } else if (this.epilogue != null && this.epilogue.size() > 0 || binding.signatureUsesArraysOfCompoundTypeWrappers()) {
                this.emitReturnType(writer);
                writer.println(" _res;");
                needsResultAssignment = true;
            }
        }
        if (binding.signatureCanUseIndirectNIO() && !this.directNIOOnly) {
            writer.println("if (_direct) {");
            writer.print("    ");
        }
        if (needsResultAssignment) {
            writer.print("    _res = ");
        } else {
            writer.print("    ");
            if (!returnType.isVoid()) {
                writer.print("return ");
            }
        }
        if (binding.signatureUsesJavaPrimitiveArrays() && !binding.signatureCanUseIndirectNIO()) {
            this.emitCall(binding, writer, false);
            writer.print(";");
            writer.println();
        } else {
            this.emitCall(binding, writer, true);
            writer.print(";");
        }
        if (binding.signatureCanUseIndirectNIO() && !this.directNIOOnly) {
            writer.println();
            writer.println("    } else {");
            writer.print("    ");
            if (needsResultAssignment) {
                writer.print("    _res = ");
            } else {
                writer.print("  ");
                if (!returnType.isVoid()) {
                    writer.print("return ");
                }
            }
            this.emitCall(binding, writer, false);
            writer.print(";");
            writer.println();
            writer.println("    }");
        } else {
            writer.println();
        }
        this.emitPostCallCleanup(binding, writer);
        this.emitPrologueOrEpilogue(this.epilogue, writer);
        if (needsResultAssignment) {
            this.emitCallResultReturn(binding, writer);
        }
    }

    protected int emitCallArguments(MethodBinding binding, PrintWriter writer, boolean direct) {
        boolean needComma = false;
        int numArgsEmitted = 0;
        if (binding.hasContainingType()) {
            assert (binding.getContainingType().isCompoundTypeWrapper());
            writer.print("getBuffer()");
            needComma = true;
            ++numArgsEmitted;
        }
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            JavaType type = binding.getJavaArgumentType(i);
            if (type.isJNIEnv() || binding.isArgumentThisPointer(i)) continue;
            if (type.isVoid()) {
                assert (binding.getNumArguments() == 1);
                continue;
            }
            if (needComma) {
                writer.print(", ");
            }
            if (type.isCompoundTypeWrapper()) {
                writer.print("((");
            }
            if (type.isNIOBuffer() && !direct) {
                writer.print("BufferFactory.getArray(" + this.getArgumentName(i) + ")");
            } else if (type.isArrayOfCompoundTypeWrappers()) {
                writer.print(this.getArgumentName(i) + COMPOUND_ARRAY_SUFFIX);
            } else if (type.isNIOPointerBuffer()) {
                writer.print(this.getArgumentName(i) + ".getBuffer()");
            } else {
                writer.print(this.getArgumentName(i));
            }
            if (type.isCompoundTypeWrapper()) {
                writer.print(" == null) ? null : ");
                writer.print(this.getArgumentName(i));
                writer.print(".getBuffer())");
            }
            if (type.isNIOBuffer()) {
                if (direct) {
                    writer.print(", BufferFactory.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                } else {
                    writer.print(", BufferFactory.getIndirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                }
            } else if (type.isNIOBufferArray()) {
                writer.print(", " + this.byteOffsetArrayArgName(i));
            }
            if (type.isPrimitiveArray()) {
                if (type.isFloatArray()) {
                    writer.print(", BufferFactory.SIZEOF_FLOAT * ");
                } else if (type.isDoubleArray()) {
                    writer.print(", BufferFactory.SIZEOF_DOUBLE * ");
                } else if (type.isByteArray()) {
                    writer.print(", ");
                } else if (type.isLongArray()) {
                    writer.print(", BufferFactory.SIZEOF_LONG * ");
                } else if (type.isShortArray()) {
                    writer.print(", BufferFactory.SIZEOF_SHORT * ");
                } else if (type.isIntArray()) {
                    writer.print(", BufferFactory.SIZEOF_INT * ");
                } else {
                    throw new RuntimeException("Unsupported type for calculating array offset argument for " + this.getArgumentName(i) + " -- error occurred while processing Java glue code for " + this.getName());
                }
                writer.print(this.offsetArgName(i));
            }
            needComma = true;
            ++numArgsEmitted;
        }
        return numArgsEmitted;
    }

    protected void emitPostCallCleanup(MethodBinding binding, PrintWriter writer) {
        if (binding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < binding.getNumArguments(); ++i) {
                JavaType javaArgType = binding.getJavaArgumentType(i);
                if (!javaArgType.isArrayOfCompoundTypeWrappers()) continue;
                String argName = binding.getArgumentName(i);
                writer.println("    for (int _ctr = 0; _ctr < " + argName + ".length; _ctr++) {");
                writer.println("      if ((" + argName + "[_ctr] == null && " + argName + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) ||");
                writer.println("          (" + argName + "[_ctr] != null && " + argName + "[_ctr].getBuffer() == " + argName + COMPOUND_ARRAY_SUFFIX + "[_ctr])) {");
                writer.println("        // No copy back needed");
                writer.println("      } else {");
                writer.println("        if (" + argName + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) {");
                writer.println("          " + argName + "[_ctr] = null;");
                writer.println("        } else {");
                writer.println("          " + argName + "[_ctr] = " + javaArgType.getName() + ".create(" + argName + COMPOUND_ARRAY_SUFFIX + "[_ctr]);");
                writer.println("        }");
                writer.println("      }");
                writer.println("    }");
            }
        }
    }

    protected void emitCallResultReturn(MethodBinding binding, PrintWriter writer) {
        JavaType returnType = binding.getJavaReturnType();
        if (returnType.isCompoundTypeWrapper()) {
            String fmt = this.getReturnedArrayLengthExpression();
            writer.println("    if (_res == null) return null;");
            if (fmt == null) {
                writer.print("    return " + returnType.getName() + ".create(BufferFactory.nativeOrder(_res))");
            } else {
                writer.println("    BufferFactory.nativeOrder(_res);");
                String expr = new MessageFormat(fmt).format(this.argumentNameArray());
                PointerType cReturnTypePointer = binding.getCReturnType().asPointer();
                CompoundType cReturnType = null;
                if (cReturnTypePointer != null) {
                    cReturnType = cReturnTypePointer.getTargetType().asCompound();
                }
                if (cReturnType == null) {
                    throw new RuntimeException("ReturnedArrayLength directive currently only supported for pointers to compound types (error occurred while generating Java glue code for " + this.getName() + ")");
                }
                writer.println("    " + this.getReturnTypeString(false) + " _retarray = new " + this.getReturnTypeString(true) + "[" + expr + "];");
                writer.println("    for (int _count = 0; _count < " + expr + "; _count++) {");
                writer.println("      _res.position(_count * " + this.getReturnTypeString(true) + ".size());");
                writer.println("      _res.limit   ((1 + _count) * " + this.getReturnTypeString(true) + ".size());");
                writer.println("      java.nio.ByteBuffer _tmp = _res.slice();");
                writer.println("      BufferFactory.nativeOrder(_tmp);");
                writer.println("      _res.position(0);");
                writer.println("      _res.limit(_res.capacity());");
                writer.println("      _retarray[_count] = " + this.getReturnTypeString(true) + ".create(_tmp);");
                writer.println("    }");
                writer.print("    return _retarray");
            }
            writer.println(";");
        } else if (returnType.isNIOBuffer()) {
            writer.println("    if (_res == null) return null;");
            writer.println("    BufferFactory.nativeOrder(_res);");
            if (!returnType.isNIOByteBuffer()) {
                if (this.getBinding().getCReturnType().pointerDepth() >= 2) {
                    if (!returnType.isNIOPointerBuffer()) {
                        throw new RuntimeException("While emitting glue code for " + this.getName() + ": can not legally make pointers opaque to anything but longs");
                    }
                    writer.println("    return PointerBuffer.wrapNative2Java(_res, false);");
                } else {
                    String returnTypeName = returnType.getName().substring("java.nio.".length());
                    writer.println("    return _res.as" + returnTypeName + "();");
                }
            } else {
                writer.println("    return _res;");
            }
        } else if (returnType.isArrayOfCompoundTypeWrappers()) {
            writer.println("    if (_res == null) return null;");
            writer.println("    " + this.getReturnTypeString(false) + " _retarray = new " + this.getReturnTypeString(true) + "[_res.length];");
            writer.println("    for (int _count = 0; _count < _res.length; _count++) {");
            writer.println("      _retarray[_count] = " + this.getReturnTypeString(true) + ".create(_res[_count]);");
            writer.println("    }");
            writer.println("    return _retarray;");
        } else {
            writer.println("    return _res;");
        }
    }

    protected String[] argumentNameArray() {
        String[] argumentNames = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            argumentNames[i] = this.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            argumentNames[i] = argumentNames[i] + ", " + this.offsetArgName(i);
        }
        return argumentNames;
    }

    public static String javaThisArgumentName() {
        return "jthis0";
    }

    @Override
    protected String getCommentStartString() {
        return "/** ";
    }

    @Override
    protected String getBaseIndentString() {
        return "  ";
    }

    protected String getReturnedArrayLengthExpression() {
        return this.returnedArrayLengthExpression;
    }

    protected class InterfaceCommentEmitter
    extends DefaultCommentEmitter {
        protected InterfaceCommentEmitter() {
        }

        @Override
        protected void emitBeginning(FunctionEmitter emitter, PrintWriter writer) {
            writer.print("Interface to C language function: <br> ");
        }
    }

    protected class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter emitter, PrintWriter writer) {
            this.emitBeginning(emitter, writer);
            this.emitBindingCSignature(((JavaMethodBindingEmitter)emitter).getBinding(), writer);
            this.emitEnding(emitter, writer);
        }

        protected void emitBeginning(FunctionEmitter emitter, PrintWriter writer) {
            writer.print("Entry point to C language function: ");
        }

        protected void emitBindingCSignature(MethodBinding binding, PrintWriter writer) {
            writer.print("<code> ");
            writer.print(binding.getCSymbol().toString(JavaMethodBindingEmitter.this.tagNativeBinding));
            writer.print(" </code> ");
        }

        protected void emitEnding(FunctionEmitter emitter, PrintWriter writer) {
            MethodBinding binding = ((JavaMethodBindingEmitter)emitter).getBinding();
            for (int i = 0; i < binding.getNumArguments(); ++i) {
                Type type = binding.getCArgumentType(i);
                JavaType javaType = binding.getJavaArgumentType(i);
                if (type.isEnum() && type.getName() != "<anonymous>") {
                    EnumType enumType = (EnumType)type;
                    writer.println();
                    writer.print(emitter.getBaseIndentString());
                    writer.print("    ");
                    writer.print("@param ");
                    writer.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                    writer.print(" valid values are: <code>");
                    for (int j = 0; j < enumType.getNumEnumerates(); ++j) {
                        if (j > 0) {
                            writer.print(", ");
                        }
                        writer.print(enumType.getEnumName(j));
                    }
                    writer.println("</code>");
                    continue;
                }
                if (!JavaMethodBindingEmitter.this.directNIOOnly || !javaType.isNIOBuffer()) continue;
                writer.println();
                writer.print(emitter.getBaseIndentString());
                writer.print("    ");
                writer.print("@param ");
                writer.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                writer.print(" a direct {@link " + javaType.getName() + "}");
            }
        }
    }
}

