/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.runtime.PointerBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class JavaType {
    private static final int PTR_C_VOID = 1;
    private static final int PTR_C_CHAR = 2;
    private static final int PTR_C_SHORT = 3;
    private static final int PTR_C_INT32 = 4;
    private static final int PTR_C_INT64 = 5;
    private static final int PTR_C_FLOAT = 6;
    private static final int PTR_C_DOUBLE = 7;
    private Class clazz;
    private String name;
    private Type elementType;
    private int primitivePointerType;
    private static JavaType nioBufferType;
    private static JavaType nioByteBufferType;
    private static JavaType nioShortBufferType;
    private static JavaType nioIntBufferType;
    private static JavaType nioLongBufferType;
    private static JavaType nioPointerBufferType;
    private static JavaType nioFloatBufferType;
    private static JavaType nioDoubleBufferType;
    private static JavaType nioByteBufferArrayType;

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof JavaType)) {
            return false;
        }
        JavaType t = (JavaType)arg;
        return this == t || t.clazz == this.clazz && (this.name == t.name || this.name != null && t.name != null && this.name.equals(t.name)) && (this.elementType == t.elementType || this.elementType != null && t.elementType != null && this.elementType.equals((Object)t.elementType)) && this.primitivePointerType == t.primitivePointerType;
    }

    public int hashCode() {
        if (this.clazz == null) {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
        return this.clazz.hashCode();
    }

    public JavaType getElementType() {
        return new JavaType(this.elementType);
    }

    public static JavaType createForClass(Class clazz) {
        return new JavaType(clazz);
    }

    public static JavaType createForCStruct(String name) {
        return new JavaType(name);
    }

    public static JavaType createForCArray(Type elementType) {
        return new JavaType(elementType);
    }

    public static JavaType createForVoidPointer() {
        return new JavaType(1);
    }

    public static JavaType createForCCharPointer() {
        return new JavaType(2);
    }

    public static JavaType createForCShortPointer() {
        return new JavaType(3);
    }

    public static JavaType createForCInt32Pointer() {
        return new JavaType(4);
    }

    public static JavaType createForCInt64Pointer() {
        return new JavaType(5);
    }

    public static JavaType createForCFloatPointer() {
        return new JavaType(6);
    }

    public static JavaType createForCDoublePointer() {
        return new JavaType(7);
    }

    public static JavaType createForJNIEnv() {
        return JavaType.createForCStruct("JNIEnv");
    }

    public static JavaType forNIOBufferClass() {
        if (nioBufferType == null) {
            nioBufferType = JavaType.createForClass(Buffer.class);
        }
        return nioBufferType;
    }

    public static JavaType forNIOByteBufferClass() {
        if (nioByteBufferType == null) {
            nioByteBufferType = JavaType.createForClass(ByteBuffer.class);
        }
        return nioByteBufferType;
    }

    public static JavaType forNIOShortBufferClass() {
        if (nioShortBufferType == null) {
            nioShortBufferType = JavaType.createForClass(ShortBuffer.class);
        }
        return nioShortBufferType;
    }

    public static JavaType forNIOIntBufferClass() {
        if (nioIntBufferType == null) {
            nioIntBufferType = JavaType.createForClass(IntBuffer.class);
        }
        return nioIntBufferType;
    }

    public static JavaType forNIOLongBufferClass() {
        if (nioLongBufferType == null) {
            nioLongBufferType = JavaType.createForClass(LongBuffer.class);
        }
        return nioLongBufferType;
    }

    public static JavaType forNIOPointerBufferClass() {
        if (nioPointerBufferType == null) {
            nioPointerBufferType = JavaType.createForClass(PointerBuffer.class);
        }
        return nioPointerBufferType;
    }

    public static JavaType forNIOFloatBufferClass() {
        if (nioFloatBufferType == null) {
            nioFloatBufferType = JavaType.createForClass(FloatBuffer.class);
        }
        return nioFloatBufferType;
    }

    public static JavaType forNIODoubleBufferClass() {
        if (nioDoubleBufferType == null) {
            nioDoubleBufferType = JavaType.createForClass(DoubleBuffer.class);
        }
        return nioDoubleBufferType;
    }

    public static JavaType forNIOByteBufferArrayClass() {
        if (nioByteBufferArrayType == null) {
            ByteBuffer[] tmp = new ByteBuffer[]{};
            nioByteBufferArrayType = JavaType.createForClass(tmp.getClass());
        }
        return nioByteBufferArrayType;
    }

    public Class getJavaClass() {
        return this.clazz;
    }

    public String getName() {
        if (this.clazz != null) {
            if (this.clazz.isArray()) {
                return this.arrayName(this.clazz);
            }
            return this.clazz.getName();
        }
        if (this.elementType != null) {
            return this.elementType.getName();
        }
        return this.name;
    }

    public String getDescriptor() {
        if (this.clazz != null) {
            return this.descriptor(this.clazz);
        }
        if (this.elementType != null) {
            if (this.elementType.getName() == null) {
                throw new RuntimeException("elementType.name is null: " + this.getDumpString());
            }
            return "[" + this.descriptor(this.elementType.getName());
        }
        return this.descriptor(this.name);
    }

    public String jniTypeName() {
        if (this.isCompoundTypeWrapper()) {
            return "jobject";
        }
        if (this.isArrayOfCompoundTypeWrappers()) {
            return "jobjectArray /* of ByteBuffer */";
        }
        if (this.clazz == null) {
            return null;
        }
        if (this.isVoid()) {
            return "void";
        }
        if (this.isPrimitive()) {
            return "j" + this.clazz.getName();
        }
        if (this.isPrimitiveArray() || this.isNIOBuffer()) {
            return "jobject";
        }
        if (this.isArray()) {
            if (this.isStringArray()) {
                return "jobjectArray /*elements are String*/";
            }
            Class<?> elementType = this.clazz.getComponentType();
            if (this.isNIOBufferArray()) {
                return "jobjectArray /*elements are " + elementType.getName() + "*/";
            }
            if (elementType.isArray()) {
                if (elementType.getComponentType().isPrimitive()) {
                    return "jobjectArray /* elements are " + elementType.getComponentType() + "[]*/";
                }
                throw new RuntimeException("Multi-dimensional arrays of types that are not primitives or Strings are not supported.");
            }
            throw new RuntimeException("Unexpected and unsupported array type: \"" + this + "\"");
        }
        if (this.isString()) {
            return "jstring";
        }
        return "jobject";
    }

    public boolean isNIOBuffer() {
        return this.clazz != null && (Buffer.class.isAssignableFrom(this.clazz) || PointerBuffer.class.isAssignableFrom(this.clazz));
    }

    public boolean isNIOByteBuffer() {
        return this.clazz == ByteBuffer.class;
    }

    public boolean isNIOByteBufferArray() {
        return this == nioByteBufferArrayType;
    }

    public boolean isNIOBufferArray() {
        return this.isArray() && Buffer.class.isAssignableFrom(this.clazz.getComponentType());
    }

    public boolean isNIOLongBuffer() {
        return this.clazz == LongBuffer.class;
    }

    public boolean isNIOPointerBuffer() {
        return this.clazz == PointerBuffer.class;
    }

    public boolean isString() {
        return this.clazz == String.class;
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    public boolean isFloatArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Float.TYPE;
    }

    public boolean isDoubleArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Double.TYPE;
    }

    public boolean isByteArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Byte.TYPE;
    }

    public boolean isIntArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Integer.TYPE;
    }

    public boolean isShortArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Short.TYPE;
    }

    public boolean isLongArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Long.TYPE;
    }

    public boolean isStringArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == String.class;
    }

    public boolean isPrimitive() {
        return this.clazz != null && !this.isArray() && this.clazz.isPrimitive() && this.clazz != Void.TYPE;
    }

    public boolean isPrimitiveArray() {
        return this.isArray() && this.clazz.getComponentType().isPrimitive();
    }

    public boolean isShort() {
        return this.clazz == Short.TYPE;
    }

    public boolean isFloat() {
        return this.clazz == Float.TYPE;
    }

    public boolean isDouble() {
        return this.clazz == Double.TYPE;
    }

    public boolean isByte() {
        return this.clazz == Byte.TYPE;
    }

    public boolean isLong() {
        return this.clazz == Long.TYPE;
    }

    public boolean isInt() {
        return this.clazz == Integer.TYPE;
    }

    public boolean isVoid() {
        return this.clazz == Void.TYPE;
    }

    public boolean isCompoundTypeWrapper() {
        return this.clazz == null && this.name != null && !this.isJNIEnv();
    }

    public boolean isArrayOfCompoundTypeWrappers() {
        return this.elementType != null;
    }

    public boolean isCPrimitivePointerType() {
        return this.primitivePointerType != 0;
    }

    public boolean isCVoidPointerType() {
        return this.primitivePointerType == 1;
    }

    public boolean isCCharPointerType() {
        return this.primitivePointerType == 2;
    }

    public boolean isCShortPointerType() {
        return this.primitivePointerType == 3;
    }

    public boolean isCInt32PointerType() {
        return this.primitivePointerType == 4;
    }

    public boolean isCInt64PointerType() {
        return this.primitivePointerType == 5;
    }

    public boolean isCFloatPointerType() {
        return this.primitivePointerType == 6;
    }

    public boolean isCDoublePointerType() {
        return this.primitivePointerType == 7;
    }

    public boolean isJNIEnv() {
        return this.clazz == null && this.name == "JNIEnv";
    }

    public Object clone() {
        JavaType clone = new JavaType(this.primitivePointerType);
        clone.clazz = this.clazz;
        clone.name = this.name;
        clone.elementType = this.elementType;
        return clone;
    }

    public String toString() {
        return this.getName();
    }

    public String getDumpString() {
        return "[clazz = " + this.clazz + " , name = " + this.name + " , elementType = " + this.elementType + " , primitivePointerType = " + this.primitivePointerType + "]";
    }

    public void dump() {
        System.err.println(this.getDumpString());
    }

    private JavaType(Class clazz) {
        this.clazz = clazz;
    }

    private JavaType(String name) {
        this.name = name;
    }

    private JavaType(Type elementType) {
        this.elementType = elementType;
    }

    private JavaType(int primitivePointerType) {
        this.primitivePointerType = primitivePointerType;
    }

    private String arrayName(Class clazz) {
        StringBuffer buf = new StringBuffer();
        int arrayCount = 0;
        while (clazz.isArray()) {
            ++arrayCount;
            clazz = clazz.getComponentType();
        }
        buf.append(clazz.getName());
        while (--arrayCount >= 0) {
            buf.append("[]");
        }
        return buf.toString();
    }

    private String arrayDescriptor(Class clazz) {
        StringBuffer buf = new StringBuffer();
        boolean arrayCount = false;
        while (clazz.isArray()) {
            buf.append("[");
            clazz = clazz.getComponentType();
        }
        buf.append(this.descriptor(clazz));
        return buf.toString();
    }

    private String descriptor(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unexpected primitive type " + clazz.getName());
        }
        if (clazz.isArray()) {
            return this.arrayDescriptor(clazz);
        }
        return this.descriptor(clazz.getName());
    }

    private String descriptor(String referenceTypeName) {
        return "L" + referenceTypeName.replace('.', '/') + ";";
    }
}

