/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.JavaType;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.cgram.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MethodBinding {
    private FunctionSymbol sym;
    private String renamedMethodName;
    private HashSet aliasedNames;
    private JavaType javaReturnType;
    private List javaArgumentTypes;
    private boolean computedSignatureProperties;
    private boolean argumentsUseNIO;
    private boolean signatureUsesNIO;
    private boolean signatureCanUseIndirectNIO;
    private boolean signatureUsesCompoundTypeWrappers;
    private boolean signatureUsesArraysOfCompoundTypeWrappers;
    private boolean signatureUsesCVoidPointers;
    private boolean signatureUsesCPrimitivePointers;
    private boolean signatureUsesCArrays;
    private boolean signatureUsesJavaPrimitiveArrays;
    private JavaType containingType;
    private Type containingCType;
    private int thisPointerIndex = -1;

    public MethodBinding(MethodBinding bindingToCopy) {
        this.sym = bindingToCopy.sym;
        this.renamedMethodName = bindingToCopy.renamedMethodName;
        this.aliasedNames = new HashSet();
        this.aliasedNames.addAll(bindingToCopy.aliasedNames);
        this.containingType = bindingToCopy.containingType;
        this.containingCType = bindingToCopy.containingCType;
        this.javaReturnType = bindingToCopy.javaReturnType;
        this.javaArgumentTypes = (List)((ArrayList)bindingToCopy.javaArgumentTypes).clone();
        this.computedSignatureProperties = bindingToCopy.computedSignatureProperties;
        this.argumentsUseNIO = bindingToCopy.argumentsUseNIO;
        this.signatureUsesNIO = bindingToCopy.signatureUsesNIO;
        this.signatureCanUseIndirectNIO = bindingToCopy.signatureCanUseIndirectNIO;
        this.signatureUsesCompoundTypeWrappers = bindingToCopy.signatureUsesCompoundTypeWrappers;
        this.signatureUsesArraysOfCompoundTypeWrappers = bindingToCopy.signatureUsesArraysOfCompoundTypeWrappers;
        this.signatureUsesCVoidPointers = bindingToCopy.signatureUsesCVoidPointers;
        this.signatureUsesCPrimitivePointers = bindingToCopy.signatureUsesCPrimitivePointers;
        this.signatureUsesCArrays = bindingToCopy.signatureUsesCArrays;
        this.signatureUsesJavaPrimitiveArrays = bindingToCopy.signatureUsesJavaPrimitiveArrays;
        this.thisPointerIndex = bindingToCopy.thisPointerIndex;
    }

    public MethodBinding(FunctionSymbol sym) {
        this.sym = sym;
        this.aliasedNames = new HashSet();
    }

    public MethodBinding(FunctionSymbol sym, JavaType containingType, Type containingCType) {
        this.sym = sym;
        this.containingType = containingType;
        this.containingCType = containingCType;
        this.aliasedNames = new HashSet();
    }

    public void setJavaReturnType(JavaType type) {
        this.javaReturnType = type;
        this.computedSignatureProperties = false;
    }

    public void addJavaArgumentType(JavaType type) {
        if (this.javaArgumentTypes == null) {
            this.javaArgumentTypes = new ArrayList();
        }
        this.javaArgumentTypes.add(type);
        this.computedSignatureProperties = false;
    }

    public JavaType getJavaReturnType() {
        return this.javaReturnType;
    }

    public int getNumArguments() {
        return this.sym.getNumArguments();
    }

    public JavaType getJavaArgumentType(int i) {
        return (JavaType)this.javaArgumentTypes.get(i);
    }

    public Type getCReturnType() {
        return this.sym.getReturnType();
    }

    public Type getCArgumentType(int i) {
        return this.sym.getArgumentType(i);
    }

    public FunctionSymbol getCSymbol() {
        return this.sym;
    }

    public String getArgumentName(int i) {
        String ret = this.sym.getArgumentName(i);
        if (ret != null) {
            return ret;
        }
        return "arg" + i;
    }

    public String getOrigName() {
        return this.sym.getName();
    }

    public String getName() {
        if (this.renamedMethodName != null) {
            return this.renamedMethodName;
        }
        return this.sym.getName();
    }

    public void renameMethodName(String name) {
        if (null != name) {
            this.renamedMethodName = name;
            this.aliasedNames.add(this.sym.getName());
        }
    }

    public void addAliasedName(String name) {
        this.aliasedNames.add(name);
    }

    public Collection getAliasedNames() {
        return this.aliasedNames;
    }

    public MethodBinding replaceJavaArgumentType(int argumentNumber, JavaType newArgType) {
        MethodBinding binding = (MethodBinding)this.clone();
        binding.javaArgumentTypes = null;
        if (argumentNumber < 0) {
            binding.setJavaReturnType(newArgType);
        } else {
            binding.setJavaReturnType(this.javaReturnType);
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType type = this.getJavaArgumentType(i);
            if (i == argumentNumber) {
                type = newArgType;
            }
            binding.addJavaArgumentType(type);
        }
        return binding;
    }

    public boolean argumentsUseNIO() {
        this.computeSignatureProperties();
        return this.argumentsUseNIO;
    }

    public boolean signatureUsesNIO() {
        this.computeSignatureProperties();
        return this.signatureUsesNIO;
    }

    public boolean signatureCanUseIndirectNIO() {
        this.computeSignatureProperties();
        return this.signatureCanUseIndirectNIO;
    }

    public boolean signatureUsesCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesCompoundTypeWrappers;
    }

    public boolean signatureUsesArraysOfCompoundTypeWrappers() {
        this.computeSignatureProperties();
        return this.signatureUsesArraysOfCompoundTypeWrappers;
    }

    public boolean needsNIOWrappingOrUnwrapping() {
        return this.signatureUsesNIO() || this.signatureUsesCompoundTypeWrappers();
    }

    public boolean signatureUsesCVoidPointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCVoidPointers;
    }

    public boolean signatureUsesCPrimitivePointers() {
        this.computeSignatureProperties();
        return this.signatureUsesCPrimitivePointers;
    }

    public boolean signatureUsesCArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesCArrays;
    }

    public boolean signatureUsesJavaPrimitiveArrays() {
        this.computeSignatureProperties();
        return this.signatureUsesJavaPrimitiveArrays;
    }

    protected void computeSignatureProperties() {
        Type cRetType;
        if (this.computedSignatureProperties) {
            return;
        }
        this.argumentsUseNIO = false;
        this.signatureUsesNIO = false;
        this.signatureCanUseIndirectNIO = false;
        this.signatureUsesCompoundTypeWrappers = false;
        this.signatureUsesArraysOfCompoundTypeWrappers = false;
        this.signatureUsesCVoidPointers = false;
        this.signatureUsesCPrimitivePointers = false;
        this.signatureUsesCArrays = false;
        this.signatureUsesJavaPrimitiveArrays = false;
        if (this.javaReturnType.isCompoundTypeWrapper()) {
            this.signatureUsesCompoundTypeWrappers = true;
        }
        if (this.javaReturnType.isNIOBuffer() || this.javaReturnType.isArrayOfCompoundTypeWrappers()) {
            this.signatureUsesNIO = true;
        }
        if ((cRetType = this.sym.getReturnType()).isArray()) {
            this.signatureUsesCArrays = true;
            if (cRetType.asArray().getElementType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            }
        }
        if (cRetType.isPointer()) {
            if (cRetType.asPointer().getTargetType().isPrimitive()) {
                this.signatureUsesCPrimitivePointers = true;
            } else if (cRetType.asPointer().getTargetType().isVoid()) {
                this.signatureUsesCVoidPointers = true;
            }
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType javaArgType = this.getJavaArgumentType(i);
            Type cArgType = this.getCArgumentType(i);
            if (javaArgType.isCompoundTypeWrapper()) {
                this.signatureUsesCompoundTypeWrappers = true;
            }
            if (javaArgType.isArrayOfCompoundTypeWrappers()) {
                this.signatureUsesArraysOfCompoundTypeWrappers = true;
            }
            if (javaArgType.isNIOBuffer() || javaArgType.isNIOBufferArray()) {
                this.signatureUsesNIO = true;
                this.argumentsUseNIO = true;
                if (javaArgType.isNIOBuffer()) {
                    this.signatureCanUseIndirectNIO = true;
                }
            }
            if (cArgType.isArray()) {
                this.signatureUsesCArrays = true;
                if (cArgType.asArray().getElementType().isPrimitive()) {
                    this.signatureUsesCPrimitivePointers = true;
                }
            }
            if (cArgType.isPointer()) {
                if (cArgType.asPointer().getTargetType().isPrimitive() || javaArgType.isCPrimitivePointerType()) {
                    this.signatureUsesCPrimitivePointers = true;
                } else if (cArgType.asPointer().getTargetType().isVoid()) {
                    this.signatureUsesCVoidPointers = true;
                }
            }
            if (!javaArgType.isPrimitiveArray()) continue;
            this.signatureUsesJavaPrimitiveArrays = true;
        }
        this.computedSignatureProperties = true;
    }

    public boolean hasContainingType() {
        return this.getContainingType() != null;
    }

    public JavaType getContainingType() {
        return this.containingType;
    }

    public Type getContainingCType() {
        return this.containingCType;
    }

    public void findThisPointer() {
        this.clearThisPointer();
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType arg = this.getJavaArgumentType(i);
            if (arg.equals(this.containingType)) {
                this.thisPointerIndex = i;
                break;
            }
            if (!arg.isJNIEnv()) break;
        }
    }

    public void clearThisPointer() {
        this.thisPointerIndex = -1;
    }

    public boolean isArgumentThisPointer(int i) {
        return this.thisPointerIndex == i;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodBinding)) {
            return false;
        }
        MethodBinding other = (MethodBinding)obj;
        if (!this.getName().equals(other.getName()) || !this.sym.getType().equals((Object)other.sym.getType())) {
            return false;
        }
        if (!this.javaReturnType.equals(other.getJavaReturnType())) {
            return false;
        }
        if (this.containingCType != null && other.getContainingCType() != null && !this.containingCType.equals((Object)other.getContainingCType())) {
            return false;
        }
        if (this.javaArgumentTypes.size() != other.javaArgumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.javaArgumentTypes.size(); ++i) {
            JavaType typeOther;
            Object typeThis = this.javaArgumentTypes.get(i);
            if (typeThis.equals(typeOther = other.getJavaArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuffer buf = new StringBuffer(200);
        buf.append(this.getName());
        buf.append(this.sym.getType().getName(true));
        buf.append(this.getJavaReturnType().getName());
        if (this.containingCType != null) {
            buf.append(this.containingCType.getName(true));
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType type = this.getJavaArgumentType(i);
            if (type.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            buf.append(type.getName());
        }
        return buf.toString().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append(this.getJavaReturnType().getName());
        buf.append(" ");
        buf.append(this.getName());
        buf.append("(");
        boolean needComma = false;
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType type = this.getJavaArgumentType(i);
            if (type.isVoid()) {
                assert (this.getNumArguments() == 1);
                continue;
            }
            if (type.isJNIEnv() || this.isArgumentThisPointer(i)) continue;
            if (needComma) {
                buf.append(", ");
            }
            buf.append(type.getName());
            buf.append(" ");
            buf.append(this.getArgumentName(i));
            needComma = true;
        }
        buf.append(")");
        return buf.toString();
    }

    public final Object clone() {
        return new MethodBinding(this);
    }

    public String getDescriptor(boolean forImplementingMethodCall, boolean eraseBufferAndArrayTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (forImplementingMethodCall && this.hasContainingType()) {
            buf.append("Ljava/nio/ByteBuffer;");
        }
        for (int i = 0; i < this.getNumArguments(); ++i) {
            JavaType type = this.getJavaArgumentType(i);
            if (type.isVoid()) {
                if (this.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this + "\"");
            }
            if (type.isJNIEnv() || this.isArgumentThisPointer(i)) continue;
            buf.append(this.erasedTypeDescriptor(type, eraseBufferAndArrayTypes, false));
            if (forImplementingMethodCall) {
                if (type.isNIOBuffer()) {
                    buf.append("I");
                } else if (type.isNIOBufferArray()) {
                    buf.append("[I");
                }
            }
            if (!type.isPrimitiveArray()) continue;
            buf.append("I");
        }
        buf.append(")");
        buf.append(this.erasedTypeDescriptor(this.getJavaReturnType(), eraseBufferAndArrayTypes, false));
        return buf.toString();
    }

    protected String erasedTypeDescriptor(JavaType type, boolean eraseBufferAndArrayTypes, boolean skipBuffers) {
        if (eraseBufferAndArrayTypes) {
            if (type.isNIOBuffer() || type.isPrimitiveArray()) {
                if (!skipBuffers) {
                    return "Ljava/lang/Object;";
                }
            } else {
                if (type.isCompoundTypeWrapper()) {
                    return "Ljava/nio/ByteBuffer;";
                }
                if (type.isArrayOfCompoundTypeWrappers()) {
                    return "Ljava/nio/ByteBuffer;";
                }
            }
        }
        return type.getDescriptor();
    }
}

