/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen;

import com.sun.gluegen.cgram.types.ArrayType;
import com.sun.gluegen.cgram.types.CompoundType;
import com.sun.gluegen.cgram.types.Field;
import com.sun.gluegen.cgram.types.SizeThunk;
import com.sun.gluegen.cgram.types.Type;

public class StructLayout {
    private int baseOffset;
    private int structAlignment;

    protected StructLayout(int baseOffset, int structAlignment) {
        this.baseOffset = baseOffset;
        this.structAlignment = structAlignment;
    }

    public void layout(CompoundType t) {
        int n = t.getNumFields();
        SizeThunk curOffset = SizeThunk.constant((int)this.baseOffset);
        SizeThunk maxSize = SizeThunk.constant((int)0);
        for (int i = 0; i < n; ++i) {
            Field f = t.getField(i);
            Type ft = f.getType();
            if (ft.isInt() || ft.isFloat() || ft.isDouble() || ft.isPointer()) {
                SizeThunk sz = ft.getSize();
                curOffset = SizeThunk.roundUp((SizeThunk)curOffset, (SizeThunk)sz);
                f.setOffset(curOffset);
                if (t.isUnion()) {
                    maxSize = SizeThunk.max((SizeThunk)maxSize, (SizeThunk)sz);
                    continue;
                }
                curOffset = SizeThunk.add((SizeThunk)curOffset, (SizeThunk)sz);
                continue;
            }
            if (ft.isCompound()) {
                new StructLayout(0, this.structAlignment).layout(ft.asCompound());
                curOffset = SizeThunk.roundUp((SizeThunk)curOffset, (SizeThunk)SizeThunk.constant((int)this.structAlignment));
                f.setOffset(curOffset);
                if (t.isUnion()) {
                    maxSize = SizeThunk.max((SizeThunk)maxSize, (SizeThunk)ft.getSize());
                    continue;
                }
                curOffset = SizeThunk.add((SizeThunk)curOffset, (SizeThunk)ft.getSize());
                continue;
            }
            if (ft.isArray()) {
                ArrayType arrayType = ft.asArray();
                CompoundType compoundElementType = arrayType.getBaseElementType().asCompound();
                if (compoundElementType != null) {
                    new StructLayout(0, this.structAlignment).layout(compoundElementType);
                    arrayType.recomputeSize();
                }
                curOffset = SizeThunk.roundUp((SizeThunk)curOffset, (SizeThunk)SizeThunk.constant((int)this.structAlignment));
                f.setOffset(curOffset);
                curOffset = SizeThunk.add((SizeThunk)curOffset, (SizeThunk)ft.getSize());
                continue;
            }
            String name = t.getName();
            if (name == null) {
                name = t.toString();
            }
            throw new RuntimeException("Complicated field types (" + ft + " " + f.getName() + " in type " + name + ") not implemented yet");
        }
        if (t.isUnion()) {
            t.setSize(maxSize);
        } else {
            t.setSize(curOffset);
        }
    }

    public static StructLayout createForCurrentPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String cpu = System.getProperty("os.arch").toLowerCase();
        if (os.startsWith("windows") && cpu.equals("x86")) {
            return new StructLayout(0, 4);
        }
        if (os.startsWith("windows") && cpu.equals("amd64") || os.startsWith("linux") && cpu.equals("i386") || os.startsWith("linux") && cpu.equals("x86") || os.startsWith("linux") && cpu.equals("amd64") || os.startsWith("linux") && cpu.equals("x86_64") || os.startsWith("linux") && cpu.equals("ia64") || os.startsWith("sunos") && cpu.equals("sparc") || os.startsWith("sunos") && cpu.equals("sparcv9") || os.startsWith("sunos") && cpu.equals("x86") || os.startsWith("sunos") && cpu.equals("amd64") || os.startsWith("mac os") && cpu.equals("ppc") || os.startsWith("mac os") && cpu.equals("i386") || os.startsWith("mac os") && cpu.equals("x86_64") || os.startsWith("freebsd") && cpu.equals("i386") || os.startsWith("hp-ux") && cpu.equals("pa_risc2.0")) {
            return new StructLayout(0, 8);
        }
        throw new RuntimeException("Please port StructLayout to your OS (" + os + ") and CPU (" + cpu + ")");
    }
}

