/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.ant;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class GlueGenTask
extends Task {
    private static final String GLUE_GEN = "com.sun.gluegen.GlueGen";
    private CommandlineJava gluegenCommandline;
    private String outputRootDir;
    private String emitter;
    private String configuration;
    private String sourceFile;
    private FileSet includeSet = new FileSet();
    private boolean usedIncludeSet = false;
    private List setOfIncludeSets = new LinkedList();
    private String literalInclude;

    public GlueGenTask() {
        this.gluegenCommandline = new CommandlineJava();
        this.gluegenCommandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.gluegenCommandline.setClassname(GLUE_GEN);
    }

    public void setOutputRootDir(String outputRootDir) {
        this.log("Setting output root dir: " + outputRootDir, 3);
        this.outputRootDir = outputRootDir;
    }

    public void setEmitter(String emitter) {
        this.log("Setting emitter class name to: " + emitter, 3);
        this.emitter = emitter;
    }

    public void setConfig(String configuration) {
        this.log("Setting configuration file name to: " + configuration, 3);
        this.configuration = configuration;
    }

    public void setSrc(String sourceFile) {
        this.log("Setting source file name to: " + sourceFile, 3);
        this.sourceFile = sourceFile;
    }

    public void setLiteralInclude(String directory) {
        this.literalInclude = directory;
    }

    public PatternSet.NameEntry createInclude() {
        this.usedIncludeSet = true;
        return this.includeSet.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        this.usedIncludeSet = true;
        return this.includeSet.createIncludesFile();
    }

    public void setIncludes(String includes) {
        this.usedIncludeSet = true;
        this.includeSet.setIncludes(includes);
    }

    public PatternSet.NameEntry createExclude() {
        this.usedIncludeSet = true;
        return this.includeSet.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        this.usedIncludeSet = true;
        return this.includeSet.createExcludesFile();
    }

    public void setExcludes(String excludes) {
        this.usedIncludeSet = true;
        this.includeSet.setExcludes(excludes);
    }

    public void setIncludeRefid(Reference reference) {
        Object referencedObject = reference.getReferencedObject(this.getProject());
        if (!(referencedObject instanceof FileSet) && !(referencedObject instanceof DirSet)) {
            throw new BuildException("Only FileSets or DirSets are allowed as an include refid.");
        }
        this.setOfIncludeSets.add(referencedObject);
    }

    public void addDirset(DirSet dirset) {
        this.setOfIncludeSets.add(dirset);
    }

    public Path createClasspath() {
        return this.gluegenCommandline.createClasspath(this.project).createPath();
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.addAttributes();
        this.log(this.gluegenCommandline.describeCommand(), 3);
        int error = this.execute(this.gluegenCommandline.getCommandline());
        if (error == 1) {
            throw new BuildException("GlueGen returned: " + error, this.location);
        }
    }

    private void validateAttributes() throws BuildException {
        if (!this.isValid(this.emitter)) {
            throw new BuildException("Invalid emitter class name: " + this.emitter);
        }
        if (!this.isValid(this.configuration)) {
            throw new BuildException("Invalid configuration file name: " + this.configuration);
        }
        if (!this.isValid(this.sourceFile)) {
            throw new BuildException("Invalid source file name: " + this.sourceFile);
        }
    }

    private boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().length() >= 1;
    }

    private void addAttributes() throws BuildException {
        if (null != this.outputRootDir && this.outputRootDir.trim().length() > 0) {
            this.gluegenCommandline.createArgument().setValue("-O" + this.outputRootDir);
        }
        this.gluegenCommandline.createArgument().setValue("-E" + this.emitter);
        this.gluegenCommandline.createArgument().setValue("-C" + this.configuration);
        if (this.usedIncludeSet) {
            this.includeSet.setDir(this.getProject().getBaseDir());
            this.setOfIncludeSets.add(this.includeSet);
        }
        LinkedList<String> includedDirectories = new LinkedList<String>();
        for (Object include : this.setOfIncludeSets) {
            String[] directoryDirs;
            DirectoryScanner directoryScanner;
            if (include instanceof FileSet) {
                FileSet fileSet = (FileSet)include;
                directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                directoryDirs = directoryScanner.getIncludedDirectories();
            } else if (include instanceof DirSet) {
                DirSet dirSet = (DirSet)include;
                directoryScanner = dirSet.getDirectoryScanner(this.getProject());
                directoryDirs = directoryScanner.getIncludedDirectories();
            } else {
                throw new BuildException("Invalid included construct.");
            }
            for (int i = 0; i < directoryDirs.length; ++i) {
                includedDirectories.add(directoryDirs[i]);
            }
        }
        if (this.isValid(this.literalInclude)) {
            includedDirectories.add(this.literalInclude);
        }
        for (String directory : includedDirectories) {
            this.gluegenCommandline.createArgument().setValue("-I" + directory);
        }
        this.gluegenCommandline.createArgument().setValue(this.sourceFile);
    }

    private int execute(String[] command) throws BuildException {
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        execute.setAntRun(this.project);
        execute.setCommandline(command);
        execute.setWorkingDirectory(this.project.getBaseDir());
        try {
            return execute.execute();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe, this.location);
        }
    }
}

