/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.nativesig;

import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.nativesig.NativeSignatureEmitter;
import com.sun.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.sun.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import java.io.PrintWriter;

public class NativeSignatureJavaMethodBindingEmitter
extends GLJavaMethodBindingEmitter {
    public NativeSignatureJavaMethodBindingEmitter(GLJavaMethodBindingEmitter methodToWrap) {
        super(methodToWrap);
    }

    public NativeSignatureJavaMethodBindingEmitter(ProcAddressJavaMethodBindingEmitter methodToWrap) {
        super((GLJavaMethodBindingEmitter)methodToWrap);
    }

    public NativeSignatureJavaMethodBindingEmitter(JavaMethodBindingEmitter methodToWrap, NativeSignatureEmitter emitter) {
        super(methodToWrap, false, null, false, false, emitter);
    }

    @Override
    protected void emitSignature(PrintWriter writer) {
        writer.print(this.getBaseIndentString());
        this.emitNativeSignatureAnnotation(writer);
        super.emitSignature(writer);
    }

    protected void emitNativeSignatureAnnotation(PrintWriter writer) {
        if (this.hasModifier(JavaMethodBindingEmitter.NATIVE)) {
            writer.print("@NativeSignature(\"l");
            MethodBinding binding = this.getBinding();
            if (this.callThroughProcAddress) {
                writer.print("p");
            }
            writer.print("(");
            if (this.callThroughProcAddress) {
                writer.print("P");
            }
            for (int i = 0; i < binding.getNumArguments(); ++i) {
                this.emitNativeSignatureElement(writer, binding.getJavaArgumentType(i), binding.getCArgumentType(i), i);
            }
            writer.print(")");
            this.emitNativeSignatureElement(writer, binding.getJavaReturnType(), binding.getCReturnType(), -1);
            writer.println("\")");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitNativeSignatureElement(PrintWriter writer, JavaType type, Type cType, int index) {
        if (type.isVoid()) {
            if (index <= 0) return;
            throw new InternalError("Error parsing arguments -- void should not be seen aside from argument 0");
        }
        if (type.isNIOBuffer()) {
            writer.print("A");
            return;
        } else if (type.isPrimitiveArray()) {
            writer.print("MO");
            return;
        } else if (type.isPrimitive()) {
            Class clazz = type.getJavaClass();
            if (clazz == Byte.TYPE) {
                writer.print("B");
                return;
            } else if (clazz == Character.TYPE) {
                writer.print("C");
                return;
            } else if (clazz == Double.TYPE) {
                writer.print("D");
                return;
            } else if (clazz == Float.TYPE) {
                writer.print("F");
                return;
            } else if (clazz == Integer.TYPE) {
                writer.print("I");
                return;
            } else if (clazz == Long.TYPE) {
                if (cType.isPointer()) {
                    writer.print("A");
                    return;
                } else {
                    writer.print("J");
                }
                return;
            } else if (clazz == Short.TYPE) {
                writer.print("S");
                return;
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError("Unhandled primitive type " + clazz);
                writer.print("Z");
            }
            return;
        } else {
            if (!type.isString()) throw new RuntimeException("Type not yet handled: " + type);
            writer.print("A");
        }
    }

    @Override
    protected String getReturnTypeString(boolean skipArray) {
        JavaType returnType;
        if (this.isForImplementingMethodCall() && ((returnType = this.getBinding().getJavaReturnType()).isString() || returnType.isNIOByteBuffer())) {
            return "long";
        }
        return super.getReturnTypeString(skipArray);
    }

    @Override
    protected void emitPreCallSetup(MethodBinding binding, PrintWriter writer) {
        super.emitPreCallSetup(binding, writer);
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            JavaType type = binding.getJavaArgumentType(i);
            if (type.isNIOBuffer() && !this.directNIOOnly) {
                writer.println("  Object " + this.getNIOBufferArrayName(i) + " = (_direct ? null : BufferFactory.getArray(" + this.getArgumentName(i) + "));");
                continue;
            }
            if (!type.isString()) continue;
            writer.println("    long " + binding.getArgumentName(i) + "_c_str = BufferFactoryInternal.newCString(" + binding.getArgumentName(i) + ");");
        }
    }

    protected String getNIOBufferArrayName(int argNumber) {
        return "__buffer_array_" + argNumber;
    }

    @Override
    protected int emitArguments(PrintWriter writer) {
        boolean needComma = false;
        int numEmitted = 0;
        if (this.callThroughProcAddress && this.changeNameAndArguments) {
            writer.print("long procAddress");
            ++numEmitted;
            needComma = true;
        }
        if (this.forImplementingMethodCall && this.binding.hasContainingType()) {
            if (needComma) {
                writer.print(", ");
            }
            writer.print("long ");
            writer.print(NativeSignatureJavaMethodBindingEmitter.javaThisArgumentName());
            ++numEmitted;
            needComma = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType type = this.binding.getJavaArgumentType(i);
            if (type.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (type.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (needComma) {
                writer.print(", ");
            }
            if (this.forImplementingMethodCall && (this.forDirectBufferImplementation && type.isNIOBuffer() || type.isString())) {
                writer.print("long");
            } else {
                writer.print(this.erasedTypeString(type, false));
            }
            writer.print(" ");
            writer.print(this.getArgumentName(i));
            ++numEmitted;
            needComma = true;
            if (this.forIndirectBufferAndArrayImplementation) {
                if (type.isNIOBuffer()) {
                    writer.print(", int " + this.byteOffsetArgName(i));
                } else if (type.isNIOBufferArray()) {
                    writer.print(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!type.isPrimitiveArray()) continue;
            writer.print(", int " + this.offsetArgName(i));
        }
        return numEmitted;
    }

    @Override
    protected void emitReturnVariableSetupAndCall(MethodBinding binding, PrintWriter writer) {
        writer.print("    ");
        JavaType returnType = binding.getJavaReturnType();
        boolean needsResultAssignment = false;
        if (!returnType.isVoid()) {
            if (returnType.isCompoundTypeWrapper() || returnType.isNIOByteBuffer()) {
                writer.println("java.nio.ByteBuffer _res;");
                needsResultAssignment = true;
            } else if (returnType.isArrayOfCompoundTypeWrappers()) {
                writer.println("java.nio.ByteBuffer[] _res;");
                needsResultAssignment = true;
            } else if (returnType.isString() || returnType.isNIOByteBuffer()) {
                writer.print(returnType);
                writer.println(" _res;");
                needsResultAssignment = true;
            } else {
                this.emitReturnType(writer);
                writer.println(" _res;");
                needsResultAssignment = true;
            }
        }
        if (binding.signatureCanUseIndirectNIO() && !this.directNIOOnly) {
            writer.println("if (_direct) {");
            writer.print("    ");
        }
        if (needsResultAssignment) {
            writer.print("  _res = ");
            if (returnType.isString()) {
                writer.print("BufferFactoryInternal.newJavaString(");
            } else if (returnType.isNIOByteBuffer()) {
                writer.print("BufferFactoryInternal.newDirectByteBuffer(");
            }
        } else {
            writer.print("  ");
            if (!returnType.isVoid()) {
                writer.print("return ");
            }
        }
        if (binding.signatureUsesJavaPrimitiveArrays() && !binding.signatureCanUseIndirectNIO()) {
            this.emitCall(binding, writer, false);
            if (returnType.isString() || returnType.isNIOByteBuffer()) {
                writer.print(")");
            }
            writer.print(";");
            writer.println();
        } else {
            this.emitCall(binding, writer, true);
            if (returnType.isString() || returnType.isNIOByteBuffer()) {
                writer.print(")");
            }
            writer.print(";");
        }
        if (binding.signatureCanUseIndirectNIO() && !this.directNIOOnly) {
            writer.println();
            writer.println("    } else {");
            writer.print("    ");
            if (needsResultAssignment) {
                writer.print("    _res = ");
            } else {
                writer.print("  ");
                if (!returnType.isVoid()) {
                    writer.print("return ");
                }
            }
            this.emitCall(binding, writer, false);
            writer.print(";");
            writer.println();
            writer.println("    }");
        } else {
            writer.println();
        }
        this.emitPrologueOrEpilogue(this.epilogue, writer);
        if (needsResultAssignment) {
            this.emitCallResultReturn(binding, writer);
        }
    }

    @Override
    protected int emitCallArguments(MethodBinding binding, PrintWriter writer, boolean direct) {
        boolean needComma = false;
        int numArgsEmitted = 0;
        if (this.callThroughProcAddress) {
            writer.print("__addr_");
            needComma = true;
            ++numArgsEmitted;
        }
        if (binding.hasContainingType()) {
            assert (binding.getContainingType().isCompoundTypeWrapper());
            writer.print("BufferFactoryInternal.getDirectBufferAddress(");
            writer.print("getBuffer()");
            writer.print(")");
            needComma = true;
            ++numArgsEmitted;
        }
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            JavaType type = binding.getJavaArgumentType(i);
            if (type.isJNIEnv() || binding.isArgumentThisPointer(i)) continue;
            if (type.isVoid()) {
                assert (binding.getNumArguments() == 1);
                continue;
            }
            if (needComma) {
                writer.print(", ");
            }
            if (type.isCompoundTypeWrapper()) {
                writer.print("BufferFactoryInternal.getDirectBufferAddress(");
                writer.print("((");
            }
            if (type.isNIOBuffer()) {
                if (!direct) {
                    writer.print(this.getNIOBufferArrayName(i));
                } else {
                    writer.print("BufferFactoryInternal.getDirectBufferAddress(");
                    writer.print(this.getArgumentName(i));
                    writer.print(")");
                }
            } else {
                writer.print(this.getArgumentName(i));
            }
            if (type.isCompoundTypeWrapper()) {
                writer.print(" == null) ? null : ");
                writer.print(this.getArgumentName(i));
                writer.print(".getBuffer())");
                writer.print(")");
            }
            if (type.isNIOBuffer()) {
                if (direct) {
                    writer.print("+ BufferFactory.getDirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                } else {
                    writer.print(", BufferFactoryInternal.arrayBaseOffset(" + this.getNIOBufferArrayName(i) + ") + BufferFactory.getIndirectBufferByteOffset(" + this.getArgumentName(i) + ")");
                }
            } else if (type.isNIOBufferArray()) {
                writer.print(", " + this.byteOffsetArrayArgName(i));
            }
            if (type.isPrimitiveArray()) {
                writer.print(", ");
                writer.print("BufferFactoryInternal.arrayBaseOffset(" + this.getArgumentName(i) + ") + ");
                if (type.isFloatArray()) {
                    writer.print("BufferFactory.SIZEOF_FLOAT * ");
                } else if (type.isDoubleArray()) {
                    writer.print("BufferFactory.SIZEOF_DOUBLE * ");
                } else if (type.isByteArray()) {
                    writer.print("1 * ");
                } else if (type.isLongArray()) {
                    writer.print("BufferFactory.SIZEOF_LONG * ");
                } else if (type.isShortArray()) {
                    writer.print("BufferFactory.SIZEOF_SHORT * ");
                } else if (type.isIntArray()) {
                    writer.print("BufferFactory.SIZEOF_INT * ");
                } else {
                    throw new RuntimeException("Unsupported type for calculating array offset argument for " + this.getArgumentName(i) + "-- error occurred while processing Java glue code for " + this.getName());
                }
                writer.print(this.offsetArgName(i));
            }
            if (type.isString()) {
                writer.print("_c_str");
            }
            if (type.isCompoundTypeWrapper()) {
                writer.print(")");
            }
            needComma = true;
            ++numArgsEmitted;
        }
        return numArgsEmitted;
    }

    @Override
    protected void emitCallResultReturn(MethodBinding binding, PrintWriter writer) {
        for (int i = 0; i < binding.getNumArguments(); ++i) {
            JavaType type = binding.getJavaArgumentType(i);
            if (!type.isString()) continue;
            writer.println(";");
            writer.println("    BufferFactoryInternal.freeCString(" + binding.getArgumentName(i) + "_c_str);");
        }
        super.emitCallResultReturn(binding, writer);
    }

    @Override
    public String getName() {
        String res = super.getName();
        if (this.forImplementingMethodCall && this.bufferObjectVariant) {
            return res + "BufObj";
        }
        return res;
    }

    @Override
    protected String getImplMethodName(boolean direct) {
        String name = null;
        name = direct ? this.binding.getName() + "$0" : this.binding.getName() + "$1";
        if (this.bufferObjectVariant) {
            return name + "BufObj";
        }
        return name;
    }
}

