/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.opengl;

import com.sun.gluegen.CodeGenUtils;
import com.sun.gluegen.JavaType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BuildComposablePipeline {
    public static final int GEN_DEBUG = 1;
    public static final int GEN_TRACE = 2;
    public static final int GEN_CUSTOM = 4;
    public static final int GEN_PROLOG_XOR_DOWNSTREAM = 8;
    int mode;
    private String outputDir;
    private String outputPackage;
    private String outputName;
    private Class classToComposeAround;
    private Class classPrologOpt;
    private Class classDownstream;
    private String basePackage;
    private String baseName;
    private String downstreamPackage;
    private String downstreamName;
    private boolean hasImmediateMode;
    private boolean hasStackOverflow;

    public static Class getClass(String name) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(name);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find class \"" + name + "\"", e);
        }
        return clazz;
    }

    public static Method getMethod(Class clazz, Method m) {
        Method res = null;
        try {
            res = clazz.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static void main(String[] args) {
        int mode;
        Class classDownstream;
        Class classPrologOpt;
        String outputName;
        String outputPackage;
        String classToComposeAroundName = args[0];
        Class classToComposeAround = BuildComposablePipeline.getClass(classToComposeAroundName);
        String outputDir = args[1];
        if (args.length > 2) {
            String outputClazzName = args[2];
            outputPackage = BuildComposablePipeline.getPackageName(outputClazzName);
            outputName = BuildComposablePipeline.getBaseClassName(outputClazzName);
            classPrologOpt = BuildComposablePipeline.getClass(args[3]);
            classDownstream = BuildComposablePipeline.getClass(args[4]);
            mode = 4;
            if (args.length > 5 && args[5].equals("prolog_xor_downstream")) {
                mode |= 8;
            }
        } else {
            outputPackage = BuildComposablePipeline.getPackageName(classToComposeAroundName);
            outputName = null;
            classPrologOpt = null;
            classDownstream = classToComposeAround;
            mode = 3;
        }
        BuildComposablePipeline composer = new BuildComposablePipeline(mode, outputDir, outputPackage, outputName, classToComposeAround, classPrologOpt, classDownstream);
        try {
            composer.emit();
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating composable pipeline source files", e);
        }
    }

    protected BuildComposablePipeline(int mode, String outputDir, String outputPackage, String outputName, Class classToComposeAround, Class classPrologOpt, Class classDownstream) {
        this.mode = mode;
        this.outputDir = outputDir;
        this.outputPackage = outputPackage;
        this.outputName = outputName;
        this.classToComposeAround = classToComposeAround;
        this.classPrologOpt = classPrologOpt;
        this.classDownstream = classDownstream;
        if (!classToComposeAround.isInterface()) {
            throw new IllegalArgumentException(classToComposeAround.getName() + " is not an interface class");
        }
        try {
            this.hasImmediateMode = classToComposeAround.getMethod("glBegin", Integer.TYPE) != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.hasStackOverflow = classToComposeAround.getField("GL_STACK_OVERFLOW") != null;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void emit() throws IOException {
        ArrayList<Method> publicMethodsRaw = new ArrayList<Method>();
        publicMethodsRaw.addAll(Arrays.asList(this.classToComposeAround.getMethods()));
        HashSet<PlainMethod> publicMethodsPlain = new HashSet<PlainMethod>();
        for (Method method : publicMethodsRaw) {
            String name = method.getName();
            boolean runHooks = name.startsWith("gl");
            if (name.startsWith("getGL") || name.startsWith("isGL") || name.equals("toString")) continue;
            publicMethodsPlain.add(new PlainMethod(method, runHooks));
        }
        if (0 != (this.mode & 1)) {
            new DebugPipeline(this.outputDir, this.outputPackage, this.classToComposeAround, this.classDownstream).emit(publicMethodsPlain.iterator());
        }
        if (0 != (this.mode & 2)) {
            new TracePipeline(this.outputDir, this.outputPackage, this.classToComposeAround, this.classDownstream).emit(publicMethodsPlain.iterator());
        }
        if (0 != (this.mode & 4)) {
            new CustomPipeline(this.mode, this.outputDir, this.outputPackage, this.outputName, this.classToComposeAround, this.classPrologOpt, this.classDownstream).emit(publicMethodsPlain.iterator());
        }
    }

    public static String getPackageName(String clazzName) {
        int lastDot = clazzName.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return clazzName.substring(0, lastDot);
    }

    public static String getBaseClassName(String clazzName) {
        int lastDot = clazzName.lastIndexOf(46);
        if (lastDot == -1) {
            return clazzName;
        }
        return clazzName.substring(lastDot + 1);
    }

    public static final void printFunctionCallString(PrintWriter output, Method m) {
        Class<?>[] params = m.getParameterTypes();
        output.print("    \"" + m.getName() + "(\"");
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isArray()) {
                output.print("+\"<" + params[i].getName() + ">\"");
            } else if (params[i].equals(Integer.TYPE)) {
                output.print("+\"<" + params[i].getName() + "> 0x\"+Integer.toHexString(arg" + i + ").toUpperCase()");
            } else {
                output.print("+\"<" + params[i].getName() + "> \"+arg" + i);
            }
            if (i >= params.length - 1) continue;
            output.print("+\", \"");
        }
        output.print("+\")\"");
    }

    protected class TracePipeline
    extends PipelineEmitter {
        String className;

        public TracePipeline(String outputDir, String outputPackage, Class baseInterfaceClass, Class downstreamClass) {
            super(outputDir, outputPackage, baseInterfaceClass, null, downstreamClass);
            this.className = "Trace" + this.getBaseInterfaceName();
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return 0;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return false;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return false;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter output) {
            super.preMethodEmissionHook(output);
        }

        @Override
        protected void constructorHook(PrintWriter output) {
            output.print("  public " + this.getOutputName() + "(");
            output.println(this.downstreamName + " " + this.getDownstreamObjectName() + ", PrintStream " + this.getOutputStreamName() + ")");
            output.println("  {");
            output.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            output.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            output.println("    }");
            output.print("    this." + this.getDownstreamObjectName());
            output.println(" = " + this.getDownstreamObjectName() + ";");
            output.print("    this." + this.getOutputStreamName());
            output.println(" = " + this.getOutputStreamName() + ";");
            output.println("  }");
            output.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter output) {
            super.postMethodEmissionHook(output);
            output.println("private PrintStream " + this.getOutputStreamName() + ";");
            output.println("private int indent = 0;");
            output.println("protected String dumpArray(Object obj)");
            output.println("{");
            output.println("  if (obj == null) return \"[null]\";");
            output.println("  StringBuffer sb = new StringBuffer(\"[\");");
            output.println("  int len  = java.lang.reflect.Array.getLength(obj);");
            output.println("  int count = Math.min(len,16);");
            output.println("  for ( int i =0; i < count; i++ ) {");
            output.println("    sb.append(java.lang.reflect.Array.get(obj,i));");
            output.println("    if (i < count-1)");
            output.println("      sb.append(',');");
            output.println("  }");
            output.println("  if ( len > 16 )");
            output.println("    sb.append(\"...\").append(len);");
            output.println("  sb.append(']');");
            output.println("  return sb.toString();");
            output.println("}");
            output.println("protected void print(String str)");
            output.println("{");
            output.println("  " + this.getOutputStreamName() + ".print(str);");
            output.println("}");
            output.println("protected void println(String str)");
            output.println("{");
            output.println("  " + this.getOutputStreamName() + ".println(str);");
            output.println("}");
            output.println("protected void printIndent()");
            output.println("{");
            output.println("  for( int i =0; i < indent; i++) {" + this.getOutputStreamName() + ".print(' ');}");
            output.println("}");
        }

        @Override
        protected void emitClassDocComment(PrintWriter output) {
            output.println("/** <P> Composable pipeline which wraps an underlying {@link GL} implementation,");
            output.println("    providing tracing information to a user-specified {@link java.io.PrintStream}");
            output.println("    before and after each OpenGL method call. Sample code which installs this pipeline: </P>");
            output.println();
            output.println("<PRE>");
            output.println("     GL gl = drawable.setGL(new TraceGL(drawable.getGL(), System.err));");
            output.println("</PRE>");
            output.println("*/");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(Method m) {
            return true;
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter output, Method m) {
            if (m.getName().equals("glEnd") || m.getName().equals("glEndList")) {
                output.println("indent-=2;");
                output.println("    printIndent();");
            } else {
                output.println("printIndent();");
            }
            output.print("    print(");
            BuildComposablePipeline.printFunctionCallString(output, m);
            output.println(");");
        }

        @Override
        protected boolean hasPostDownstreamCallHook(Method m) {
            return true;
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter output, Method m) {
            Class<?> ret = m.getReturnType();
            if (ret != Void.TYPE) {
                output.println("    println(\" = \"+_res);");
            } else {
                output.println("    println(\"\");");
            }
        }

        private String getOutputStreamName() {
            return "stream";
        }
    }

    protected class DebugPipeline
    extends PipelineEmitter {
        String className;

        public DebugPipeline(String outputDir, String outputPackage, Class baseInterfaceClass, Class downstreamClass) {
            super(outputDir, outputPackage, baseInterfaceClass, null, downstreamClass);
            this.className = "Debug" + this.getBaseInterfaceName();
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return 0;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return false;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return false;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter output) {
            super.preMethodEmissionHook(output);
        }

        @Override
        protected void constructorHook(PrintWriter output) {
            output.print("  public " + this.getOutputName() + "(");
            output.println(this.downstreamName + " " + this.getDownstreamObjectName() + ")");
            output.println("  {");
            output.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            output.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            output.println("    }");
            output.print("    this." + this.getDownstreamObjectName());
            output.println(" = " + this.getDownstreamObjectName() + ";");
            if (null != this.prologNameOpt) {
                output.print("    this." + this.getPrologObjectNameOpt());
                output.println(" = " + this.getPrologObjectNameOpt() + ";");
            }
            output.println("    // Fetch GLContext object for better error checking (if possible)");
            output.println("    _context = " + this.getDownstreamObjectName() + ".getContext();");
            output.println("  }");
            output.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter output) {
            super.postMethodEmissionHook(output);
            output.println("  private void checkGLGetError(String caller)");
            output.println("  {");
            if (BuildComposablePipeline.this.hasImmediateMode) {
                output.println("    if (insideBeginEndPair) {");
                output.println("      return;");
                output.println("    }");
                output.println();
            }
            output.println("    // Debug code to make sure the pipeline is working; leave commented out unless testing this class");
            output.println("    //System.err.println(\"Checking for GL errors after call to \" + caller);");
            output.println();
            output.println("    int err = " + this.getDownstreamObjectName() + ".glGetError();");
            output.println("    if (err == GL_NO_ERROR) { return; }");
            output.println();
            output.println("    StringBuffer buf = new StringBuffer(Thread.currentThread()+");
            output.println("      \" glGetError() returned the following error codes after a call to \" + caller + \": \");");
            output.println();
            output.println("    // Loop repeatedly to allow for distributed GL implementations,");
            output.println("    // as detailed in the glGetError() specification");
            output.println("    int recursionDepth = 10;");
            output.println("    do {");
            output.println("      switch (err) {");
            output.println("        case GL_INVALID_ENUM: buf.append(\"GL_INVALID_ENUM \"); break;");
            output.println("        case GL_INVALID_VALUE: buf.append(\"GL_INVALID_VALUE \"); break;");
            output.println("        case GL_INVALID_OPERATION: buf.append(\"GL_INVALID_OPERATION \"); break;");
            if (BuildComposablePipeline.this.hasStackOverflow) {
                output.println("        case GL_STACK_OVERFLOW: buf.append(\"GL_STACK_OVERFLOW \"); break;");
                output.println("        case GL_STACK_UNDERFLOW: buf.append(\"GL_STACK_UNDERFLOW \"); break;");
            }
            output.println("        case GL_OUT_OF_MEMORY: buf.append(\"GL_OUT_OF_MEMORY \"); break;");
            output.println("        case GL_NO_ERROR: throw new InternalError(\"Should not be treating GL_NO_ERROR as error\");");
            output.println("        default: buf.append(\"Unknown glGetError() return value: \");");
            output.println("      }");
            output.println("      buf.append(\"( \" + err + \" 0x\"+Integer.toHexString(err).toUpperCase() + \"), \");");
            output.println("    } while ((--recursionDepth >= 0) && (err = " + this.getDownstreamObjectName() + ".glGetError()) != GL_NO_ERROR);");
            output.println("    throw new GLException(buf.toString());");
            output.println("  }");
            if (BuildComposablePipeline.this.hasImmediateMode) {
                output.println("  /** True if the pipeline is inside a glBegin/glEnd pair.*/");
                output.println("  private boolean insideBeginEndPair = false;");
                output.println();
            }
            output.println("  private void checkContext() {");
            output.println("    GLContext currentContext = GLContext.getCurrent();");
            output.println("    if (currentContext == null) {");
            output.println("      throw new GLException(\"No OpenGL context is current on this thread\");");
            output.println("    }");
            output.println("    if ((_context != null) && (_context != currentContext)) {");
            output.println("      throw new GLException(\"This GL object is being incorrectly used with a different GLContext than that which created it\");");
            output.println("    }");
            output.println("  }");
            output.println("  private GLContext _context;");
        }

        @Override
        protected void emitClassDocComment(PrintWriter output) {
            output.println("/** <P> Composable pipeline which wraps an underlying {@link GL} implementation,");
            output.println("    providing error checking after each OpenGL method call. If an error occurs,");
            output.println("    causes a {@link GLException} to be thrown at exactly the point of failure.");
            output.println("    Sample code which installs this pipeline: </P>");
            output.println();
            output.println("<PRE>");
            output.println("     GL gl = drawable.setGL(new DebugGL(drawable.getGL()));");
            output.println("</PRE>");
            output.println("*/");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(Method m) {
            return true;
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter output, Method m) {
            output.println("    checkContext();");
        }

        @Override
        protected boolean hasPostDownstreamCallHook(Method m) {
            return true;
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter output, Method m) {
            if (m.getName().equals("glBegin")) {
                output.println("    insideBeginEndPair = true;");
                output.println("    // NOTE: can't check glGetError(); it's not allowed inside glBegin/glEnd pair");
            } else {
                if (m.getName().equals("glEnd")) {
                    output.println("    insideBeginEndPair = false;");
                }
                output.println("    String txt = new String(\"" + m.getName() + "(\" +");
                Class<?>[] params = m.getParameterTypes();
                for (int i = 0; params != null && i < params.length; ++i) {
                    if (params[i].equals(Integer.TYPE)) {
                        output.println("    \"<" + params[i].getName() + "> 0x\"+Integer.toHexString(arg" + i + ").toUpperCase() +");
                    } else {
                        output.println("    \"<" + params[i].getName() + ">\" +");
                    }
                    if (i >= params.length - 1) continue;
                    output.println("    \", \" +");
                }
                output.println("    \")\");");
                output.println("    checkGLGetError( txt );");
            }
        }
    }

    protected class CustomPipeline
    extends PipelineEmitter {
        String className;
        int mode;

        public CustomPipeline(int mode, String outputDir, String outputPackage, String outputName, Class baseInterfaceClass, Class prologClassOpt, Class downstreamClass) {
            super(outputDir, outputPackage, baseInterfaceClass, prologClassOpt, downstreamClass);
            this.className = outputName;
            this.mode = mode;
        }

        @Override
        protected String getOutputName() {
            return this.className;
        }

        @Override
        protected int getMode() {
            return this.mode;
        }

        @Override
        protected boolean emptyMethodAllowed() {
            return true;
        }

        @Override
        protected boolean emptyDownstreamAllowed() {
            return true;
        }

        @Override
        protected void preMethodEmissionHook(PrintWriter output) {
            super.preMethodEmissionHook(output);
        }

        @Override
        protected void constructorHook(PrintWriter output) {
            output.print("  public " + this.getOutputName() + "(");
            output.print(this.downstreamName + " " + this.getDownstreamObjectName());
            if (null != this.prologNameOpt) {
                output.println(", " + this.prologNameOpt + " " + this.getPrologObjectNameOpt() + ")");
            } else {
                output.println(")");
            }
            output.println("  {");
            output.println("    if (" + this.getDownstreamObjectName() + " == null) {");
            output.println("      throw new IllegalArgumentException(\"null " + this.getDownstreamObjectName() + "\");");
            output.println("    }");
            output.print("    this." + this.getDownstreamObjectName());
            output.println(" = " + this.getDownstreamObjectName() + ";");
            if (null != this.prologNameOpt) {
                output.print("    this." + this.getPrologObjectNameOpt());
                output.println(" = " + this.getPrologObjectNameOpt() + ";");
            }
            output.println("  }");
            output.println();
        }

        @Override
        protected void postMethodEmissionHook(PrintWriter output) {
            super.postMethodEmissionHook(output);
            if (null != this.prologNameOpt) {
                output.print("  private " + this.prologNameOpt + " " + this.getPrologObjectNameOpt() + ";");
            }
        }

        @Override
        protected void emitClassDocComment(PrintWriter output) {
            output.println("/**");
            output.println(" * Composable pipeline {@link " + this.outputPackage + "." + BuildComposablePipeline.this.outputName + "}, implementing the interface");
            output.println(" * {@link " + this.baseInterfaceClass.getName() + "}");
            output.println(" * <p>");
            output.println(" * Each method follows the call graph <ul>");
            if (null != this.prologClassOpt) {
                output.println(" *   <li> call <em>prolog</em> {@link " + this.prologClassOpt.getName() + "} if available");
            }
            output.println(" *   <li> call <em>downstream</em> {@link " + this.downstreamClass.getName() + "} if available");
            if (null != this.prologClassOpt && 0 != (8 & this.getMode())) {
                output.println(" *        <strong>and</strong> if no call to {@link " + this.prologClassOpt.getName() + "} is made");
            }
            output.println(" * </ul><p>");
            output.println(" * ");
            output.println(" * <ul>");
            output.println(" *   <li> <em>Interface</em> {@link " + this.baseInterfaceClass.getName() + "}");
            if (null != this.prologClassOpt) {
                output.println(" *   <li> <em>Prolog</em> {@link " + this.prologClassOpt.getName() + "}");
            }
            output.println(" *   <li> <em>Downstream</em> {@link " + this.downstreamClass.getName() + "}");
            output.println(" * </ul><p>");
            output.println(" *  Sample code which installs this pipeline: </P>");
            output.println(" * ");
            output.println("<PRE>");
            if (null != this.prologNameOpt) {
                output.println("     GL gl = drawable.setGL( new " + this.className + "( drawable.getGL().getGL2ES2(), new " + this.prologNameOpt + "( drawable.getGL().getGL2ES2() ) ) );");
            } else {
                output.println("     GL gl = drawable.setGL( new " + this.className + "( drawable.getGL().getGL2ES2() ) );");
            }
            output.println("</PRE>");
            output.println("*/");
        }

        @Override
        protected boolean hasPreDownstreamCallHook(Method m) {
            return null != BuildComposablePipeline.getMethod(this.prologClassOpt, m);
        }

        @Override
        protected void preDownstreamCallHook(PrintWriter output, Method m) {
            if (null != this.prologNameOpt) {
                output.print(this.getPrologObjectNameOpt());
                output.print('.');
                output.print(m.getName());
                output.print('(');
                output.print(this.getArgListAsString(m, false, true));
                output.println(");");
            }
        }

        @Override
        protected boolean hasPostDownstreamCallHook(Method m) {
            return false;
        }

        @Override
        protected void postDownstreamCallHook(PrintWriter output, Method m) {
        }
    }

    protected abstract class PipelineEmitter {
        private File file;
        protected String basePackage;
        protected String baseName;
        protected String downstreamPackage;
        protected String downstreamName;
        protected String prologPackageOpt = null;
        protected String prologNameOpt = null;
        protected String outputDir;
        protected String outputPackage;
        protected Class baseInterfaceClass;
        protected Class prologClassOpt = null;
        protected Class downstreamClass;

        public PipelineEmitter(String outputDir, String outputPackage, Class baseInterfaceClass, Class prologClassOpt, Class downstreamClass) {
            this.outputDir = outputDir;
            this.outputPackage = outputPackage;
            this.baseInterfaceClass = baseInterfaceClass;
            this.prologClassOpt = prologClassOpt;
            this.downstreamClass = downstreamClass;
            this.basePackage = BuildComposablePipeline.getPackageName(baseInterfaceClass.getName());
            this.baseName = BuildComposablePipeline.getBaseClassName(baseInterfaceClass.getName());
            this.downstreamPackage = BuildComposablePipeline.getPackageName(downstreamClass.getName());
            this.downstreamName = BuildComposablePipeline.getBaseClassName(downstreamClass.getName());
            if (null != prologClassOpt) {
                this.prologPackageOpt = BuildComposablePipeline.getPackageName(prologClassOpt.getName());
                this.prologNameOpt = BuildComposablePipeline.getBaseClassName(prologClassOpt.getName());
            }
        }

        public void emit(Iterator methodsToWrap) throws IOException {
            String outputClassName = this.getOutputName();
            this.file = new File(this.outputDir + File.separatorChar + outputClassName + ".java");
            String parentDir = this.file.getParent();
            if (parentDir != null) {
                File pDirFile = new File(parentDir);
                pDirFile.mkdirs();
            }
            PrintWriter output = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
            List<Class<?>> baseInterfaces = Arrays.asList(this.baseInterfaceClass.getInterfaces());
            HashSet<Class> clazzList = new HashSet<Class>();
            clazzList.add(this.baseInterfaceClass);
            clazzList.addAll(baseInterfaces);
            int ifNamesNumber = clazzList.size();
            clazzList.clear();
            String[] ifNames = new String[ifNamesNumber];
            int i = 0;
            for (Class<?> ifClass : baseInterfaces) {
                if (clazzList.contains(ifClass)) continue;
                ifNames[i++] = new String(ifClass.getName());
                clazzList.add(ifClass);
            }
            if (null != this.baseInterfaceClass && !clazzList.contains(this.baseInterfaceClass)) {
                ifNames[i++] = new String(this.baseInterfaceClass.getName());
                clazzList.add(this.baseInterfaceClass);
            }
            clazzList.add(this.downstreamClass);
            if (null != this.prologClassOpt) {
                clazzList.add(this.prologClassOpt);
            }
            String[] importNames = new String[clazzList.size() + 2];
            int i2 = 0;
            importNames[i2++] = new String("java.io.*");
            importNames[i2++] = new String("javax.media.opengl.*");
            Iterator iter = clazzList.iterator();
            while (iter.hasNext()) {
                importNames[i2++] = new String(((Class)iter.next()).getName());
            }
            CodeGenUtils.emitJavaHeaders(output, this.outputPackage, outputClassName, "com.sun.gluegen.runtime", true, importNames, new String[]{"public"}, ifNames, null, new CodeGenUtils.EmissionCallback(){

                @Override
                public void emit(PrintWriter w) {
                    PipelineEmitter.this.emitClassDocComment(w);
                }
            });
            this.preMethodEmissionHook(output);
            this.constructorHook(output);
            this.emitGLIsMethods(output);
            this.emitGLGetMethods(output);
            while (methodsToWrap.hasNext()) {
                PlainMethod pm = (PlainMethod)methodsToWrap.next();
                Method m = pm.getWrappedMethod();
                this.emitMethodDocComment(output, m);
                this.emitSignature(output, m);
                this.emitBody(output, m, pm.runHooks());
            }
            this.postMethodEmissionHook(output);
            output.println();
            output.print("  private " + this.downstreamName + " " + this.getDownstreamObjectName() + ";");
            output.println();
            output.print("} // end class ");
            output.println(outputClassName);
            output.flush();
            output.close();
            System.out.println("wrote to file: " + this.file);
        }

        protected String getDownstreamObjectName() {
            return "downstream" + this.downstreamName;
        }

        protected String getPrologObjectNameOpt() {
            if (null != this.prologNameOpt) {
                return "prolog" + this.prologNameOpt;
            }
            return null;
        }

        protected void emitMethodDocComment(PrintWriter output, Method m) {
        }

        protected void emitSignature(PrintWriter output, Method m) {
            output.print("  public ");
            output.print(' ');
            output.print(JavaType.createForClass(m.getReturnType()).getName());
            output.print(' ');
            output.print(m.getName());
            output.print('(');
            output.print(this.getArgListAsString(m, true, true));
            output.println(")");
        }

        protected void emitBody(PrintWriter output, Method m, boolean runHooks) {
            boolean hasResult;
            output.println("  {");
            output.print("    ");
            Class<?> retType = m.getReturnType();
            boolean callPreDownstreamHook = runHooks && this.hasPreDownstreamCallHook(m);
            boolean callPostDownstreamHook = runHooks && this.hasPostDownstreamCallHook(m);
            boolean callDownstream = null != BuildComposablePipeline.getMethod(this.downstreamClass, m) && (0 == (8 & this.getMode()) || !callPreDownstreamHook);
            boolean bl = hasResult = retType != Void.TYPE;
            if (!callDownstream && !this.emptyDownstreamAllowed()) {
                throw new RuntimeException("Method " + m + " has no downstream (" + this.downstreamName + ")");
            }
            if (!(callPreDownstreamHook || callPostDownstreamHook || callDownstream)) {
                if (!this.emptyMethodAllowed()) {
                    throw new RuntimeException("Method " + m + " is empty, no downstream (" + this.downstreamName + ") nor prolog (" + this.prologNameOpt + ").");
                }
                output.print("    if(DEBUG) { System.out.println(\"WARNING: No prolog, no downstream, empty: \"+");
                BuildComposablePipeline.printFunctionCallString(output, m);
                output.println("); } ");
            }
            if (callPreDownstreamHook) {
                if (hasResult && !callDownstream) {
                    if (callPostDownstreamHook) {
                        output.print("    " + JavaType.createForClass(retType).getName());
                        output.print(" _res = ");
                    } else {
                        output.print("    return ");
                    }
                }
                this.preDownstreamCallHook(output, m);
            }
            if (callDownstream) {
                if (hasResult) {
                    if (callPostDownstreamHook) {
                        output.print("    " + JavaType.createForClass(retType).getName());
                        output.print(" _res = ");
                    } else {
                        output.print("    return ");
                    }
                }
                output.print(this.getDownstreamObjectName());
                output.print('.');
                output.print(m.getName());
                output.print('(');
                output.print(this.getArgListAsString(m, false, true));
                output.println(");");
            }
            if (callPostDownstreamHook) {
                this.postDownstreamCallHook(output, m);
            }
            if (hasResult && callDownstream && callPostDownstreamHook) {
                output.println("    return _res;");
            }
            output.println("  }");
        }

        protected String getArgListAsString(Method m, boolean includeArgTypes, boolean includeArgNames) {
            StringBuffer buf = new StringBuffer(256);
            if (!includeArgNames && !includeArgTypes) {
                throw new IllegalArgumentException("Cannot generate arglist without both arg types and arg names");
            }
            Class<?>[] argTypes = m.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (includeArgTypes) {
                    buf.append(JavaType.createForClass(argTypes[i]).getName());
                    buf.append(' ');
                }
                if (includeArgNames) {
                    buf.append("arg");
                    buf.append(i);
                }
                if (i >= argTypes.length - 1) continue;
                buf.append(',');
            }
            return buf.toString();
        }

        protected String getBaseInterfaceName() {
            return this.baseName;
        }

        protected abstract String getOutputName();

        protected void preMethodEmissionHook(PrintWriter output) {
            output.println("  public static final boolean DEBUG = com.sun.opengl.impl.Debug.debug(\"" + this.getOutputName() + "\");");
        }

        protected abstract void constructorHook(PrintWriter var1);

        protected void postMethodEmissionHook(PrintWriter output) {
            output.println("  public String toString() {");
            output.println("    StringBuffer sb = new StringBuffer();");
            output.println("    sb.append(\"" + this.getOutputName() + " [ implementing " + this.baseInterfaceClass.getName() + ",\\n\\t\");");
            if (null != this.prologClassOpt) {
                output.println("    sb.append(\" prolog: \"+" + this.getPrologObjectNameOpt() + ".toString()+\",\\n\\t\");");
            }
            output.println("    sb.append(\" downstream: \"+" + this.getDownstreamObjectName() + ".toString()+\"\\n\\t]\");");
            output.println("    return sb.toString();");
            output.println("  }");
        }

        protected abstract void preDownstreamCallHook(PrintWriter var1, Method var2);

        protected abstract boolean hasPreDownstreamCallHook(Method var1);

        protected abstract void postDownstreamCallHook(PrintWriter var1, Method var2);

        protected abstract boolean hasPostDownstreamCallHook(Method var1);

        protected abstract int getMode();

        protected abstract boolean emptyMethodAllowed();

        protected abstract boolean emptyDownstreamAllowed();

        protected abstract void emitClassDocComment(PrintWriter var1);

        protected void emitGLIsMethod(PrintWriter output, String type) {
            output.println("  public boolean is" + type + "() {");
            Class clazz = BuildComposablePipeline.getClass("javax.media.opengl." + type);
            if (clazz.isAssignableFrom(this.baseInterfaceClass)) {
                output.println("    return true;");
            } else {
                output.println("    return false;");
            }
            output.println("  }");
        }

        protected void emitGLIsMethods(PrintWriter output) {
            this.emitGLIsMethod(output, "GL");
            this.emitGLIsMethod(output, "GL3bc");
            this.emitGLIsMethod(output, "GL3");
            this.emitGLIsMethod(output, "GL2");
            this.emitGLIsMethod(output, "GLES1");
            this.emitGLIsMethod(output, "GLES2");
            this.emitGLIsMethod(output, "GL2ES1");
            this.emitGLIsMethod(output, "GL2ES2");
            this.emitGLIsMethod(output, "GL2GL3");
            output.println("  public boolean isGLES() {");
            output.println("    return isGLES2() || isGLES1();");
            output.println("  }");
        }

        protected void emitGLGetMethod(PrintWriter output, String type) {
            output.println("  public javax.media.opengl." + type + " get" + type + "() {");
            Class clazz = BuildComposablePipeline.getClass("javax.media.opengl." + type);
            if (clazz.isAssignableFrom(this.baseInterfaceClass)) {
                output.println("    return this;");
            } else {
                output.println("    throw new GLException(\"Not a " + type + " implementation\");");
            }
            output.println("  }");
        }

        protected void emitGLGetMethods(PrintWriter output) {
            this.emitGLGetMethod(output, "GL");
            this.emitGLGetMethod(output, "GL3bc");
            this.emitGLGetMethod(output, "GL3");
            this.emitGLGetMethod(output, "GL2");
            this.emitGLGetMethod(output, "GLES1");
            this.emitGLGetMethod(output, "GLES2");
            this.emitGLGetMethod(output, "GL2ES1");
            this.emitGLGetMethod(output, "GL2ES2");
            this.emitGLGetMethod(output, "GL2GL3");
            output.println("  public GLProfile getGLProfile() {");
            output.println("    return " + this.getDownstreamObjectName() + ".getGLProfile();");
            output.println("  }");
        }
    }

    protected class PlainMethod {
        Method m;
        boolean runHooks;

        public PlainMethod(Method m, boolean runHooks) {
            this.m = m;
            this.runHooks = runHooks;
        }

        public Method getWrappedMethod() {
            return this.m;
        }

        public boolean runHooks() {
            return this.runHooks;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlainMethod) {
                PlainMethod b = (PlainMethod)obj;
                boolean res = this.m.getName().equals(b.m.getName()) && this.m.getModifiers() == b.m.getModifiers() && this.m.getReturnType().equals(b.m.getReturnType()) && Arrays.equals(this.m.getParameterTypes(), b.m.getParameterTypes());
                return res;
            }
            return false;
        }

        public int hashCode() {
            int hash = this.m.getName().hashCode() ^ this.m.getModifiers() ^ this.m.getReturnType().hashCode();
            Class<?>[] args = this.m.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                hash ^= args[i].hashCode();
            }
            return hash;
        }

        public String toString() {
            Class<?>[] args = this.m.getParameterTypes();
            StringBuffer argsString = new StringBuffer();
            argsString.append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    argsString.append(", ");
                }
                argsString.append(args[i].getName());
            }
            argsString.append(")");
            return this.m.toString() + "\n\tname: " + this.m.getName() + "\n\tmods: " + this.m.getModifiers() + "\n\tretu: " + this.m.getReturnType() + "\n\targs[" + args.length + "]: " + argsString.toString();
        }
    }
}

