/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.opengl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildStaticGLInfo {
    protected static int funcIdentifierGroup = 10;
    protected static Pattern funcPattern = Pattern.compile("^(GLAPI|GL_API|GL_APICALL|EGLAPI|extern)?(\\s*)((unsigned|const)\\s+)?(\\w+)(\\s*\\*)?(\\s+)(GLAPIENTRY|GL_APIENTRY|APIENTRY|EGLAPIENTRY|WINAPI)?(\\s*)([ew]?gl\\w+)\\s?(\\(.*)");
    protected static Pattern associationPattern = Pattern.compile("\\#ifndef ([CEW]?GL[XU]?_[A-Za-z0-9_]+)(.*)");
    protected static int defineIdentifierGroup = 1;
    protected static Pattern definePattern = Pattern.compile("\\#define ([CEW]?GL[XU]?_[A-Za-z0-9_]+)\\s*([A-Za-z0-9_]+)(.*)");
    protected Map declarationToExtensionMap = new HashMap();
    protected Map extensionToDeclarationMap = new HashMap();
    protected boolean debug = false;

    public static void main(String[] args) throws IOException {
        if (args.length > 0 && args[0].equals("-test")) {
            BuildStaticGLInfo builder = new BuildStaticGLInfo();
            builder.setDebug(true);
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            builder.parse(newArgs);
            builder.dump();
            System.exit(0);
        }
        String packageName = args[0];
        String packageDir = args[1];
        String[] cHeaderFilePaths = new String[args.length - 2];
        System.arraycopy(args, 2, cHeaderFilePaths, 0, cHeaderFilePaths.length);
        BuildStaticGLInfo builder = new BuildStaticGLInfo();
        try {
            builder.parse(cHeaderFilePaths);
            File file = new File(packageDir + File.separatorChar + "StaticGLInfo.java");
            String parentDir = file.getParent();
            if (parentDir != null) {
                File pDirFile = new File(parentDir);
                pDirFile.mkdirs();
            }
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            builder.emitJavaCode(writer, packageName);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer("{ ");
            for (int i = 0; i < cHeaderFilePaths.length; ++i) {
                buf.append(cHeaderFilePaths[i]);
                buf.append(" ");
            }
            buf.append('}');
            throw new RuntimeException("Error building StaticGLInfo.java from " + buf.toString(), e);
        }
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    public void parse(String[] cHeaderFilePaths) throws IOException {
        for (int i = 0; i < cHeaderFilePaths.length; ++i) {
            this.parse(cHeaderFilePaths[i]);
        }
    }

    public void parse(String cHeaderFilePath) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(cHeaderFilePath));
        String activeAssociation = null;
        Matcher m = null;
        while ((line = reader.readLine()) != null) {
            int type = 0;
            if (activeAssociation != null) {
                String identifier = null;
                m = funcPattern.matcher(line);
                if (m.matches()) {
                    identifier = m.group(funcIdentifierGroup).trim();
                    type = 2;
                } else {
                    m = definePattern.matcher(line);
                    if (m.matches()) {
                        identifier = m.group(defineIdentifierGroup).trim();
                        type = 1;
                    } else if (line.startsWith("#endif")) {
                        if (this.debug) {
                            System.err.println("END ASSOCIATION BLOCK: <" + activeAssociation + ">");
                        }
                        activeAssociation = null;
                    }
                }
                if (identifier == null || activeAssociation == null || identifier.equals(activeAssociation)) continue;
                this.addAssociation(identifier, activeAssociation);
                if (!this.debug) continue;
                System.err.println("  ADDING ASSOCIATION: <" + identifier + "> <" + activeAssociation + "> ; type " + type);
                continue;
            }
            m = associationPattern.matcher(line);
            if (!m.matches()) continue;
            activeAssociation = m.group(1).trim();
            if (!this.debug) continue;
            System.err.println("BEGIN ASSOCIATION BLOCK: <" + activeAssociation + ">");
        }
        reader.close();
    }

    public void dump() {
        for (String name : this.extensionToDeclarationMap.keySet()) {
            Set decls = (Set)this.extensionToDeclarationMap.get(name);
            System.out.println("<" + name + "> :");
            ArrayList l = new ArrayList();
            l.addAll(decls);
            Collections.sort(l);
            Iterator i2 = l.iterator();
            while (i2.hasNext()) {
                System.out.println("  <" + (String)i2.next() + ">");
            }
        }
    }

    public String getExtension(String identifier) {
        return (String)this.declarationToExtensionMap.get(identifier);
    }

    public Set getDeclarations(String extension) {
        return (Set)this.extensionToDeclarationMap.get(extension);
    }

    public Set getExtensions() {
        return this.extensionToDeclarationMap.keySet();
    }

    public void emitJavaCode(PrintWriter output, String packageName) {
        output.println("package " + packageName + ";");
        output.println();
        output.println("import java.util.*;");
        output.println();
        output.println("public final class StaticGLInfo");
        output.println("{");
        output.println("  // maps function names to the extension string or OpenGL");
        output.println("  // specification version string to which they correspond.");
        output.println("  private static HashMap funcToAssocMap;");
        output.println();
        output.println("  /**");
        output.println("   * Returns the OpenGL extension string or GL_VERSION string with which the");
        output.println("   * given function is associated. <P>");
        output.println("   *");
        output.println("   * If the");
        output.println("   * function is part of the OpenGL core, the returned value will be");
        output.println("   * GL_VERSION_XXX where XXX represents the OpenGL version of which the");
        output.println("   * function is a member (XXX will be of the form \"A\" or \"A_B\" or \"A_B_C\";");
        output.println("   * e.g., GL_VERSION_1_2_1 for OpenGL version 1.2.1).");
        output.println("   *");
        output.println("   * If the function is an extension function, the returned value will the");
        output.println("   * OpenGL extension string for the extension to which the function");
        output.println("   * corresponds. For example, if glLoadTransposeMatrixfARB is the argument,");
        output.println("   * GL_ARB_transpose_matrix will be the value returned.");
        output.println("   * Please see http://oss.sgi.com/projects/ogl-sample/registry/index.html for");
        output.println("   * a list of extension names and the functions they expose.");
        output.println("   *");
        output.println("   * If the function specified is not part of any known OpenGL core version or");
        output.println("   * extension, then NULL will be returned.");
        output.println("   */");
        output.println("  public static String getFunctionAssociation(String glFunctionName)");
        output.println("  {");
        output.println("    String mappedName = null;");
        output.println("    int  funcNamePermNum = com.sun.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutationNumber(glFunctionName);");
        output.println("    for(int i = 0; null==mappedName && i < funcNamePermNum; i++) {");
        output.println("        String tmp = com.sun.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutation(glFunctionName, i);");
        output.println("        try {");
        output.println("          mappedName = (String)funcToAssocMap.get(tmp);");
        output.println("        } catch (Exception e) { }");
        output.println("    }");
        output.println("    return mappedName;");
        output.println("  }");
        output.println();
        output.println("  static");
        output.println("  {");
        int maxCapacity = 0;
        for (String name : this.declarationToExtensionMap.keySet()) {
            if (name.startsWith("GL")) continue;
            ++maxCapacity;
        }
        output.println("    funcToAssocMap = new HashMap(" + maxCapacity + "); // approximate max capacity");
        output.println("    String group;");
        ArrayList sets = new ArrayList(this.extensionToDeclarationMap.keySet());
        Collections.sort(sets);
        for (String groupName : sets) {
            Set funcs = (Set)this.extensionToDeclarationMap.get(groupName);
            ArrayList l = new ArrayList();
            l.addAll(funcs);
            Collections.sort(l);
            Iterator funcIter = l.iterator();
            boolean printedHeader = false;
            while (funcIter.hasNext()) {
                String funcName = (String)funcIter.next();
                if (funcName.startsWith("GL")) continue;
                if (!printedHeader) {
                    output.println();
                    output.println("    //----------------------------------------------------------------");
                    output.println("    //                 " + groupName);
                    output.println("    //----------------------------------------------------------------");
                    output.println("    group = \"" + groupName + "\";");
                    printedHeader = true;
                }
                output.println("    funcToAssocMap.put(\"" + funcName + "\", group);");
            }
        }
        output.println("  }");
        output.println("} // end class StaticGLInfo");
    }

    protected void addAssociation(String identifier, String association) {
        this.declarationToExtensionMap.put(identifier, association);
        HashSet<String> identifiers = (HashSet<String>)this.extensionToDeclarationMap.get(association);
        if (identifiers == null) {
            identifiers = new HashSet<String>();
            this.extensionToDeclarationMap.put(association, identifiers);
        }
        identifiers.add(identifier);
    }
}

