/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.opengl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ConvertFromGL4Java {
    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            ConvertFromGL4Java.convert(new File(args[i]));
        }
    }

    private static void convert(File src) throws IOException {
        File orig = new File(src.getAbsolutePath() + ".orig");
        if (!src.renameTo(orig)) {
            throw new IOException("Error renaming original file to " + orig);
        }
        File dest = src;
        BufferedReader reader = new BufferedReader(new FileReader(orig));
        BufferedWriter writer = new BufferedWriter(new FileWriter(dest));
        boolean handledImports = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            String trimmed = line.trim();
            boolean isImport = false;
            if (trimmed.startsWith("import gl4java")) {
                line = "import javax.media.opengl.*;";
                isImport = true;
            }
            if (isImport && (!isImport || handledImports)) continue;
            line = line.replaceAll("GLFunc14", "GL");
            line = line.replaceAll("GLUFunc14", "GLU");
            line = line.replaceAll("GLFunc", "GL");
            line = line.replaceAll("GLUFunc", "GLU");
            line = line.replaceAll("implements GLEnum,", "implements ");
            line = line.replaceAll(", GLEnum\\s", " ");
            line = line.replaceAll("GLEnum,", "");
            line = line.replaceAll("GLEnum.", "");
            line = line.replaceAll("GLEnum", "");
            line = line.replaceAll("GL_", "GL.GL_");
            writer.write(line);
            writer.newLine();
            if (!isImport) continue;
            handledImports = true;
        }
        writer.flush();
        reader.close();
        writer.close();
    }
}

