/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.opengl;

import com.sun.gluegen.GlueEmitterControls;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.opengl.BuildStaticGLInfo;
import com.sun.gluegen.opengl.GLEmitter;
import com.sun.gluegen.procaddress.ProcAddressConfiguration;
import com.sun.gluegen.runtime.opengl.GLExtensionNames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class GLConfiguration
extends ProcAddressConfiguration {
    private List glHeaders = new ArrayList();
    private Set ignoredExtensions = new HashSet();
    private Set extensionsRenamedIntoCore = new HashSet();
    private BuildStaticGLInfo glInfo;
    private Map bufferObjectKinds = new HashMap();
    private GLEmitter emitter;
    private Set dropUniqVendorExtensions = new HashSet();
    private boolean autoUnifyExtensions = false;
    private boolean allowNonGLExtensions = false;

    public GLConfiguration(GLEmitter emitter) {
        this.emitter = emitter;
        try {
            this.setProcAddressNameExpr("PFN $UPPERCASE({0}) PROC");
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error configuring ProcAddressNameExpr", e);
        }
    }

    @Override
    protected void dispatch(String cmd, StringTokenizer tok, File file, String filename, int lineNo) throws IOException {
        if (cmd.equalsIgnoreCase("IgnoreExtension")) {
            String sym = this.readString("IgnoreExtension", tok, filename, lineNo);
            this.ignoredExtensions.add(sym);
        } else if (cmd.equalsIgnoreCase("RenameExtensionIntoCore")) {
            String sym = this.readString("RenameExtensionIntoCore", tok, filename, lineNo);
            this.extensionsRenamedIntoCore.add(sym);
        } else if (cmd.equalsIgnoreCase("AllowNonGLExtensions")) {
            this.allowNonGLExtensions = this.readBoolean("AllowNonGLExtensions", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("AutoUnifyExtensions")) {
            this.autoUnifyExtensions = this.readBoolean("AutoUnifyExtensions", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("GLHeader")) {
            String sym = this.readString("GLHeader", tok, filename, lineNo);
            this.glHeaders.add(sym);
        } else if (cmd.equalsIgnoreCase("BufferObjectKind")) {
            this.readBufferObjectKind(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("DropUniqVendorExtensions")) {
            String sym = this.readString("DropUniqVendorExtensions", tok, filename, lineNo);
            this.dropUniqVendorExtensions.add(sym);
        } else {
            super.dispatch(cmd, tok, file, filename, lineNo);
        }
    }

    protected void readBufferObjectKind(StringTokenizer tok, String filename, int lineNo) {
        try {
            String kindString = tok.nextToken();
            GLEmitter.BufferObjectKind kind = null;
            String target = tok.nextToken();
            if (kindString.equalsIgnoreCase("UnpackPixel")) {
                kind = GLEmitter.BufferObjectKind.UNPACK_PIXEL;
            } else if (kindString.equalsIgnoreCase("PackPixel")) {
                kind = GLEmitter.BufferObjectKind.PACK_PIXEL;
            } else if (kindString.equalsIgnoreCase("Array")) {
                kind = GLEmitter.BufferObjectKind.ARRAY;
            } else if (kindString.equalsIgnoreCase("Element")) {
                kind = GLEmitter.BufferObjectKind.ELEMENT;
            } else {
                throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + lineNo + " in file \"" + filename + "\": illegal BufferObjectKind \"" + kindString + "\", expected one of UnpackPixel, PackPixel, Array, or Element");
            }
            this.bufferObjectKinds.put(target, kind);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    @Override
    public List javaPrologueForMethod(MethodBinding binding, boolean forImplementingMethodCall, boolean eraseBufferAndArrayTypes) {
        ArrayList res = super.javaPrologueForMethod(binding, forImplementingMethodCall, eraseBufferAndArrayTypes);
        GLEmitter.BufferObjectKind kind = this.getBufferObjectKind(binding.getName());
        if (kind != null) {
            ArrayList res2 = new ArrayList();
            if (res != null) {
                res2.addAll(res);
            }
            res = res2;
            String prologue = "check";
            if (kind == GLEmitter.BufferObjectKind.UNPACK_PIXEL) {
                prologue = prologue + "UnpackPBO";
            } else if (kind == GLEmitter.BufferObjectKind.PACK_PIXEL) {
                prologue = prologue + "PackPBO";
            } else if (kind == GLEmitter.BufferObjectKind.ARRAY) {
                prologue = prologue + "ArrayVBO";
            } else if (kind == GLEmitter.BufferObjectKind.ELEMENT) {
                prologue = prologue + "ElementVBO";
            } else {
                throw new RuntimeException("Unknown BufferObjectKind " + kind);
            }
            prologue = this.emitter.isBufferObjectMethodBinding(binding) ? prologue + "Enabled" : prologue + "Disabled";
            prologue = prologue + "(true);";
            res.add(0, prologue);
            if (this.emitter.isBufferObjectMethodBinding(binding)) {
                Iterator iter = res.iterator();
                while (iter.hasNext()) {
                    String line = (String)iter.next();
                    if (line.indexOf("BufferFactory.rangeCheck") < 0) continue;
                    iter.remove();
                }
            }
        }
        return res;
    }

    @Override
    public void dumpIgnores() {
        System.err.println("GL Ignored extensions: ");
        Iterator iter = this.ignoredExtensions.iterator();
        while (iter.hasNext()) {
            System.err.println("\t" + (String)iter.next());
        }
        super.dumpIgnores();
    }

    protected boolean shouldIgnoreExtension(String symbol, boolean criteria) {
        if (criteria && this.glInfo != null) {
            String extSuffix;
            String extension = this.glInfo.getExtension(symbol);
            if (extension != null && this.ignoredExtensions.contains(extension)) {
                return true;
            }
            boolean isGLEnum = GLExtensionNames.isGLEnumeration((String)symbol);
            boolean isGLFunc = GLExtensionNames.isGLFunction((String)symbol);
            if ((isGLFunc || isGLEnum) && GLExtensionNames.isExtensionVEN((String)symbol, (boolean)isGLFunc) && this.getDropUniqVendorExtensions(extSuffix = GLExtensionNames.getExtensionSuffix((String)symbol, (boolean)isGLFunc))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldIgnoreInInterface(String symbol) {
        return this.shouldIgnoreInInterface(symbol, true);
    }

    public boolean shouldIgnoreInInterface(String symbol, boolean checkEXT) {
        return this.shouldIgnoreExtension(symbol, checkEXT) || super.shouldIgnoreInInterface(symbol);
    }

    @Override
    public boolean shouldIgnoreInImpl(String symbol) {
        return this.shouldIgnoreInImpl(symbol, true);
    }

    public boolean shouldIgnoreInImpl(String symbol, boolean checkEXT) {
        return this.shouldIgnoreExtension(symbol, checkEXT) || super.shouldIgnoreInImpl(symbol);
    }

    public boolean getAutoUnifyExtensions() {
        return this.autoUnifyExtensions;
    }

    public boolean getAllowNonGLExtensions() {
        return this.allowNonGLExtensions;
    }

    public boolean getDropUniqVendorExtensions(String extName) {
        return this.dropUniqVendorExtensions.contains(extName);
    }

    public GLEmitter.BufferObjectKind getBufferObjectKind(String name) {
        return (GLEmitter.BufferObjectKind)this.bufferObjectKinds.get(name);
    }

    public boolean isBufferObjectFunction(String name) {
        return this.getBufferObjectKind(name) != null;
    }

    public void parseGLHeaders(GlueEmitterControls controls) throws IOException {
        if (!this.glHeaders.isEmpty()) {
            this.glInfo = new BuildStaticGLInfo();
            for (String file : this.glHeaders) {
                String fullPath = controls.findHeaderFile(file);
                if (fullPath == null) {
                    throw new IOException("Unable to locate header file \"" + file + "\"");
                }
                this.glInfo.parse(fullPath);
            }
        }
    }

    public BuildStaticGLInfo getGLInfo() {
        return this.glInfo;
    }

    public Set getExtensionsRenamedIntoCore() {
        return this.extensionsRenamedIntoCore;
    }
}

