/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.opengl;

import com.sun.gluegen.ConstantDefinition;
import com.sun.gluegen.GlueEmitterControls;
import com.sun.gluegen.JavaConfiguration;
import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.SymbolFilter;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.opengl.BuildStaticGLInfo;
import com.sun.gluegen.opengl.GLConfiguration;
import com.sun.gluegen.opengl.GLJavaMethodBindingEmitter;
import com.sun.gluegen.procaddress.ProcAddressEmitter;
import com.sun.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import com.sun.gluegen.runtime.opengl.GLExtensionNames;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GLEmitter
extends ProcAddressEmitter {
    private Map bufferObjectMethodBindings = new IdentityHashMap();

    @Override
    public void beginEmission(GlueEmitterControls controls) throws IOException {
        this.getGLConfig().parseGLHeaders(controls);
        this.renameExtensionsIntoCore();
        if (this.getGLConfig().getAutoUnifyExtensions()) {
            this.unifyExtensions(controls);
        }
        super.beginEmission(controls);
    }

    protected void renameExtensionsIntoCore() {
        GLConfiguration config = this.getGLConfig();
        Set extensionsRenamedIntoCore = config.getExtensionsRenamedIntoCore();
        BuildStaticGLInfo glInfo = config.getGLInfo();
        if (null == glInfo) {
            if (extensionsRenamedIntoCore.size() > 0) {
                throw new RuntimeException("ExtensionRenamedIntoCore (num: " + extensionsRenamedIntoCore.size() + "), but no GLHeader");
            }
            return;
        }
        for (String extension : extensionsRenamedIntoCore) {
            Set declarations = glInfo.getDeclarations(extension);
            if (declarations == null) continue;
            for (String decl : declarations) {
                String renamed;
                boolean isGLFunction = GLExtensionNames.isGLFunction((String)decl);
                boolean isGLEnumeration = false;
                if (!isGLFunction) {
                    isGLEnumeration = GLExtensionNames.isGLEnumeration((String)decl);
                }
                if (!isGLFunction && !isGLEnumeration || (renamed = GLExtensionNames.normalize((String)decl, (boolean)isGLFunction)).equals(decl)) continue;
                config.addJavaSymbolRename(decl, renamed);
            }
        }
    }

    private void unifyExtensions(GlueEmitterControls controls) {
        controls.runSymbolFilter(new ExtensionUnifier());
    }

    @Override
    protected JavaConfiguration createConfig() {
        return new GLConfiguration(this);
    }

    @Override
    protected List expandMethodBinding(MethodBinding binding) {
        List bindings = super.expandMethodBinding(binding);
        if (!this.getGLConfig().isBufferObjectFunction(binding.getName())) {
            return bindings;
        }
        ArrayList<MethodBinding> newBindings = new ArrayList<MethodBinding>();
        newBindings.addAll(bindings);
        for (MethodBinding cur : bindings) {
            if (cur.signatureUsesJavaPrimitiveArrays()) continue;
            MethodBinding result = cur;
            for (int i = 0; i < cur.getNumArguments(); ++i) {
                if (!cur.getJavaArgumentType(i).isNIOBuffer()) continue;
                result = result.replaceJavaArgumentType(i, JavaType.createForClass(Long.TYPE));
            }
            if (result == cur) {
                throw new RuntimeException("Error: didn't find any void* arguments for BufferObject function " + binding.getName());
            }
            newBindings.add(result);
            this.bufferObjectMethodBindings.put(result, result);
        }
        return newBindings;
    }

    @Override
    protected boolean needsModifiedEmitters(FunctionSymbol sym) {
        return (this.needsProcAddressWrapper(sym) || this.needsBufferObjectVariant(sym)) && !this.getConfig().isUnimplemented(sym.getName());
    }

    public boolean isBufferObjectMethodBinding(MethodBinding binding) {
        return this.bufferObjectMethodBindings.containsKey(binding);
    }

    @Override
    public void emitDefine(ConstantDefinition def, String optionalComment) throws Exception {
        BuildStaticGLInfo glInfo = this.getGLConfig().getGLInfo();
        if (null == glInfo) {
            throw new Exception("No GLInfo for: " + def);
        }
        String symbolRenamed = def.getName();
        StringBuffer newComment = new StringBuffer();
        newComment.append("Part of <code>");
        if (0 == this.addExtensionsOfSymbols2Buffer(newComment, ", ", symbolRenamed, def.getAliasedNames())) {
            if (def.isEnum()) {
                String enumName = def.getEnumName();
                if (null != enumName) {
                    newComment.append(enumName);
                } else {
                    newComment.append("CORE ENUM");
                }
            } else if (this.getGLConfig().getAllowNonGLExtensions()) {
                newComment.append("CORE DEF");
            } else {
                return;
            }
        }
        newComment.append("</code>");
        if (null != optionalComment) {
            newComment.append("<br>");
            newComment.append(optionalComment);
        }
        super.emitDefine(def, newComment.toString());
    }

    public int addExtensionsOfSymbols2Buffer(StringBuffer buf, String sep, String first, Collection col) {
        String extensionName;
        BuildStaticGLInfo glInfo = this.getGLConfig().getGLInfo();
        if (null == glInfo) {
            throw new RuntimeException("No GLInfo for: " + first);
        }
        int num = 0;
        if (null == buf) {
            buf = new StringBuffer();
        }
        Iterator iter = col.iterator();
        if (null != first && null != (extensionName = glInfo.getExtension(first))) {
            buf.append(extensionName);
            if (iter.hasNext()) {
                buf.append(sep);
            }
            ++num;
        }
        while (iter.hasNext()) {
            extensionName = glInfo.getExtension((String)iter.next());
            if (null == extensionName) continue;
            buf.append(extensionName);
            if (iter.hasNext()) {
                buf.append(sep);
            }
            ++num;
        }
        return num;
    }

    @Override
    protected void generateModifiedEmitters(JavaMethodBindingEmitter baseJavaEmitter, List emitters) {
        ArrayList superEmitters = new ArrayList();
        super.generateModifiedEmitters(baseJavaEmitter, superEmitters);
        boolean bufferObjectVariant = this.bufferObjectMethodBindings.containsKey(baseJavaEmitter.getBinding());
        for (JavaMethodBindingEmitter emitter : superEmitters) {
            if (emitter instanceof ProcAddressJavaMethodBindingEmitter) {
                emitter = new GLJavaMethodBindingEmitter((ProcAddressJavaMethodBindingEmitter)emitter, this, bufferObjectVariant);
            }
            emitters.add(emitter);
        }
    }

    protected boolean needsBufferObjectVariant(FunctionSymbol sym) {
        return this.getGLConfig().isBufferObjectFunction(sym.getName());
    }

    protected GLConfiguration getGLConfig() {
        return (GLConfiguration)this.getConfig();
    }

    @Override
    protected void endProcAddressTable() throws Exception {
        PrintWriter w = this.tableWriter;
        w.println("  /**");
        w.println("   * This is a convenience method to get (by name) the native function");
        w.println("   * pointer for a given function. It lets you avoid having to");
        w.println("   * manually compute the &quot;_addressof_ + ");
        w.println("   * &lt;functionName&gt;&quot; member variable name and look it up via");
        w.println("   * reflection; it also will throw an exception if you try to get the");
        w.println("   * address of an unknown function, or one that is statically linked");
        w.println("   * and therefore does not have a function pointer in this table.");
        w.println("   *");
        w.println("   * @throws RuntimeException if the function pointer was not found in");
        w.println("   *   this table, either because the function was unknown or because");
        w.println("   *   it was statically linked.");
        w.println("   */");
        w.println("  public long getAddressFor(String functionNameUsr) {");
        w.println("    String functionNameBase = com.sun.gluegen.runtime.opengl.GLExtensionNames.normalizeVEN(com.sun.gluegen.runtime.opengl.GLExtensionNames.normalizeARB(functionNameUsr, true), true);");
        w.println("    String addressFieldNameBase = " + this.getProcAddressConfig().gluegenRuntimePackage() + ".ProcAddressHelper.PROCADDRESS_VAR_PREFIX + functionNameBase;");
        w.println("    java.lang.reflect.Field addressField = null;");
        w.println("    int  funcNamePermNum = com.sun.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutationNumber(functionNameBase);");
        w.println("    for(int i = 0; null==addressField && i < funcNamePermNum; i++) {");
        w.println("        String addressFieldName = com.sun.gluegen.runtime.opengl.GLExtensionNames.getFuncNamePermutation(addressFieldNameBase, i);");
        w.println("        try {");
        w.println("          addressField = getClass().getField(addressFieldName);");
        w.println("        } catch (Exception e) { }");
        w.println("    }");
        w.println("");
        w.println("    if(null==addressField) {");
        w.println("      // The user is calling a bogus function or one which is not");
        w.println("      // runtime linked");
        w.println("      throw new RuntimeException(");
        w.println("          \"WARNING: Address field query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        w.println("          \"\\\"; it's either statically linked or address field is not a known \" +");
        w.println("          \"function\");");
        w.println("    } ");
        w.println("    try {");
        w.println("      return addressField.getLong(this);");
        w.println("    } catch (Exception e) {");
        w.println("      throw new RuntimeException(");
        w.println("          \"WARNING: Address query failed for \\\"\" + functionNameBase + \"\\\"/\\\"\" + functionNameUsr +");
        w.println("          \"\\\"; it's either statically linked or is not a known \" +");
        w.println("          \"function\", e);");
        w.println("    }");
        w.println("  }");
        w.println("} // end of class " + this.tableClassName);
        w.flush();
        w.close();
    }

    class ExtensionUnifier
    implements SymbolFilter {
        private List constants;
        private List functions;

        ExtensionUnifier() {
        }

        @Override
        public void filterSymbols(List constants, List functions) {
            this.constants = constants;
            this.functions = functions;
            this.doWork();
        }

        @Override
        public List getConstants() {
            return this.constants;
        }

        @Override
        public List getFunctions() {
            return this.functions;
        }

        private void doWork() {
            BuildStaticGLInfo glInfo = GLEmitter.this.getGLConfig().getGLInfo();
            if (glInfo == null) {
                return;
            }
            LinkedHashMap<String, ConstantDefinition> constantMap = new LinkedHashMap<String, ConstantDefinition>();
            LinkedHashMap<String, FunctionSymbol> functionMap = new LinkedHashMap<String, FunctionSymbol>();
            for (ConstantDefinition def : this.constants) {
                constantMap.put(def.getName(), def);
            }
            for (FunctionSymbol sym : this.functions) {
                functionMap.put(sym.getName(), sym);
            }
            Set extensionNames = glInfo.getExtensions();
            for (String extension : extensionNames) {
                boolean isFunc;
                Set declarations = glInfo.getDeclarations(extension);
                boolean isExtension = true;
                boolean shouldUnify = true;
                String cause = null;
                for (String decl : declarations) {
                    boolean bl = isFunc = !decl.startsWith("GL_");
                    if (!GLExtensionNames.isExtension((String)decl, (boolean)isFunc)) {
                        isExtension = false;
                        break;
                    }
                    if (isFunc) {
                        if (!functionMap.containsKey(decl)) {
                            isExtension = false;
                            break;
                        }
                    } else if (!constantMap.containsKey(decl)) {
                        isExtension = false;
                        break;
                    }
                    cause = decl;
                    String unifiedName = GLExtensionNames.normalize((String)decl, (boolean)isFunc);
                    shouldUnify = glInfo.getExtension(unifiedName) != null;
                    if (shouldUnify) continue;
                    break;
                }
                if (!isExtension) continue;
                if (shouldUnify) {
                    for (String decl : declarations) {
                        boolean bl = isFunc = !decl.startsWith("GL_");
                        if (isFunc) {
                            functionMap.remove(decl);
                            continue;
                        }
                        constantMap.remove(decl);
                    }
                    System.err.println("INFO: unified extension " + extension + " into core API");
                    continue;
                }
                System.err.println("INFO: didn't unify extension " + extension + " into core API because of " + cause);
            }
            this.constants = new ArrayList();
            Iterator iter = constantMap.keySet().iterator();
            while (iter.hasNext()) {
                this.constants.add(constantMap.get(iter.next()));
            }
            this.functions = new ArrayList();
            iter = functionMap.keySet().iterator();
            while (iter.hasNext()) {
                this.functions.add(functionMap.get(iter.next()));
            }
        }
    }

    static class BufferObjectKind {
        static final BufferObjectKind UNPACK_PIXEL = new BufferObjectKind();
        static final BufferObjectKind PACK_PIXEL = new BufferObjectKind();
        static final BufferObjectKind ARRAY = new BufferObjectKind();
        static final BufferObjectKind ELEMENT = new BufferObjectKind();

        private BufferObjectKind() {
        }
    }
}

