/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.pcpp;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;

public class ConcatenatingReader
extends FilterReader {
    private char[] curBuf;
    private int curPos;
    private BufferedReader reader;
    private static String newline = System.getProperty("line.separator");

    public ConcatenatingReader(BufferedReader in) {
        super(in);
        this.reader = in;
    }

    @Override
    public int read() throws IOException {
        char[] tmp = new char[1];
        int num = this.read(tmp, 0, 1);
        if (num < 0) {
            return -1;
        }
        return tmp[0];
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean ready() throws IOException {
        return this.curBuf != null || this.reader.ready();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.curBuf == null) {
            this.nextLine();
        }
        if (this.curBuf == null) {
            return -1;
        }
        int numRead = 0;
        while (len > 0 && this.curBuf != null && this.curPos < this.curBuf.length) {
            cbuf[off] = this.curBuf[this.curPos];
            ++this.curPos;
            ++off;
            --len;
            ++numRead;
            if (this.curPos != this.curBuf.length) continue;
            this.nextLine();
        }
        return numRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long numSkipped = 0L;
        while (n > 0L) {
            int intN = (int)n;
            char[] tmp = new char[intN];
            int numRead = this.read(tmp, 0, intN);
            n -= (long)numRead;
            numSkipped += (long)numRead;
            if (numRead >= intN) continue;
            break;
        }
        return numSkipped;
    }

    private void nextLine() throws IOException {
        String cur = this.reader.readLine();
        if (cur == null) {
            this.curBuf = null;
            return;
        }
        int numChars = cur.length();
        boolean needNewline = true;
        if (numChars > 0 && cur.charAt(cur.length() - 1) == '\\') {
            --numChars;
            needNewline = false;
        }
        char[] buf = new char[numChars + (needNewline ? newline.length() : 0)];
        cur.getChars(0, numChars, buf, 0);
        if (needNewline) {
            newline.getChars(0, newline.length(), buf, numChars);
        }
        this.curBuf = buf;
        this.curPos = 0;
    }
}

