/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.pcpp;

import com.sun.gluegen.pcpp.ConcatenatingReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PCPP {
    private static final boolean disableDebugPrint = true;
    private Map<String, String> defineMap = new HashMap<String, String>(128);
    private Set<String> nonConstantDefines = new HashSet<String>(128);
    private List<String> includePaths;
    private ParseState state;
    private OutputStream out;
    private PrintWriter writer;
    private List<Boolean> enabledBits = new ArrayList<Boolean>();
    private static int debugPrintIndentLevel = 0;

    public PCPP(List<String> includePaths) {
        this.includePaths = includePaths;
        this.setOut(System.out);
    }

    public OutputStream out() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
        this.writer = new PrintWriter(out);
    }

    public void run(Reader reader, String filename) throws IOException {
        StreamTokenizer tok = null;
        BufferedReader bufReader = null;
        bufReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        tok = new StreamTokenizer(new ConcatenatingReader(bufReader));
        tok.resetSyntax();
        tok.wordChars(97, 122);
        tok.wordChars(65, 90);
        tok.wordChars(48, 57);
        tok.wordChars(95, 95);
        tok.wordChars(45, 46);
        tok.wordChars(160, 255);
        tok.whitespaceChars(0, 32);
        tok.quoteChar(34);
        tok.quoteChar(39);
        tok.eolIsSignificant(true);
        tok.slashSlashComments(true);
        tok.slashStarComments(true);
        ParseState curState = new ParseState(tok, filename);
        ParseState oldState = this.state;
        this.state = curState;
        this.lineDirective();
        this.parse();
        this.state = oldState;
        if (this.state != null) {
            this.lineDirective();
        }
    }

    public static void main(String[] args) {
        try {
            Reader reader = null;
            String filename = null;
            if (args.length == 0) {
                PCPP.usage();
            }
            ArrayList<String> includePaths = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                String arg;
                if (i < args.length - 1) {
                    arg = args[i];
                    if (arg.startsWith("-I")) {
                        String[] paths = arg.substring(2).split(System.getProperty("path.separator"));
                        for (int j = 0; j < paths.length; ++j) {
                            includePaths.add(paths[j]);
                        }
                        continue;
                    }
                    PCPP.usage();
                    continue;
                }
                arg = args[i];
                if (arg.equals("-")) {
                    reader = new InputStreamReader(System.in);
                    filename = "standard input";
                    continue;
                }
                if (arg.startsWith("-")) {
                    PCPP.usage();
                }
                filename = arg;
                reader = new BufferedReader(new FileReader(filename));
            }
            new PCPP(includePaths).run(reader, filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String findFile(String filename) {
        String sep = File.separator;
        for (String inclPath : this.includePaths) {
            String fullPath = inclPath + sep + filename;
            File file = new File(fullPath);
            if (!file.exists()) continue;
            return fullPath;
        }
        return null;
    }

    private static void usage() {
        System.out.println("Usage: java PCPP [filename | -]");
        System.out.println("Minimal pseudo-C-preprocessor.");
        System.out.println("Output goes to standard output. Standard input can be used as input");
        System.out.println("by passing '-' as the argument.");
        System.exit(1);
    }

    private void pushBackToken() throws IOException {
        this.state.tok().pushBack();
    }

    private int nextToken() throws IOException {
        return this.nextToken(false);
    }

    private int nextToken(boolean returnEOLs) throws IOException {
        int lineno = this.lineNumber();
        if (this.curToken() == 10) {
            this.state.setStartOfLine(true);
        } else if (!this.state.startOfFile()) {
            this.state.setStartOfLine(false);
        }
        this.state.setStartOfFile(false);
        int val = this.state.tok().nextToken();
        if (!returnEOLs && val == 10) {
            do {
                val = this.state.tok().nextToken();
                this.state.setStartOfLine(true);
                this.println();
            } while (val == 10);
        }
        if (this.lineNumber() > lineno + 1) {
            this.lineDirective();
        }
        return val;
    }

    private void nextRequiredToken(int requiredToken) throws IOException {
        int nextTok = this.nextToken();
        if (nextTok != requiredToken) {
            String msg = "Expected token '" + requiredToken + "' but got ";
            switch (nextTok) {
                case -1: {
                    msg = msg + "<EOF>";
                    break;
                }
                case 10: {
                    msg = msg + "<EOL>";
                    break;
                }
                default: {
                    msg = msg + "'" + this.curTokenAsString() + "'";
                }
            }
            msg = msg + " at file " + this.filename() + ", line " + this.lineNumber();
            throw new IOException(msg);
        }
    }

    private int curToken() {
        return this.state.tok().ttype;
    }

    private String curTokenAsString() {
        int t = this.curToken();
        if (t == -3) {
            return this.curWord();
        }
        if (t == 10) {
            throw new RuntimeException("Should not be converting EOL characters to strings");
        }
        char c = (char)t;
        if (c == '\"' || c == '\'') {
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            sb.append(this.state.tok().sval);
            sb.append(c);
            return sb.toString();
        }
        return new String(new char[]{c});
    }

    private String nextWord() throws IOException {
        int val = this.nextToken();
        if (val != -3) {
            throw new RuntimeException("Expected word at file " + this.filename() + ", line " + this.lineNumber());
        }
        return this.curWord();
    }

    private String curWord() {
        return this.state.tok().sval;
    }

    private boolean startOfLine() {
        return this.state.startOfLine();
    }

    private String filename() {
        return this.state.filename();
    }

    private int lineNumber() {
        return this.state.lineNumber();
    }

    private void parse() throws IOException {
        int tok = 0;
        while ((tok = this.nextToken()) != -1) {
            String s;
            String newS;
            if (this.startOfLine() && tok == 35) {
                this.preprocessorDirective();
                continue;
            }
            if (tok == -3) {
                this.print(" ");
            }
            if ((newS = this.defineMap.get(s = this.curTokenAsString())) == null) {
                newS = s;
            }
            this.print(newS);
        }
        this.flush();
    }

    private void preprocessorDirective() throws IOException {
        String w = this.nextWord();
        boolean shouldPrint = true;
        if (w.equals("define")) {
            this.handleDefine();
            shouldPrint = false;
        } else if (w.equals("undef")) {
            this.handleUndefine();
            shouldPrint = false;
        } else if (w.equals("if") || w.equals("elif")) {
            this.handleIf(w.equals("if"));
            shouldPrint = false;
        } else if (w.equals("ifdef") || w.equals("ifndef")) {
            this.handleIfdef(w.equals("ifdef"));
            shouldPrint = false;
        } else if (w.equals("else")) {
            this.handleElse();
            shouldPrint = false;
        } else if (w.equals("endif")) {
            this.handleEndif();
            shouldPrint = false;
        } else if (w.equals("include")) {
            this.handleInclude();
            shouldPrint = false;
        }
        if (shouldPrint) {
            this.print("# ");
            this.printToken();
        }
    }

    private void handleUndefine() throws IOException {
        String name = this.nextWord();
        this.debugPrint(true, "#undef " + name);
        ArrayList<String> values = new ArrayList<String>();
        while (this.nextToken(true) != 10) {
            values.add(this.curTokenAsString());
        }
        if (this.enabled()) {
            String oldDef = this.defineMap.remove(name);
            if (oldDef == null) {
                System.err.println("WARNING: ignoring redundant \"#undef " + name + "\", at \"" + this.filename() + "\" line " + this.lineNumber() + ": \"" + name + "\" was not previously defined");
            }
            this.nonConstantDefines.remove(name);
        } else {
            System.err.println("FAILED TO UNDEFINE: '" + name + "'  (line " + this.lineNumber() + " file " + this.filename() + ")");
        }
    }

    private void handleDefine() throws IOException {
        String name = this.nextWord();
        ArrayList<String> values = new ArrayList<String>();
        while (this.nextToken(true) != 10) {
            values.add(this.curTokenAsString());
        }
        this.debugPrint(true, "#define " + name);
        if (this.enabled()) {
            String oldDef;
            boolean emitDefine = true;
            int sz = values.size();
            if (sz == 0) {
                String value = "";
                oldDef = this.defineMap.put(name, value);
                if (oldDef != null && !oldDef.equals(value)) {
                    System.err.println("WARNING: \"" + name + "\" redefined from \"" + oldDef + "\" to \"\"");
                }
                emitDefine = false;
            } else if (sz == 1) {
                String value = (String)values.get(0);
                if (this.isConstant(value)) {
                    oldDef = this.defineMap.put(name, value);
                    if (oldDef != null && !oldDef.equals(value)) {
                        System.err.println("WARNING: \"" + name + "\" redefined from \"" + oldDef + "\" to \"" + value + "\"");
                    }
                    this.debugPrint(true, "#define " + name + " [" + oldDef + " ] -> " + value + " CONST");
                } else {
                    this.debugPrint(true, "#define " + name + " -> " + value + " SYMB");
                    String newValue = this.resolveDefine(value, true);
                    if (newValue != null) {
                        values.set(0, newValue);
                    } else {
                        this.defineMap.put(name, value);
                        this.nonConstantDefines.add(name);
                        emitDefine = false;
                    }
                }
            } else {
                boolean containsIdentifier = false;
                for (String value : values) {
                    if (!this.isIdentifier(value)) continue;
                    containsIdentifier = true;
                    break;
                }
                if (containsIdentifier) {
                    emitDefine = false;
                    StringBuffer val = new StringBuffer();
                    for (int i = 0; i < sz; ++i) {
                        if (i != 0) {
                            val.append(" ");
                        }
                        val.append(this.resolveDefine((String)values.get(i), false));
                    }
                    if (this.defineMap.get(name) != null) {
                        throw new RuntimeException("Cannot redefine symbol \"" + name + " from \"" + this.defineMap.get(name) + "\" to non-constant " + " definition \"" + val.toString() + "\"");
                    }
                    this.defineMap.put(name, val.toString());
                    this.nonConstantDefines.add(name);
                } else {
                    String value;
                    StringBuilder sb = new StringBuilder();
                    for (String v : values) {
                        sb.append(v);
                    }
                    value = sb.toString();
                    String oldDef2 = this.defineMap.put(name, value);
                    if (oldDef2 != null && !oldDef2.equals(value)) {
                        System.err.println("WARNING: \"" + name + "\" redefined from \"" + oldDef2 + "\" to \"" + value + "\"");
                    }
                    this.debugPrint(true, "#define " + name + " [" + oldDef2 + " ] -> " + value + " CONST");
                }
            }
            if (emitDefine) {
                this.print("# define ");
                this.print(name);
                this.print(" ");
                for (String v : values) {
                    this.print(v);
                }
                this.println();
            }
        }
    }

    private boolean isIdentifier(String value) {
        boolean identifier = false;
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) continue;
                identifier = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            identifier = false;
            break;
        }
        return identifier;
    }

    private boolean isConstant(String s) {
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return this.checkHex(s);
        }
        return this.checkDecimal(s);
    }

    private boolean checkHex(String s) {
        int i;
        char c = '\u0000';
        for (i = 2; i < s.length() && ((c = s.charAt(i)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F'); ++i) {
        }
        if (i == s.length()) {
            return true;
        }
        if (i == s.length() - 1) {
            return c == 'l' || c == 'L' || c == 'f' || c == 'F' || c == 'u' || c == 'U';
        }
        return false;
    }

    private boolean checkDecimal(String s) {
        try {
            Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private String resolveDefine(String word, boolean returnNullIfNotFound) {
        String lastWord = this.defineMap.get(word);
        if (lastWord == null) {
            if (returnNullIfNotFound) {
                return null;
            }
            return word;
        }
        String nextWord = null;
        do {
            if ((nextWord = this.defineMap.get(lastWord)) == null) continue;
            lastWord = nextWord;
        } while (nextWord != null);
        return lastWord;
    }

    private void handleIfdef(boolean isIfdef) throws IOException {
        String symbolName = this.nextWord();
        this.debugPrint(true, (isIfdef ? "#ifdef " : "#ifndef ") + symbolName);
        boolean symbolIsDefined = this.defineMap.get(symbolName) != null;
        this.debugPrint(true, (isIfdef ? "#ifdef " : "#ifndef ") + symbolName + "(defined: " + symbolIsDefined + ")");
        this.pushEnableBit(this.enabled() && symbolIsDefined == isIfdef);
    }

    private void handleElse() throws IOException {
        boolean enabledStatusBeforeElse = this.enabled();
        this.popEnableBit();
        this.pushEnableBit(this.enabled() && !enabledStatusBeforeElse);
        this.debugPrint(true, "#else ");
    }

    private void handleEndif() {
        boolean enabledBeforePopping = this.enabled();
        this.popEnableBit();
        this.debugPrint(!enabledBeforePopping, "#endif/end-else");
    }

    private void handleIf(boolean isIf) throws IOException {
        this.debugPrint(true, isIf ? "#if" : "#elif");
        boolean defineEvaluatedToTrue = this.handleIfRecursive(true);
        if (!isIf) {
            this.popEnableBit();
        }
        this.pushEnableBit(this.enabled() && defineEvaluatedToTrue == isIf);
    }

    private boolean handleIfRecursive(boolean greedy) throws IOException {
        int tok;
        boolean ifValue = true;
        int openParens = 0;
        do {
            tok = this.nextToken(true);
            switch (tok) {
                case 40: {
                    ++openParens;
                    ifValue = ifValue && this.handleIfRecursive(true);
                    break;
                }
                case 41: {
                    --openParens;
                    break;
                }
                case 33: {
                    boolean rhs = this.handleIfRecursive(false);
                    ifValue = !rhs;
                    break;
                }
                case 38: {
                    this.nextRequiredToken(38);
                    boolean rhs = this.handleIfRecursive(true);
                    ifValue = ifValue && rhs;
                    break;
                }
                case 124: {
                    this.nextRequiredToken(124);
                    boolean rhs = this.handleIfRecursive(true);
                    ifValue = ifValue || rhs;
                    break;
                }
                case 62: {
                    boolean rhs = this.handleIfRecursive(true);
                    ifValue = false;
                    break;
                }
                case 60: {
                    boolean rhs = this.handleIfRecursive(true);
                    ifValue = false;
                    break;
                }
                case 61: {
                    boolean rhs = this.handleIfRecursive(true);
                    ifValue = false;
                    break;
                }
                case -3: {
                    String word = this.curTokenAsString();
                    if (word.equals("defined")) {
                        this.nextRequiredToken(40);
                        String symbol = this.nextWord();
                        boolean isDefined = this.defineMap.get(symbol) != null;
                        ifValue = ifValue && isDefined;
                        this.nextRequiredToken(41);
                        break;
                    }
                    String symbolValue = this.defineMap.get(word);
                    if (symbolValue != null) {
                        return !this.nonConstantDefines.contains(word);
                    }
                    try {
                        return Double.parseDouble(word) != 0.0;
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            return Long.parseLong(word) != 0L;
                        }
                        catch (NumberFormatException nfe2) {
                            try {
                                return Boolean.valueOf(word) == Boolean.TRUE;
                            }
                            catch (NumberFormatException nfe3) {
                                return false;
                            }
                        }
                    }
                }
                case 10: {
                    this.pushBackToken();
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unexpected end of file while parsing #if statement at file " + this.filename() + ", line " + this.lineNumber());
                }
                default: {
                    throw new RuntimeException("Unexpected token (" + this.curTokenAsString() + ") while parsing " + "#if statement at file " + this.filename() + ", line " + this.lineNumber());
                }
            }
        } while (greedy && openParens >= 0 && tok != 10);
        return ifValue;
    }

    private void handleInclude() throws IOException {
        int t = this.nextToken();
        String filename = null;
        if (t == 34) {
            filename = this.curWord();
        } else if (t == 60) {
            StringBuffer buf = new StringBuffer();
            while ((t = this.nextToken()) != 62 && t != -1) {
                buf.append(this.curTokenAsString());
            }
            if (t == -1) {
                System.err.println("WARNING: unexpected EOF while processing #include directive");
            }
            filename = buf.toString();
        }
        this.debugPrint(true, "#include [" + filename + "]");
        if (this.enabled()) {
            String fullname = this.findFile(filename);
            if (fullname == null) {
                System.err.println("WARNING: unable to find #include file \"" + filename + "\"");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fullname));
            this.run(reader, fullname);
        }
    }

    private void debugPrint(boolean onlyPrintIfEnabled, String msg) {
    }

    private void pushEnableBit(boolean enabled) {
        this.enabledBits.add(enabled);
        ++debugPrintIndentLevel;
        this.debugPrint(false, "PUSH_ENABLED, NOW: " + this.enabled());
    }

    private void popEnableBit() {
        if (this.enabledBits.size() == 0) {
            System.err.println("WARNING: mismatched #ifdef/endif pairs");
            return;
        }
        this.enabledBits.remove(this.enabledBits.size() - 1);
        --debugPrintIndentLevel;
        this.debugPrint(false, "POP_ENABLED, NOW: " + this.enabled());
    }

    private boolean enabled() {
        return this.enabledBits.size() == 0 || this.enabledBits.get(this.enabledBits.size() - 1) != false;
    }

    private void print(String s) {
        if (this.enabled()) {
            this.writer.print(s);
        }
    }

    private void print(char c) {
        if (this.enabled()) {
            this.writer.print(c);
        }
    }

    private void println() {
        if (this.enabled()) {
            this.writer.println();
        }
    }

    private void printToken() {
        this.print(this.curTokenAsString());
    }

    private void flush() {
        if (this.enabled()) {
            this.writer.flush();
        }
    }

    private void lineDirective() {
        this.print("# " + this.lineNumber() + " \"" + this.filename() + "\"");
        this.println();
    }

    static class ParseState {
        private StreamTokenizer tok;
        private String filename;
        private boolean startOfLine;
        private boolean startOfFile;

        ParseState(StreamTokenizer tok, String filename) {
            this.tok = tok;
            this.filename = filename;
            this.startOfLine = true;
            this.startOfFile = true;
        }

        StreamTokenizer tok() {
            return this.tok;
        }

        String filename() {
            return this.filename;
        }

        int lineNumber() {
            return this.tok.lineno();
        }

        boolean startOfLine() {
            return this.startOfLine;
        }

        void setStartOfLine(boolean val) {
            this.startOfLine = val;
        }

        boolean startOfFile() {
            return this.startOfFile;
        }

        void setStartOfFile(boolean val) {
            this.startOfFile = val;
        }
    }
}

