/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.procaddress;

import com.sun.gluegen.CMethodBindingEmitter;
import com.sun.gluegen.JavaType;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.cgram.types.PointerType;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.procaddress.ProcAddressEmitter;
import java.io.PrintWriter;

public class ProcAddressCMethodBindingEmitter
extends CMethodBindingEmitter {
    private boolean callThroughProcAddress;
    private boolean needsLocalTypedef;
    private String localTypedefCallingConvention;
    private static String procAddressJavaTypeName = JavaType.createForClass(Long.TYPE).jniTypeName();
    private ProcAddressEmitter emitter;

    public ProcAddressCMethodBindingEmitter(CMethodBindingEmitter methodToWrap, final boolean callThroughProcAddress, boolean needsLocalTypedef, String localTypedefCallingConvention, ProcAddressEmitter emitter) {
        super(new MethodBinding(methodToWrap.getBinding()){

            @Override
            public String getName() {
                if (callThroughProcAddress) {
                    return "dispatch_" + super.getName();
                }
                return super.getName();
            }
        }, methodToWrap.getDefaultOutput(), methodToWrap.getJavaPackageName(), methodToWrap.getJavaClassName(), methodToWrap.getIsOverloadedBinding(), methodToWrap.getIsJavaMethodStatic(), true, methodToWrap.forIndirectBufferAndArrayImplementation(), methodToWrap.getMachineDescription());
        if (methodToWrap.getReturnValueCapacityExpression() != null) {
            this.setReturnValueCapacityExpression(methodToWrap.getReturnValueCapacityExpression());
        }
        if (methodToWrap.getReturnValueLengthExpression() != null) {
            this.setReturnValueLengthExpression(methodToWrap.getReturnValueLengthExpression());
        }
        this.setTemporaryCVariableDeclarations(methodToWrap.getTemporaryCVariableDeclarations());
        this.setTemporaryCVariableAssignments(methodToWrap.getTemporaryCVariableAssignments());
        this.setCommentEmitter(defaultCommentEmitter);
        this.callThroughProcAddress = callThroughProcAddress;
        this.needsLocalTypedef = needsLocalTypedef;
        this.localTypedefCallingConvention = localTypedefCallingConvention;
        this.emitter = emitter;
    }

    @Override
    protected int emitArguments(PrintWriter writer) {
        int numEmitted = super.emitArguments(writer);
        if (this.callThroughProcAddress) {
            if (numEmitted > 0) {
                writer.print(", ");
            }
            writer.print(procAddressJavaTypeName);
            writer.print(" procAddress");
            ++numEmitted;
        }
        return numEmitted;
    }

    @Override
    protected void emitBodyVariableDeclarations(PrintWriter writer) {
        if (this.callThroughProcAddress) {
            FunctionSymbol cSym = this.getBinding().getCSymbol();
            String funcPointerTypedefName = this.emitter.getFunctionPointerTypedefName(cSym);
            if (this.needsLocalTypedef) {
                PointerType funcPtrType = new PointerType(null, (Type)cSym.getType(), 0);
                funcPointerTypedefName = "_local_" + funcPointerTypedefName;
                writer.print("  typedef ");
                writer.print(funcPtrType.toString(funcPointerTypedefName, this.localTypedefCallingConvention));
                writer.println(";");
            }
            writer.print("  ");
            writer.print(funcPointerTypedefName);
            writer.print(" ptr_");
            writer.print(cSym.getName());
            writer.println(";");
        }
        super.emitBodyVariableDeclarations(writer);
    }

    @Override
    protected void emitBodyVariablePreCallSetup(PrintWriter writer, boolean emittingPrimitiveArrayCritical) {
        super.emitBodyVariablePreCallSetup(writer, emittingPrimitiveArrayCritical);
        if (this.callThroughProcAddress && !emittingPrimitiveArrayCritical) {
            FunctionSymbol cSym = this.getBinding().getCSymbol();
            String funcPointerTypedefName = this.emitter.getFunctionPointerTypedefName(cSym);
            if (this.needsLocalTypedef) {
                funcPointerTypedefName = "_local_" + funcPointerTypedefName;
            }
            String ptrVarName = "ptr_" + cSym.getName();
            writer.print("  ");
            writer.print(ptrVarName);
            writer.print(" = (");
            writer.print(funcPointerTypedefName);
            writer.println(") (intptr_t) procAddress;");
            writer.println("  assert(" + ptrVarName + " != NULL);");
        }
    }

    @Override
    protected void emitBodyCallCFunction(PrintWriter writer) {
        if (!this.callThroughProcAddress) {
            super.emitBodyCallCFunction(writer);
        } else {
            MethodBinding binding;
            writer.print("  ");
            Type cReturnType = this.binding.getCReturnType();
            if (!cReturnType.isVoid()) {
                writer.print("_res = ");
            }
            if ((binding = this.getBinding()).hasContainingType()) {
                throw new IllegalStateException("Cannot call through function pointer because binding has containing type: " + binding);
            }
            writer.print("(* ptr_");
            writer.print(binding.getCSymbol().getName());
            writer.print(") ");
            writer.print("(");
            this.emitBodyPassCArguments(writer);
            writer.println(");");
        }
    }

    @Override
    protected String jniMangle(MethodBinding binding) {
        StringBuffer buf = new StringBuffer(super.jniMangle(binding));
        if (this.callThroughProcAddress) {
            this.jniMangle(Long.TYPE, buf, false);
        }
        return buf.toString();
    }
}

