/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.procaddress;

import com.sun.gluegen.JavaConfiguration;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class ProcAddressConfiguration
extends JavaConfiguration {
    private boolean emitProcAddressTable = false;
    private String tableClassPackage;
    private String tableClassName = "ProcAddressTable";
    private Set skipProcAddressGen = new HashSet();
    private List forceProcAddressGen = new ArrayList();
    private Set forceProcAddressGenSet = new HashSet();
    private boolean forceProcAddressGen4All = false;
    private String getProcAddressTableExpr;
    private ConvNode procAddressNameConverter;
    private Map localProcAddressCallingConventionMap = new HashMap();
    private String localProcAddressCallingConvention4All = null;

    @Override
    protected void dispatch(String cmd, StringTokenizer tok, File file, String filename, int lineNo) throws IOException {
        if (cmd.equalsIgnoreCase("EmitProcAddressTable")) {
            this.emitProcAddressTable = this.readBoolean("EmitProcAddressTable", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ProcAddressTablePackage")) {
            this.tableClassPackage = this.readString("ProcAddressTablePackage", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ProcAddressTableClassName")) {
            this.tableClassName = this.readString("ProcAddressTableClassName", tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("SkipProcAddressGen")) {
            String sym = this.readString("SkipProcAddressGen", tok, filename, lineNo);
            this.skipProcAddressGen.add(sym);
        } else if (cmd.equalsIgnoreCase("ForceProcAddressGen")) {
            String funcName = this.readString("ForceProcAddressGen", tok, filename, lineNo);
            if (funcName.equals("__ALL__")) {
                this.forceProcAddressGen4All = true;
            } else {
                this.addForceProcAddressGen(funcName);
            }
        } else if (cmd.equalsIgnoreCase("GetProcAddressTableExpr")) {
            this.getProcAddressTableExpr = this.readGetProcAddressTableExpr(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("ProcAddressNameExpr")) {
            this.readProcAddressNameExpr(tok, filename, lineNo);
        } else if (cmd.equalsIgnoreCase("LocalProcAddressCallingConvention")) {
            this.readLocalProcAddressCallingConvention(tok, filename, lineNo);
        } else {
            super.dispatch(cmd, tok, file, filename, lineNo);
        }
    }

    protected String readGetProcAddressTableExpr(StringTokenizer tok, String filename, int lineNo) {
        try {
            String restOfLine = tok.nextToken("\n\r\f");
            return restOfLine.trim();
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"GetProcAddressTableExpr\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void setProcAddressNameExpr(String expr) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tok1 = new StringTokenizer(expr);
        while (tok1.hasMoreTokens()) {
            String sstr = tok1.nextToken();
            StringTokenizer tok2 = new StringTokenizer(sstr, "$()", true);
            while (tok2.hasMoreTokens()) {
                tokens.add(tok2.nextToken());
            }
        }
        this.procAddressNameConverter = ProcAddressConfiguration.makeConverter(tokens.iterator());
        if (this.procAddressNameConverter == null) {
            throw new NoSuchElementException("Error creating converter from string");
        }
    }

    protected void readProcAddressNameExpr(StringTokenizer tok, String filename, int lineNo) {
        try {
            String restOfLine = tok.nextToken("\n\r\f");
            restOfLine = restOfLine.trim();
            this.setProcAddressNameExpr(restOfLine);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"ProcAddressNameExpr\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    protected void readLocalProcAddressCallingConvention(StringTokenizer tok, String filename, int lineNo) throws IOException {
        try {
            String functionName = tok.nextToken();
            String callingConvention = tok.nextToken();
            if (functionName.equals("__ALL__")) {
                this.localProcAddressCallingConvention4All = callingConvention;
            } else {
                this.localProcAddressCallingConventionMap.put(functionName, callingConvention);
            }
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Error parsing \"LocalProcAddressCallingConvention\" command at line " + lineNo + " in file \"" + filename + "\"", e);
        }
    }

    private static ConvNode makeConverter(Iterator iter) {
        ArrayList<ConvNode> result = new ArrayList<ConvNode>();
        while (iter.hasNext()) {
            String str = (String)iter.next();
            if (str.equals("$")) {
                String command = (String)iter.next();
                String openParen = (String)iter.next();
                if (!openParen.equals("(")) {
                    throw new NoSuchElementException("Expected \"(\"");
                }
                boolean uppercase = false;
                if (command.equalsIgnoreCase("UPPERCASE")) {
                    uppercase = true;
                } else if (!command.equalsIgnoreCase("LOWERCASE")) {
                    throw new NoSuchElementException("Unknown ProcAddressNameExpr command \"" + command + "\"");
                }
                result.add(new CaseNode(uppercase, ProcAddressConfiguration.makeConverter(iter)));
                continue;
            }
            if (str.equals(")")) continue;
            if (str.indexOf(123) >= 0) {
                result.add(new FormatNode(str));
                continue;
            }
            result.add(new ConstStringNode(str));
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return (ConvNode)result.get(0);
        }
        return new ConcatNode(result);
    }

    public boolean emitProcAddressTable() {
        return this.emitProcAddressTable;
    }

    public String tableClassPackage() {
        return this.tableClassPackage;
    }

    public String tableClassName() {
        return this.tableClassName;
    }

    public boolean skipProcAddressGen(String name) {
        return this.skipProcAddressGen.contains(name);
    }

    public boolean isForceProcAddressGen4All() {
        return this.forceProcAddressGen4All;
    }

    public List getForceProcAddressGen() {
        return this.forceProcAddressGen;
    }

    public String getProcAddressTableExpr() {
        if (this.getProcAddressTableExpr == null) {
            throw new RuntimeException("GetProcAddressTableExpr was not defined in .cfg file");
        }
        return this.getProcAddressTableExpr;
    }

    public String convertToFunctionPointerName(String funcName) {
        if (this.procAddressNameConverter == null) {
            throw new RuntimeException("ProcAddressNameExpr was not defined in .cfg file");
        }
        return this.procAddressNameConverter.convert(funcName);
    }

    public boolean forceProcAddressGen(String funcName) {
        return this.forceProcAddressGen4All || this.forceProcAddressGenSet.contains(funcName);
    }

    public void addForceProcAddressGen(String funcName) {
        this.forceProcAddressGen.add(funcName);
        this.forceProcAddressGenSet.add(funcName);
    }

    public void addLocalProcAddressCallingConvention(String funcName, String callingConvention) {
        this.localProcAddressCallingConventionMap.put(funcName, callingConvention);
    }

    public String getLocalProcAddressCallingConvention(String funcName) {
        if (this.isLocalProcAddressCallingConvention4All()) {
            return this.getLocalProcAddressCallingConvention4All();
        }
        return (String)this.localProcAddressCallingConventionMap.get(funcName);
    }

    public boolean isLocalProcAddressCallingConvention4All() {
        return this.localProcAddressCallingConvention4All != null;
    }

    public String getLocalProcAddressCallingConvention4All() {
        return this.localProcAddressCallingConvention4All;
    }

    static class CaseNode
    extends ConvNode {
        private boolean upperCase;
        private ConvNode child;

        CaseNode(boolean upperCase, ConvNode child) {
            this.upperCase = upperCase;
            this.child = child;
        }

        @Override
        public String convert(String funcName) {
            if (this.upperCase) {
                return this.child.convert(funcName).toUpperCase();
            }
            return this.child.convert(funcName).toLowerCase();
        }
    }

    static class ConcatNode
    extends ConvNode {
        private List children;

        ConcatNode(List children) {
            this.children = children;
        }

        @Override
        String convert(String funcName) {
            StringBuffer res = new StringBuffer();
            for (ConvNode node : this.children) {
                res.append(node.convert(funcName));
            }
            return res.toString();
        }
    }

    static class ConstStringNode
    extends ConvNode {
        private String str;

        ConstStringNode(String str) {
            this.str = str;
        }

        @Override
        String convert(String funcName) {
            return this.str;
        }
    }

    static class FormatNode
    extends ConvNode {
        private MessageFormat msgFmt;

        FormatNode(String fmt) {
            this.msgFmt = new MessageFormat(fmt);
        }

        @Override
        String convert(String funcName) {
            StringBuffer buf = new StringBuffer();
            this.msgFmt.format(new Object[]{funcName}, buf, (FieldPosition)null);
            return buf.toString();
        }
    }

    static abstract class ConvNode {
        ConvNode() {
        }

        abstract String convert(String var1);
    }
}

