/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.procaddress;

import com.sun.gluegen.CMethodBindingEmitter;
import com.sun.gluegen.CodeGenUtils;
import com.sun.gluegen.FunctionEmitter;
import com.sun.gluegen.JavaConfiguration;
import com.sun.gluegen.JavaEmitter;
import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.cgram.types.FunctionSymbol;
import com.sun.gluegen.cgram.types.FunctionType;
import com.sun.gluegen.cgram.types.Type;
import com.sun.gluegen.cgram.types.TypeDictionary;
import com.sun.gluegen.procaddress.ProcAddressCMethodBindingEmitter;
import com.sun.gluegen.procaddress.ProcAddressConfiguration;
import com.sun.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcAddressEmitter
extends JavaEmitter {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static final String WRAP_PREFIX = "dispatch_";
    private TypeDictionary typedefDictionary;
    protected PrintWriter tableWriter;
    protected Set emittedTableEntries;
    protected String tableClassPackage;
    protected String tableClassName;

    @Override
    public void beginFunctions(TypeDictionary typedefDictionary, TypeDictionary structDictionary, Map canonMap) throws Exception {
        this.typedefDictionary = typedefDictionary;
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.beginProcAddressTable();
        }
        super.beginFunctions(typedefDictionary, structDictionary, canonMap);
    }

    @Override
    public void endFunctions() throws Exception {
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.endProcAddressTable();
        }
        super.endFunctions();
    }

    @Override
    public void beginStructs(TypeDictionary typedefDictionary, TypeDictionary structDictionary, Map canonMap) throws Exception {
        super.beginStructs(typedefDictionary, structDictionary, canonMap);
    }

    public String runtimeExceptionType() {
        return this.getConfig().runtimeExceptionType();
    }

    public String unsupportedExceptionType() {
        return this.getConfig().unsupportedExceptionType();
    }

    @Override
    protected JavaConfiguration createConfig() {
        return new ProcAddressConfiguration();
    }

    @Override
    protected List generateMethodBindingEmitters(HashSet methodBindingSet, FunctionSymbol sym) throws Exception {
        return this.generateMethodBindingEmittersImpl(methodBindingSet, sym);
    }

    protected boolean needsModifiedEmitters(FunctionSymbol sym) {
        return this.needsProcAddressWrapper(sym) && !this.getConfig().isUnimplemented(this.getAliasedSymName(sym));
    }

    private List generateMethodBindingEmittersImpl(HashSet methodBindingSet, FunctionSymbol sym) throws Exception {
        List defaultEmitters = super.generateMethodBindingEmitters(methodBindingSet, sym);
        if (defaultEmitters.isEmpty()) {
            return defaultEmitters;
        }
        if (!this.needsModifiedEmitters(sym)) {
            return defaultEmitters;
        }
        ArrayList modifiedEmitters = new ArrayList(defaultEmitters.size());
        if (this.needsProcAddressWrapper(sym) && this.getProcAddressConfig().emitProcAddressTable()) {
            this.emitProcAddressTableEntryForString(this.getAliasedSymName(sym));
        }
        for (FunctionEmitter emitter : defaultEmitters) {
            if (emitter instanceof JavaMethodBindingEmitter) {
                this.generateModifiedEmitters((JavaMethodBindingEmitter)emitter, modifiedEmitters);
                continue;
            }
            if (emitter instanceof CMethodBindingEmitter) {
                this.generateModifiedEmitters((CMethodBindingEmitter)emitter, modifiedEmitters);
                continue;
            }
            throw new RuntimeException("Unexpected emitter type: " + emitter.getClass().getName());
        }
        return modifiedEmitters;
    }

    protected String getFunctionPointerTypedefName(FunctionSymbol sym) {
        return this.getProcAddressConfig().convertToFunctionPointerName(sym.getName());
    }

    protected void generateModifiedEmitters(JavaMethodBindingEmitter baseJavaEmitter, List emitters) {
        if (this.getConfig().manuallyImplement(baseJavaEmitter.getName())) {
            emitters.add(baseJavaEmitter);
            return;
        }
        boolean callThroughProcAddress = this.needsProcAddressWrapper(baseJavaEmitter.getBinding().getCSymbol());
        ProcAddressJavaMethodBindingEmitter emitter = new ProcAddressJavaMethodBindingEmitter(baseJavaEmitter, callThroughProcAddress, this.getProcAddressConfig().getProcAddressTableExpr(), baseJavaEmitter.isForImplementingMethodCall(), this);
        emitters.add(emitter);
        if (baseJavaEmitter.signatureOnly() && !baseJavaEmitter.hasModifier(JavaMethodBindingEmitter.PRIVATE) && baseJavaEmitter.hasModifier(JavaMethodBindingEmitter.NATIVE) && callThroughProcAddress) {
            emitter.setEmitBody(true);
            emitter.removeModifier(JavaMethodBindingEmitter.NATIVE);
            emitter = new ProcAddressJavaMethodBindingEmitter(baseJavaEmitter, callThroughProcAddress, this.getProcAddressConfig().getProcAddressTableExpr(), true, this);
            emitter.setForImplementingMethodCall(true);
            emitters.add(emitter);
        }
    }

    protected void generateModifiedEmitters(CMethodBindingEmitter baseCEmitter, List emitters) {
        boolean callThroughProcAddress = this.needsProcAddressWrapper(baseCEmitter.getBinding().getCSymbol());
        boolean forceProcAddress = this.getProcAddressConfig().forceProcAddressGen(baseCEmitter.getBinding().getCSymbol().getName());
        String forcedCallingConvention = null;
        if (forceProcAddress) {
            forcedCallingConvention = this.getProcAddressConfig().getLocalProcAddressCallingConvention(baseCEmitter.getBinding().getCSymbol().getName());
        }
        ProcAddressCMethodBindingEmitter res = new ProcAddressCMethodBindingEmitter(baseCEmitter, callThroughProcAddress, forceProcAddress, forcedCallingConvention, this);
        MessageFormat exp = baseCEmitter.getReturnValueCapacityExpression();
        if (exp != null) {
            res.setReturnValueCapacityExpression(exp);
        }
        emitters.add(res);
    }

    private String getAliasedSymName(FunctionSymbol sym) {
        String symName = this.getConfig().getJavaSymbolRename(sym.getName());
        if (null == symName) {
            symName = sym.getName();
        }
        return symName;
    }

    protected boolean needsProcAddressWrapper(FunctionSymbol sym) {
        Type funcPointerType;
        String symName = this.getAliasedSymName(sym);
        ProcAddressConfiguration config = this.getProcAddressConfig();
        String funcPointerTypedefName = this.getFunctionPointerTypedefName(sym);
        boolean shouldWrap = this.typedefDictionary.containsKey(funcPointerTypedefName);
        if (config.skipProcAddressGen(symName)) {
            shouldWrap = false;
        }
        if (config.forceProcAddressGen(symName)) {
            shouldWrap = true;
        }
        if (shouldWrap && (funcPointerType = this.typedefDictionary.get(funcPointerTypedefName)) != null) {
            FunctionType typedef = funcPointerType.asPointer().getTargetType().asFunction();
            FunctionType fun = sym.getType();
            int numarg = typedef.getNumArguments();
            for (int i = 0; i < numarg; ++i) {
                if (fun.getArgumentName(i) != null) continue;
                fun.setArgumentName(i, typedef.getArgumentName(i));
            }
        }
        return shouldWrap;
    }

    protected void beginProcAddressTable() throws Exception {
        this.tableClassPackage = this.getProcAddressConfig().tableClassPackage();
        this.tableClassName = this.getProcAddressConfig().tableClassName();
        String implPackageName = this.tableClassPackage;
        if (implPackageName == null) {
            implPackageName = this.getImplPackageName();
        }
        String jImplRoot = this.getJavaOutputDir() + File.separator + CodeGenUtils.packageAsPath(implPackageName);
        this.tableWriter = this.openFile(jImplRoot + File.separator + this.tableClassName + ".java");
        this.emittedTableEntries = new HashSet();
        CodeGenUtils.emitAutogeneratedWarning(this.tableWriter, this);
        this.tableWriter.println("package " + implPackageName + ";");
        this.tableWriter.println();
        Iterator iter = this.getConfig().imports().iterator();
        while (iter.hasNext()) {
            this.tableWriter.println("import " + (String)iter.next() + ";");
        }
        this.tableWriter.println();
        this.tableWriter.println("/**");
        this.tableWriter.println(" * This table is a cache of pointers to the dynamically-linkable C");
        this.tableWriter.println(" * functions this autogenerated Java binding has exposed. Some");
        this.tableWriter.println(" * libraries such as OpenGL, OpenAL and others define function pointer");
        this.tableWriter.println(" * signatures rather than statically linkable entry points for the");
        this.tableWriter.println(" * purposes of being able to query at run-time whether a particular");
        this.tableWriter.println(" * extension is available. This table acts as a cache of these");
        this.tableWriter.println(" * function pointers. Each function pointer is typically looked up at");
        this.tableWriter.println(" * run-time by a platform-dependent mechanism such as dlsym(),");
        this.tableWriter.println(" * wgl/glXGetProcAddress(), or alGetProcAddress(). The associated");
        this.tableWriter.println(" * autogenerated Java and C code accesses the fields in this table to");
        this.tableWriter.println(" * call the various functions. If the field containing the function");
        this.tableWriter.println(" * pointer is 0, the function is considered to be unavailable and can");
        this.tableWriter.println(" * not be called.");
        this.tableWriter.println(" */");
        this.tableWriter.println("public class " + this.tableClassName + " implements com.sun.gluegen.runtime.ProcAddressTable");
        this.tableWriter.println("{");
        iter = this.getProcAddressConfig().getForceProcAddressGen().iterator();
        while (iter.hasNext()) {
            this.emitProcAddressTableEntryForString((String)iter.next());
        }
    }

    protected void endProcAddressTable() throws Exception {
        PrintWriter w = this.tableWriter;
        w.println("  /**");
        w.println("   * This is a convenience method to get (by name) the native function");
        w.println("   * pointer for a given function. It lets you avoid having to");
        w.println("   * manually compute the &quot;_addressof_ + ");
        w.println("   * &lt;functionName&gt;&quot; member variable name and look it up via");
        w.println("   * reflection; it also will throw an exception if you try to get the");
        w.println("   * address of an unknown function, or one that is statically linked");
        w.println("   * and therefore does not have a function pointer in this table.");
        w.println("   *");
        w.println("   * @throws RuntimeException if the function pointer was not found in");
        w.println("   *   this table, either because the function was unknown or because");
        w.println("   *   it was statically linked.");
        w.println("   */");
        w.println("  public long getAddressFor(String functionName) {");
        w.println("    String addressFieldName = " + this.getProcAddressConfig().gluegenRuntimePackage() + ".ProcAddressHelper.PROCADDRESS_VAR_PREFIX + functionName;");
        w.println("    try { ");
        w.println("      java.lang.reflect.Field addressField = getClass().getField(addressFieldName);");
        w.println("      return addressField.getLong(this);");
        w.println("    } catch (Exception e) {");
        w.println("      // The user is calling a bogus function or one which is not");
        w.println("      // runtime linked");
        w.println("      throw new RuntimeException(");
        w.println("          \"WARNING: Address query failed for \\\"\" + functionName +");
        w.println("          \"\\\"; it's either statically linked or is not a known \" +");
        w.println("          \"function\", e);");
        w.println("    } ");
        w.println("  }");
        w.println("} // end of class " + this.tableClassName);
        w.flush();
        w.close();
    }

    protected void emitProcAddressTableEntryForString(String str) {
        if (this.emittedTableEntries.contains(str)) {
            return;
        }
        this.emittedTableEntries.add(str);
        this.tableWriter.print("  public long ");
        this.tableWriter.print(PROCADDRESS_VAR_PREFIX);
        this.tableWriter.print(str);
        this.tableWriter.println(";");
    }

    protected ProcAddressConfiguration getProcAddressConfig() {
        return (ProcAddressConfiguration)this.getConfig();
    }
}

