/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.procaddress;

import com.sun.gluegen.CommentEmitter;
import com.sun.gluegen.FunctionEmitter;
import com.sun.gluegen.JavaMethodBindingEmitter;
import com.sun.gluegen.MethodBinding;
import com.sun.gluegen.procaddress.ProcAddressEmitter;
import java.io.PrintWriter;

public class ProcAddressJavaMethodBindingEmitter
extends JavaMethodBindingEmitter {
    private final CommentEmitter commentEmitterForWrappedMethod = new WrappedMethodCommentEmitter();
    protected boolean callThroughProcAddress;
    protected String getProcAddressTableExpr;
    protected boolean changeNameAndArguments;
    protected ProcAddressEmitter emitter;

    public ProcAddressJavaMethodBindingEmitter(JavaMethodBindingEmitter methodToWrap, boolean callThroughProcAddress, String getProcAddressTableExpr, boolean changeNameAndArguments, ProcAddressEmitter emitter) {
        super(methodToWrap);
        this.callThroughProcAddress = callThroughProcAddress;
        this.getProcAddressTableExpr = getProcAddressTableExpr;
        this.changeNameAndArguments = changeNameAndArguments;
        this.emitter = emitter;
        if (callThroughProcAddress) {
            this.setCommentEmitter(new WrappedMethodCommentEmitter());
        }
        if (methodToWrap.getBinding().hasContainingType()) {
            throw new IllegalArgumentException("Cannot create proc. address wrapper; method has containing type: \"" + methodToWrap.getBinding() + "\"");
        }
    }

    public ProcAddressJavaMethodBindingEmitter(ProcAddressJavaMethodBindingEmitter methodToWrap) {
        this(methodToWrap, methodToWrap.callThroughProcAddress, methodToWrap.getProcAddressTableExpr, methodToWrap.changeNameAndArguments, methodToWrap.emitter);
    }

    @Override
    public String getName() {
        String res = super.getName();
        if (this.changeNameAndArguments) {
            return "dispatch_" + res;
        }
        return res;
    }

    @Override
    protected int emitArguments(PrintWriter writer) {
        int numEmitted = super.emitArguments(writer);
        if (this.callThroughProcAddress && this.changeNameAndArguments) {
            if (numEmitted > 0) {
                writer.print(", ");
            }
            writer.print("long procAddress");
            ++numEmitted;
        }
        return numEmitted;
    }

    @Override
    protected String getImplMethodName(boolean direct) {
        String name = super.getImplMethodName(direct);
        if (this.callThroughProcAddress) {
            return "dispatch_" + name;
        }
        return name;
    }

    @Override
    protected void emitPreCallSetup(MethodBinding binding, PrintWriter writer) {
        super.emitPreCallSetup(binding, writer);
        if (this.callThroughProcAddress) {
            String procAddressVariable = "_addressof_" + binding.getName();
            writer.println("    final long __addr_ = " + this.getProcAddressTableExpr + "." + procAddressVariable + ";");
            writer.println("    if (__addr_ == 0) {");
            writer.println("      throw new " + this.emitter.unsupportedExceptionType() + "(\"Method \\\"" + binding.getName() + "\\\" not available\");");
            writer.println("    }");
        }
    }

    @Override
    protected int emitCallArguments(MethodBinding binding, PrintWriter writer, boolean indirect) {
        int numEmitted = super.emitCallArguments(binding, writer, indirect);
        if (this.callThroughProcAddress) {
            if (numEmitted > 0) {
                writer.print(", ");
            }
            writer.print("__addr_");
            ++numEmitted;
        }
        return numEmitted;
    }

    public class WrappedMethodCommentEmitter
    extends JavaMethodBindingEmitter.DefaultCommentEmitter {
        public WrappedMethodCommentEmitter() {
            super(ProcAddressJavaMethodBindingEmitter.this);
        }

        @Override
        protected void emitBeginning(FunctionEmitter methodEmitter, PrintWriter writer) {
            writer.print("Entry point (through function pointer) to C language function: <br> ");
        }
    }
}

