/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.test;

import com.sun.gluegen.runtime.BufferFactory;
import com.sun.gluegen.runtime.CPU;
import com.sun.gluegen.runtime.StructAccessor;
import java.nio.ByteBuffer;

public class TestStructAccessorEndian {
    public static void main(String[] args) {
        boolean ok = true;
        int bitsPtr = CPU.getPointerSizeInBits();
        String bitsProp = System.getProperty("sun.arch.data.model");
        String os = System.getProperty("os.name");
        String cpu = System.getProperty("os.arch");
        System.out.println("OS: <" + os + "> CPU: <" + cpu + "> Bits: <" + bitsPtr + "/" + bitsProp + ">");
        System.out.println("CPU is: " + (CPU.is32Bit() ? "32" : "64") + " bit");
        System.out.println("Buffer is in: " + (BufferFactory.isLittleEndian() ? "little" : "big") + " endian");
        ByteBuffer tst = BufferFactory.newDirectByteBuffer((int)24);
        StructAccessor acc = new StructAccessor(tst);
        acc.setLongAt(0, 81985529216486895L);
        acc.setLongAt(1, -8613303245920329199L);
        acc.setLongAt(2, -5764925635173568514L);
        long v = acc.getLongAt(0);
        if (81985529216486895L != v) {
            System.out.println("Err[0] shall 0x0123456789ABCDEF, is: " + Long.toHexString(v));
            ok = false;
        }
        if (-8613303245920329199L != (v = acc.getLongAt(1))) {
            System.out.println("Err[1] shall 0x8877665544332211, is: " + Long.toHexString(v));
            ok = false;
        }
        if (-5764925635173568514L != (v = acc.getLongAt(2))) {
            System.out.println("Err[2] shall 0xAFFEDEADBEEFAFFE, is: " + Long.toHexString(v));
            ok = false;
        }
        if (!ok) {
            throw new RuntimeException("Long conversion failure");
        }
    }
}

