/*
 * Decompiled with CFR 0.152.
 */
package net.highteq.nativetaglet;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class NativeTaglet
implements Taglet {
    private Properties mapping = null;
    private static final String NAME = "native";
    private static final String[] openGLSuffixes = new String[]{"b", "s", "i", "f", "d", "ub", "us", "ui", "bv", "sv", "iv", "fv", "dv", "ubv", "usv", "uiv"};

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map tagletMap) {
        NativeTaglet tag = new NativeTaglet();
        Taglet t = (Taglet)tagletMap.get(tag.getName());
        if (t != null) {
            tagletMap.remove(tag.getName());
        }
        tagletMap.put(tag.getName(), tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Tag tag) {
        String text = tag.text().trim();
        if (this.mapping == null) {
            this.mapping = new Properties();
            InputStream in = null;
            try {
                URL url;
                try {
                    url = new URL(System.getProperty("nativetaglet.mapping", "file:native-taglet.properties"));
                }
                catch (MalformedURLException malformedURLException) {
                    url = new URL("file:" + System.getProperty("nativetaglet.mapping", "file:native-taglet.properties"));
                }
                in = url.openStream();
                this.mapping.load(in);
            }
            catch (Exception e) {
                System.err.println("[NATIVE TAGLET] Could not read mapping file");
                System.err.println("-->");
                e.printStackTrace(System.err);
                System.err.println("<--");
                System.err.println("[NATIVE TAGLET] !!! NO LINKS WILL BE GENERATED !!!");
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
        if (this.mapping != null) {
            String url = this.mapping.getProperty(text);
            if (url == null) {
                for (String string : this.mapping.keySet()) {
                    if (!NativeTaglet.hasOpenGLSuffix(text, string)) continue;
                    url = this.mapping.getProperty(string);
                    break;
                }
            }
            if (url != null) {
                url = this.mapping.getProperty("nativetaglet.baseUrl", "") + url;
                text = "<a href=\"" + url + "\">" + text + "</a>";
            }
        }
        return text;
    }

    private static boolean hasOpenGLSuffix(String name, String baseName) {
        if (!name.startsWith(baseName)) {
            return false;
        }
        for (int i = 0; i < openGLSuffixes.length; ++i) {
            String suffix = openGLSuffixes[i];
            if (!name.endsWith(suffix)) continue;
            if (name.equals(baseName + suffix)) {
                return true;
            }
            try {
                String tmp = name.substring(baseName.length(), name.length() - suffix.length());
                if (tmp.length() != 1 || !Character.isDigit(tmp.charAt(0))) continue;
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString(Tag[] tags) {
        return null;
    }
}

