/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.SourceContent;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Effect {
    public static final int NONE = 0;
    public static final int UNTRANSFORMED = 1;
    public static final int TRANSFORMED = 2;
    public static final int BOTH = 3;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final PropertyChangeListener inputListener;
    private final List<Effect> inputs;
    private final List<Effect> unmodifiableInputs;
    private final int maxInputs;
    private SourceContent content;

    protected Effect() {
        this.inputs = Collections.emptyList();
        this.unmodifiableInputs = this.inputs;
        this.maxInputs = 0;
        this.inputListener = null;
    }

    protected Effect(Effect input) {
        this.inputs = new ArrayList<Effect>(1);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 1;
        this.inputListener = new InputChangeListener();
        this.setInput(0, input);
    }

    protected Effect(Effect input1, Effect input2) {
        this.inputs = new ArrayList<Effect>(2);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 2;
        this.inputListener = new InputChangeListener();
        this.setInput(0, input1);
        this.setInput(1, input2);
    }

    Object getState() {
        return null;
    }

    public final List<Effect> getInputs() {
        return this.unmodifiableInputs;
    }

    protected void setInput(int index, Effect input) {
        if (input == null) {
            throw new IllegalArgumentException("Input must be non-null");
        }
        if (index < 0 || index >= this.maxInputs) {
            throw new IllegalArgumentException("Index must be within allowable range");
        }
        if (index < this.inputs.size()) {
            this.inputs.get(index).removePropertyChangeListener(this.inputListener);
            this.inputs.set(index, input);
        } else {
            this.inputs.add(input);
        }
        input.addPropertyChangeListener(this.inputListener);
        this.firePropertyChange("inputs", null, this.inputs);
    }

    public final SourceContent getSourceContent() {
        return this.content;
    }

    public void setSourceContent(SourceContent content) {
        this.content = content;
        for (Effect input : this.inputs) {
            input.setSourceContent(content);
        }
    }

    public abstract Image filter(GraphicsConfiguration var1);

    public final Image filter(GraphicsConfiguration config, boolean transformed) {
        AffineTransform xform;
        int type;
        Image img = this.filter(config);
        if (transformed && !this.isInDeviceSpace() && (type = (xform = this.content.getTransform()).getType()) != 0 && type != 1) {
            Image orig = img;
            Rectangle xformBounds = this.content.getTransformedBounds().getBounds();
            Rectangle2D origBounds = this.getBounds();
            img = Effect.getCompatibleImage(config, xformBounds.width, xformBounds.height);
            Graphics2D g2 = (Graphics2D)img.getGraphics();
            AffineTransform xform2 = new AffineTransform();
            xform2.translate(-xformBounds.getX(), -xformBounds.getY());
            xform2.concatenate(xform);
            xform2.translate(origBounds.getX(), origBounds.getY());
            g2.setTransform(xform2);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(orig, 0, 0, null);
            g2.dispose();
        }
        return img;
    }

    public final void render(Graphics2D g, int x, int y, boolean transformed) {
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        Image res = this.filter(gc, transformed);
        g.drawImage(res, x, y, null);
        Effect.releaseCompatibleImage(gc, res);
    }

    public abstract Rectangle2D getBounds();

    public final Rectangle2D getTransformedBounds() {
        Rectangle2D r = this.getBounds();
        AffineTransform xform = this.content.getTransform();
        if (!this.isInDeviceSpace() && xform != null && !xform.isIdentity()) {
            r = xform.createTransformedShape(r).getBounds();
        }
        return r;
    }

    public static Image createCompatibleImage(GraphicsConfiguration gc, int w, int h) {
        return EffectPeer.getRenderer(gc).createCompatibleImage(w, h);
    }

    public static Image getCompatibleImage(GraphicsConfiguration gc, int w, int h) {
        return EffectPeer.getRenderer(gc).getCompatibleImage(w, h);
    }

    public static void releaseCompatibleImage(GraphicsConfiguration gc, Image image) {
        EffectPeer.getRenderer(gc).releaseCompatibleImage(image);
    }

    public boolean isInDeviceSpace() {
        for (Effect input : this.getInputs()) {
            if (!input.isInDeviceSpace()) continue;
            return true;
        }
        return false;
    }

    public int needsSourceContent() {
        int val = 0;
        for (Effect input : this.getInputs()) {
            val |= input.needsSourceContent();
        }
        return val;
    }

    public abstract AccelType getAccelType(GraphicsConfiguration var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(prop, oldValue, newValue);
    }

    static {
        AccessHelper.setStateAccessor(new AccessHelper.StateAccessor(){

            @Override
            public Object getState(Effect effect) {
                return effect.getState();
            }
        });
    }

    public static enum AccelType {
        NONE("CPU/Java"),
        SIMD("CPU/SIMD"),
        FIXED("CPU/Fixed"),
        OPENGL("OpenGL"),
        DIRECT3D("Direct3D");

        private String text;

        private AccelType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    private class InputChangeListener
    implements PropertyChangeListener {
        private InputChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Effect.this.firePropertyChange("inputs", null, Effect.this.inputs);
        }
    }
}

