/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Source;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class Reflection
extends Effect {
    private float topOffset = 0.0f;
    private float topOpacity = 0.5f;
    private float bottomOpacity = 0.0f;
    private float fraction = 0.75f;

    public Reflection() {
        this(new Source(true));
    }

    public Reflection(Effect input) {
        super(input);
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public float getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(float topOffset) {
        float old = this.topOffset;
        this.topOffset = topOffset;
        this.firePropertyChange("topOffset", Float.valueOf(old), Float.valueOf(topOffset));
    }

    public float getTopOpacity() {
        return this.topOpacity;
    }

    public void setTopOpacity(float topOpacity) {
        if (topOpacity < 0.0f || topOpacity > 1.0f) {
            throw new IllegalArgumentException("Top opacity must be in the range [0,1]");
        }
        float old = this.topOpacity;
        this.topOpacity = topOpacity;
        this.firePropertyChange("topOpacity", Float.valueOf(old), Float.valueOf(topOpacity));
    }

    public float getBottomOpacity() {
        return this.bottomOpacity;
    }

    public void setBottomOpacity(float bottomOpacity) {
        if (bottomOpacity < 0.0f || bottomOpacity > 1.0f) {
            throw new IllegalArgumentException("Bottom opacity must be in the range [0,1]");
        }
        float old = this.bottomOpacity;
        this.bottomOpacity = bottomOpacity;
        this.firePropertyChange("bottomOpacity", Float.valueOf(old), Float.valueOf(bottomOpacity));
    }

    public float getFraction() {
        return this.fraction;
    }

    public void setFraction(float fraction) {
        if (fraction < 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("Fraction must be in the range [0,1]");
        }
        float old = this.fraction;
        this.fraction = fraction;
        this.firePropertyChange("fraction", Float.valueOf(old), Float.valueOf(fraction));
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D r = this.getInputs().get(0).getBounds();
        double refX = r.getX();
        double refY = r.getY() + r.getHeight() + (double)this.topOffset;
        double refW = r.getWidth();
        double refH = (double)this.fraction * r.getHeight();
        Rectangle2D.Double refBounds = new Rectangle2D.Double(refX, refY, refW, refH);
        r.add(refBounds);
        return r;
    }

    @Override
    public Image filter(GraphicsConfiguration config) {
        Rectangle2D fullBounds = this.getBounds();
        Rectangle2D inputBounds = this.getInputs().get(0).getBounds();
        Rectangle tmp = fullBounds.getBounds();
        int w = tmp.width;
        int h = tmp.height;
        Image dst = Reflection.getCompatibleImage(config, w, h);
        Image src = this.getInputs().get(0).filter(config);
        double refY = inputBounds.getHeight() + (double)this.topOffset;
        double refH = (double)this.fraction * inputBounds.getHeight();
        int imgY = (int)(inputBounds.getY() - fullBounds.getY());
        int imgH = (int)inputBounds.getHeight();
        int irefH = (int)(refH + 0.5);
        int irefY1 = (int)(refY + 0.5);
        int irefY2 = irefY1 + irefH;
        Graphics2D gdst = (Graphics2D)dst.getGraphics();
        Color c1 = new Color(1.0f, 1.0f, 1.0f, this.topOpacity);
        Color c2 = new Color(1.0f, 1.0f, 1.0f, this.bottomOpacity);
        gdst.setComposite(AlphaComposite.Src);
        gdst.setPaint(new GradientPaint(0.0f, irefY1, c1, 0.0f, irefY2, c2, true));
        gdst.fillRect(0, irefY1, w, irefH);
        gdst.setComposite(AlphaComposite.SrcIn);
        gdst.drawImage(src, 0, irefY2, w, irefY1, 0, imgH - irefH, w, imgH, null);
        Reflection.releaseCompatibleImage(config, src);
        gdst.setComposite(AlphaComposite.SrcOver);
        gdst.drawImage(src, 0, imgY, null);
        gdst.dispose();
        return dst;
    }

    @Override
    public Effect.AccelType getAccelType(GraphicsConfiguration config) {
        return this.getInputs().get(0).getAccelType(config);
    }
}

