/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.scenario.effect.impl.Renderer;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ImagePool {
    private final List<SoftReference<Image>> unlocked = new ArrayList<SoftReference<Image>>();
    private final List<SoftReference<Image>> locked = new ArrayList<SoftReference<Image>>();

    ImagePool() {
    }

    private static void clearImage(Image img) {
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, img.getWidth(null), img.getHeight(null));
        g2.dispose();
    }

    public synchronized Image checkOut(Renderer renderer, int w, int h) {
        Image img;
        Image eimg;
        SoftReference<Image> entry;
        SoftReference<Image> chosen = null;
        int mindiff = Integer.MAX_VALUE;
        Iterator<SoftReference<Image>> entries = this.unlocked.iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            eimg = entry.get();
            if (eimg == null) {
                entries.remove();
                continue;
            }
            int ew = eimg.getWidth(null);
            int eh = eimg.getHeight(null);
            if (ew < w || eh < h) continue;
            int diff = (ew - w) * (eh - h);
            if (chosen != null && diff >= mindiff) continue;
            chosen = entry;
            mindiff = diff;
        }
        if (chosen != null) {
            this.unlocked.remove(chosen);
            this.locked.add(chosen);
            img = (Image)chosen.get();
            ImagePool.clearImage(img);
            return img;
        }
        entries = this.locked.iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            eimg = entry.get();
            if (eimg != null) continue;
            entries.remove();
        }
        img = null;
        try {
            img = renderer.createCompatibleImage(w, h);
        }
        catch (OutOfMemoryError e) {
            // empty catch block
        }
        if (img == null) {
            this.pruneCache();
            try {
                img = renderer.createCompatibleImage(w, h);
            }
            catch (OutOfMemoryError e) {
                // empty catch block
            }
        }
        if (img != null) {
            this.locked.add(new SoftReference<Image>(img));
        }
        return img;
    }

    public synchronized void checkIn(Image img) {
        SoftReference<Image> chosen = null;
        Iterator<SoftReference<Image>> entries = this.locked.iterator();
        while (entries.hasNext()) {
            SoftReference<Image> entry = entries.next();
            Image eimg = entry.get();
            if (eimg == null) {
                entries.remove();
                continue;
            }
            if (eimg != img) continue;
            chosen = entry;
            break;
        }
        if (chosen != null) {
            this.locked.remove(chosen);
            this.unlocked.add(chosen);
        }
    }

    private void pruneCache() {
        int numToRemove = 2 * this.unlocked.size() / 3;
        Iterator<SoftReference<Image>> entries = this.unlocked.iterator();
        while (entries.hasNext() && numToRemove > 0) {
            SoftReference<Image> entry = entries.next();
            Image eimg = entry.get();
            if (eimg == null) {
                entries.remove();
                continue;
            }
            --numToRemove;
            eimg.flush();
            entries.remove();
        }
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
    }
}

