/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.light.Light;
import java.awt.Color;

public class PointLight
extends Light {
    private float x;
    private float y;
    private float z;

    public PointLight() {
        this(0.0f, 0.0f, 0.0f, Color.WHITE);
    }

    public PointLight(float x, float y, float z, Color color) {
        this(Light.Type.POINT, x, y, z, color);
    }

    PointLight(Light.Type type, float x, float y, float z, Color color) {
        super(type, color);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        float old = this.x;
        this.x = x;
        this.firePropertyChange("x", Float.valueOf(old), Float.valueOf(x));
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        float old = this.y;
        this.y = y;
        this.firePropertyChange("y", Float.valueOf(old), Float.valueOf(y));
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        float old = this.z;
        this.z = z;
        this.firePropertyChange("z", Float.valueOf(old), Float.valueOf(z));
    }

    @Override
    public float[] getNormalizedLightPosition() {
        float len = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (len == 0.0f) {
            len = 1.0f;
        }
        float[] pos = new float[]{this.x / len, this.y / len, this.z / len};
        return pos;
    }
}

