/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.justminecraft.plots.paperlib.PaperLib;
import net.justminecraft.plots.util.AsyncUtil;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;

public class ChunkBatcher
implements Runnable {
    private final World world;
    private final HashMap<Point, ChunkToModify> chunks = new HashMap();

    public ChunkBatcher(World world) {
        this.world = world;
    }

    public void setBlock(int x, int y, int z, BlockData blockData) {
        ChunkToModify chunk = this.chunks.computeIfAbsent(new Point(x >> 4, z >> 4), key -> new ChunkToModify(x >> 4, z >> 4));
        chunk.addBlock(x & 0xF, y, z & 0xF, blockData);
    }

    @Override
    public void run() {
        for (ChunkToModify chunk : this.chunks.values()) {
            chunk.run();
        }
    }

    private class ChunkToModify
    implements Runnable {
        private final int cx;
        private final int cz;
        private final List<BlockToModify> blocksToModify = new ArrayList<BlockToModify>();

        public ChunkToModify(int cx, int cz) {
            this.cx = cx;
            this.cz = cz;
        }

        public void addBlock(int x, int y, int z, BlockData blockData) {
            this.blocksToModify.add(new BlockToModify(x, y, z, blockData));
        }

        @Override
        public void run() {
            PaperLib.getChunkAtAsync(ChunkBatcher.this.world, this.cx, this.cz).thenAccept(chunk -> AsyncUtil.ensureMainThread(() -> {
                try {
                    for (BlockToModify block : this.blocksToModify) {
                        chunk.getBlock(block.x, block.y, block.z).setBlockData(block.blockData, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
        }
    }

    private class BlockToModify {
        private final int x;
        private final int y;
        private final int z;
        private final BlockData blockData;

        public BlockToModify(int x, int y, int z, BlockData blockData) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockData = blockData;
        }
    }
}

