/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.PlotId;
import net.justminecraft.plots.PlotWorld;
import net.justminecraft.plots.PlotWorldGenerator;
import net.justminecraft.plots.commands.JustPlotsCommand;
import net.justminecraft.plots.converters.PlotSquaredConverter;
import net.justminecraft.plots.database.Database;
import net.justminecraft.plots.database.PlotLoader;
import net.justminecraft.plots.database.SQLiteDatabase;
import net.justminecraft.plots.events.PlotClaimEvent;
import net.justminecraft.plots.listeners.PaperListener;
import net.justminecraft.plots.listeners.PlayerListener;
import net.justminecraft.plots.listeners.PlotListener;
import net.justminecraft.plots.listeners.WorldEditListener;
import net.justminecraft.plots.paperlib.PaperLib;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JustPlots
extends JavaPlugin {
    private static JustPlots plugin;
    private static Database database;
    private static HashMap<String, PlotWorld> plotWorlds;
    private static HashMap<UUID, TreeSet<Plot>> playerPlotListCache;
    private JustPlotsCommand justPlotsCommand;
    private PlotWorldGenerator plotWorldGenerator;

    public static JustPlots getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        PaperLib.suggestPaper((Plugin)this);
        database = new SQLiteDatabase(new File(this.getDataFolder(), "plots.db"));
        database.createTables();
        new PlotSquaredConverter(this);
        new PlotLoader(this);
        this.justPlotsCommand = new JustPlotsCommand(this);
        this.plotWorldGenerator = new PlotWorldGenerator();
        new PlayerListener(this);
        new PlotListener(this);
        if (this.hasWorldEdit()) {
            new WorldEditListener(this);
        }
        if (PaperLib.isPaper()) {
            new PaperListener(this);
        }
    }

    private boolean hasWorldEdit() {
        try {
            return Class.forName("com.sk89q.worldedit.bukkit.WorldEditPlugin") != null;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public void onDisable() {
        this.getLogger().info("Closing database connection");
        database.closeConnection();
    }

    @Nullable
    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, @Nullable String id) {
        return this.plotWorldGenerator;
    }

    @NotNull
    public static PlotWorld getPlotWorld(@NotNull World world) {
        return JustPlots.getPlotWorld(world.getName());
    }

    @NotNull
    public static PlotWorld getPlotWorld(@NotNull String world) {
        PlotWorld plotWorld = plotWorlds.get(world);
        if (plotWorld == null) {
            plotWorld = new PlotWorld(world);
            plotWorlds.put(world, plotWorld);
        }
        return plotWorld;
    }

    public static boolean isPlotWorld(@NotNull World world) {
        return JustPlots.getPlotWorld(world).isPlotWorld();
    }

    public static Plot getPlot(String world, int x, int z) {
        return JustPlots.getPlot(world, new PlotId(x, z));
    }

    public static Plot getPlot(String world, PlotId id) {
        return JustPlots.getPlotWorld(world).getPlot(id);
    }

    public static Plot getPlotAt(Entity entity) {
        return JustPlots.getPlotAt(entity.getLocation());
    }

    public static Plot getPlotAt(Location location) {
        PlotId id = JustPlots.getPlotIdAt(location);
        if (id == null) {
            return null;
        }
        Plot plot = JustPlots.getPlotWorld(location.getWorld()).getPlot(id.getX(), id.getZ());
        if (plot == null || !plot.inPlot(location)) {
            return null;
        }
        return plot;
    }

    public static PlotId getPlotIdAt(Entity entity) {
        return JustPlots.getPlotIdAt(entity.getLocation());
    }

    public static PlotId getPlotIdAt(Location location) {
        if (location.getWorld() == null) {
            return null;
        }
        PlotWorld world = JustPlots.getPlotWorld(location.getWorld());
        if (!world.isPlotWorld()) {
            return null;
        }
        int x = (int)Math.floor((double)location.getBlockX() / (double)(world.getPlotSize() + world.getRoadSize()));
        int z = (int)Math.floor((double)location.getBlockZ() / (double)(world.getPlotSize() + world.getRoadSize()));
        return new PlotId(x, z);
    }

    public static Set<Plot> getPlotsIfCached(UUID uuid) {
        return playerPlotListCache.get(uuid);
    }

    public static Set<Plot> getPlots(Player player) {
        return JustPlots.getPlots(player.getUniqueId());
    }

    public static Set<Plot> getPlots(UUID uuid) {
        if (playerPlotListCache.containsKey(uuid)) {
            return playerPlotListCache.get(uuid);
        }
        TreeSet<Plot> plots = new TreeSet<Plot>();
        for (PlotWorld world : plotWorlds.values()) {
            for (Plot plot : world.getPlots()) {
                if (!plot.getOwner().equals(uuid)) continue;
                plots.add(plot);
            }
        }
        playerPlotListCache.put(uuid, plots);
        return plots;
    }

    @NotNull
    public static List<Plot> getPlotsInWorld(@NotNull Player player, @Nullable World world) {
        return JustPlots.getPlotsInWorld(player, world == null ? null : world.getName());
    }

    @NotNull
    public static List<Plot> getPlotsInWorld(@NotNull Player player, @Nullable String world) {
        return JustPlots.getPlotsInWorld(player.getUniqueId(), world);
    }

    @NotNull
    public static List<Plot> getPlotsInWorld(@NotNull UUID uuid, @Nullable String world) {
        ArrayList<Plot> plotList = new ArrayList<Plot>();
        for (Plot plot : JustPlots.getPlots(uuid)) {
            if (world != null && !plot.getWorldName().equals(world)) continue;
            plotList.add(plot);
        }
        return plotList;
    }

    public static Collection<PlotWorld> getPlotWorlds() {
        return plotWorlds.values();
    }

    public static Database getDatabase() {
        return database;
    }

    public static Plot createPlot(String world, int x, int z, UUID owner) {
        return JustPlots.createPlot(world, x, z, owner, System.currentTimeMillis());
    }

    public static Plot createPlot(String world, int x, int z, UUID owner, long creation) {
        Plot plot = new Plot(world, x, z, owner, creation);
        plot.createInDatabase();
        return plot;
    }

    public static Plot claimPlot(String world, PlotId id, UUID owner) {
        return JustPlots.claimPlot(world, id.getX(), id.getZ(), owner);
    }

    public static Plot claimPlot(String world, int x, int z, UUID owner) {
        Plot plot = JustPlots.createPlot(world, x, z, owner);
        plot.claimWalls();
        plot.updateSign();
        PlotClaimEvent event = new PlotClaimEvent(plot, owner);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return plot;
    }

    @NotNull
    public static String getUsername(@NotNull UUID uuid) {
        User user;
        String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
        if (name != null) {
            return name;
        }
        Plugin essentials = Bukkit.getPluginManager().getPlugin("Essentials");
        if (essentials != null && (user = ((Essentials)essentials).getUser(uuid)) != null) {
            name = user.getName();
        }
        return name == null ? uuid.toString() : name;
    }

    public static int getMaxPlots(Permissible player) {
        int maxPlots = -1;
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            if (!permission.getPermission().startsWith("justplots.plots.") || !permission.getValue()) continue;
            try {
                int value = Integer.parseInt(permission.getPermission().substring("justplots.plots.".length()));
                if (value <= maxPlots) continue;
                maxPlots = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (maxPlots == -1) {
            maxPlots = Integer.MAX_VALUE;
        }
        return maxPlots;
    }

    public static PlotWorldGenerator getGenerator() {
        return JustPlots.getPlugin().plotWorldGenerator;
    }

    public static JustPlotsCommand getCommandExecuter() {
        return JustPlots.getPlugin().justPlotsCommand;
    }

    static {
        plotWorlds = new HashMap();
        playerPlotListCache = new HashMap();
    }
}

