/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.justminecraft.plots.ChunkBatcher;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.PlotId;
import net.justminecraft.plots.PlotWorld;
import net.justminecraft.plots.ResetManager;
import net.justminecraft.plots.events.PlotDeletedEvent;
import net.justminecraft.plots.paperlib.PaperLib;
import net.justminecraft.plots.util.AsyncUtil;
import net.justminecraft.plots.util.PaperUtil;
import net.justminecraft.plots.util.WorldHeight;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Plot
implements Comparable<Plot> {
    private final PlotId plotId;
    private final String world;
    private final int x;
    private final int z;
    private final UUID owner;
    private long creation;
    private final PlotWorld plotWorld;
    private final HashSet<UUID> added = new HashSet();

    public Plot(String world, int x, int z, UUID owner, long creation) {
        this.plotId = new PlotId(x, z);
        this.world = world;
        this.x = x;
        this.z = z;
        this.owner = owner;
        this.creation = creation;
        this.plotWorld = JustPlots.getPlotWorld(world);
        this.plotWorld.addPlot(this);
        Set<Plot> playerPlots = JustPlots.getPlotsIfCached(owner);
        if (playerPlots != null) {
            playerPlots.add(this);
        }
    }

    public void createInDatabase() {
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("INSERT OR IGNORE INTO justplots_plots (world, x, z, owner, creation) VALUES (?, ?, ?, ?, ?)");){
            statement.setString(1, this.world);
            statement.setInt(2, this.x);
            statement.setInt(3, this.z);
            statement.setString(4, this.owner.toString());
            statement.setTimestamp(5, new Timestamp(this.creation));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("DELETE FROM justplots_plots WHERE world = ? AND x = ? AND z = ?");){
            statement.setString(1, this.world);
            statement.setInt(2, this.x);
            statement.setInt(3, this.z);
            statement.executeUpdate();
            try (PreparedStatement statement2 = JustPlots.getDatabase().prepareStatement("DELETE FROM justplots_added WHERE world = ? AND x = ? AND z = ?");){
                statement2.setString(1, this.world);
                statement2.setInt(2, this.x);
                statement2.setInt(3, this.z);
                statement2.executeUpdate();
            }
            Set<Plot> playerPlots = JustPlots.getPlotsIfCached(this.owner);
            if (playerPlots != null) {
                playerPlots.remove(this);
            }
            this.plotWorld.removePlot(this);
            Bukkit.getScheduler().runTask((Plugin)JustPlots.getPlugin(), () -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlotDeletedEvent(this, this.owner)));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCreation(long time) {
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("UPDATE justplots_plots SET creation = ? WHERE world = ? AND x = ? AND z = ?");){
            statement.setTimestamp(1, new Timestamp(time));
            statement.setString(2, this.world);
            statement.setInt(3, this.x);
            statement.setInt(4, this.z);
            statement.executeUpdate();
            this.creation = time;
            Set<Plot> playerPlots = JustPlots.getPlotsIfCached(this.owner);
            if (playerPlots != null) {
                playerPlots.remove(this);
                playerPlots.add(this);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isOwner(OfflinePlayer player) {
        return this.isOwner(player.getUniqueId());
    }

    public boolean isOwner(UUID uuid) {
        return this.owner.equals(uuid);
    }

    public boolean isAdded(OfflinePlayer player) {
        return this.isAdded(player.getUniqueId());
    }

    public boolean isAdded(UUID uuid) {
        return this.isOwner(uuid) || this.added.contains(uuid);
    }

    public void addPlayer(UUID uuid) {
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("INSERT OR IGNORE INTO justplots_added (world, x, z, uuid) VALUES (?, ?, ?, ?)");){
            statement.setString(1, this.world);
            statement.setInt(2, this.x);
            statement.setInt(3, this.z);
            statement.setString(4, uuid.toString());
            statement.executeUpdate();
            this.added.add(uuid);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void removePlayer(UUID uuid) {
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("DELETE FROM justplots_added WHERE world = ? AND x = ? AND z = ? AND uuid = ?");){
            statement.setString(1, this.world);
            statement.setInt(2, this.x);
            statement.setInt(3, this.z);
            statement.setString(4, uuid.toString());
            statement.executeUpdate();
            this.added.remove(uuid);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.world + ";" + this.plotId.toString();
    }

    public int hashCode() {
        return this.world.hashCode() ^ this.plotId.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Plot && ((Plot)other).world.equals(this.world) && ((Plot)other).plotId.equals(this.plotId);
    }

    @Override
    public int compareTo(Plot other) {
        long diff = this.creation - other.creation;
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (diff < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (diff == 0L && !this.equals(other)) {
            return this.hashCode() - other.hashCode();
        }
        return (int)diff;
    }

    public PlotId getId() {
        return this.plotId;
    }

    public String getWorldName() {
        return this.world;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.getWorldName());
    }

    public PlotWorld getPlotWorld() {
        return this.plotWorld;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public HashSet<UUID> getAdded() {
        return this.added;
    }

    public long getCreation() {
        return this.creation;
    }

    public Location getHome() {
        Location bottom = this.getBottom();
        Location top = this.getTop();
        return new Location(this.getWorld(), (double)bottom.getBlockX() + (double)(top.getBlockX() - bottom.getBlockX()) / 2.0 + 0.5, (double)(this.plotWorld.getFloorHeight() + 1), (double)bottom.getBlockZ() - 1.5);
    }

    public String getCreationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.getCreation());
        return calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
    }

    public Location getSign() {
        Location sign = this.getBottom();
        sign.add(-1.0, (double)(this.plotWorld.getFloorHeight() + 1), -2.0);
        return sign;
    }

    public CompletableFuture<Block> getSignBlockAsync() {
        CompletableFuture<Block> future = new CompletableFuture<Block>();
        Location signLoc = this.getSign();
        PaperLib.getChunkAtAsync(this.getSign()).thenAccept(chunk -> AsyncUtil.ensureMainThread(() -> {
            Block signBlock = chunk.getBlock(signLoc.getBlockX() & 0xF, signLoc.getBlockY(), signLoc.getBlockZ() & 0xF);
            future.complete(signBlock);
        }));
        return future;
    }

    public void updateSign() {
        this.getSignBlockAsync().thenAccept(signBlock -> {
            signBlock.setType(Material.OAK_WALL_SIGN, false);
            Sign sign = (Sign)signBlock.getState();
            sign.setLine(0, this.plotId.toString());
            sign.setLine(1, JustPlots.getUsername(this.owner));
            sign.setLine(3, this.getCreationDate());
            sign.update();
        });
    }

    public void clearSign() {
        this.getSignBlockAsync().thenAccept(signBlock -> signBlock.setType(Material.AIR, false));
    }

    public void claimWalls() {
        this.setWalls(this.plotWorld.getClaimedWall());
    }

    public void unclaimWalls() {
        this.setWalls(this.plotWorld.getUnclaimedWall());
    }

    private void setWalls(BlockData block) {
        ChunkBatcher chunkBatcher = new ChunkBatcher(this.getWorld());
        Location top = this.getTop();
        Location bottom = this.getBottom();
        int fromx = bottom.getBlockX() - 1;
        int fromz = bottom.getBlockZ() - 1;
        int tox = top.getBlockX() + 1;
        int toz = top.getBlockZ() + 1;
        for (int x = fromx; x <= tox; ++x) {
            chunkBatcher.setBlock(x, this.plotWorld.getFloorHeight() + 1, fromz, block);
            chunkBatcher.setBlock(x, this.plotWorld.getFloorHeight() + 1, toz, block);
        }
        for (int z = fromz; z <= toz; ++z) {
            chunkBatcher.setBlock(fromx, this.plotWorld.getFloorHeight() + 1, z, block);
            chunkBatcher.setBlock(tox, this.plotWorld.getFloorHeight() + 1, z, block);
        }
        chunkBatcher.run();
    }

    public void clear() {
        Location from = this.getBottom();
        Location to = this.getTop();
        ResetManager.reset(this.plotWorld, from.getBlockX(), from.getBlockZ(), to.getBlockX(), to.getBlockZ());
        this.clearEntities();
    }

    private void clearEntities() {
        World world = this.getWorld();
        if (world == null) {
            return;
        }
        AsyncUtil.ensureMainThread(() -> {
            for (Entity entity : world.getEntities()) {
                if (entity instanceof Player || !this.inPlot(entity) && !this.inPlot(PaperUtil.getOrigin(entity))) continue;
                entity.remove();
            }
        });
    }

    public boolean inPlot(Entity entity) {
        return this.inPlot(entity.getLocation());
    }

    public boolean inPlot(Location location) {
        Location top = this.getTop();
        Location bottom = this.getBottom();
        return bottom.getX() <= (double)location.getBlockX() && (double)location.getBlockX() <= top.getX() && bottom.getZ() <= (double)location.getBlockZ() && (double)location.getBlockZ() <= top.getZ();
    }

    public Location getBottom() {
        return new Location(this.getWorld(), Math.ceil((double)((this.plotWorld.getPlotSize() + this.plotWorld.getRoadSize()) * this.x) + (double)this.plotWorld.getRoadSize() / 2.0), (double)WorldHeight.getMinHeight(this.getWorld()), Math.ceil((double)((this.plotWorld.getPlotSize() + this.plotWorld.getRoadSize()) * this.z) + (double)this.plotWorld.getRoadSize() / 2.0));
    }

    public Location getTop() {
        return new Location(this.getWorld(), Math.ceil((double)((this.plotWorld.getPlotSize() + this.plotWorld.getRoadSize()) * this.x) + (double)this.plotWorld.getRoadSize() / 2.0 + (double)this.plotWorld.getPlotSize() - 1.0), (double)WorldHeight.getMaxHeight(this.getWorld()), Math.ceil((double)((this.plotWorld.getPlotSize() + this.plotWorld.getRoadSize()) * this.z) + (double)this.plotWorld.getRoadSize() / 2.0 + (double)this.plotWorld.getPlotSize() - 1.0));
    }

    public Location getMiddle() {
        Location bottom = this.getBottom();
        Location top = this.getTop();
        return new Location(this.getWorld(), (double)bottom.getBlockX() + (double)(top.getBlockX() - bottom.getBlockX()) / 2.0 + 0.5, (double)(this.plotWorld.getFloorHeight() + 1), (double)bottom.getBlockZ() + (double)(top.getBlockZ() - bottom.getBlockZ()) / 2.0 + 0.5);
    }

    public List<Player> getPlayersInPlot() {
        ArrayList<Player> players = new ArrayList<Player>();
        World world = this.getWorld();
        if (world != null) {
            for (Player player : world.getPlayers()) {
                if (!this.inPlot((Entity)player)) continue;
                players.add(player);
            }
        }
        return players;
    }
}

