/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import java.util.Collection;
import java.util.HashMap;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.PlotId;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class PlotWorld {
    private final String world;
    private int plotSize = 0;
    private int roadSize = 7;
    private int floorHeight = 64;
    private BlockData roadOuterBlock = Material.BIRCH_PLANKS.createBlockData();
    private BlockData roadInnerBlock = Material.OAK_PLANKS.createBlockData();
    private BlockData unclaimedWall = Material.QUARTZ_SLAB.createBlockData();
    private BlockData claimedWall = Material.SMOOTH_STONE_SLAB.createBlockData();
    private int autoClaimDistance = 0;
    private final HashMap<PlotId, Plot> plots = new HashMap();

    public PlotWorld(String world) {
        this.world = world;
    }

    public String getWorld() {
        return this.world;
    }

    public Plot getPlot(int x, int z) {
        return this.getPlot(new PlotId(x, z));
    }

    public Plot getPlot(PlotId plotID) {
        return this.plots.get(plotID);
    }

    public void addPlot(Plot plot) {
        this.plots.put(plot.getId(), plot);
    }

    public boolean isPlotWorld() {
        return this.plotSize > 0;
    }

    public int getPlotSize() {
        return this.plotSize;
    }

    public int getRoadSize() {
        return this.roadSize;
    }

    public int getFloorHeight() {
        return this.floorHeight;
    }

    public Collection<Plot> getPlots() {
        return this.plots.values();
    }

    public void removePlot(Plot plot) {
        this.plots.remove(plot.getId());
        int distance = Math.max(Math.abs(plot.getId().getX()), Math.abs(plot.getId().getZ()));
        if (distance < this.autoClaimDistance) {
            this.autoClaimDistance = distance;
        }
    }

    public void setPlotSize(int plotSize) {
        this.plotSize = plotSize;
    }

    public void setRoadSize(int roadSize) {
        this.roadSize = roadSize;
    }

    public void setFloorHeight(int floorHeight) {
        this.floorHeight = floorHeight;
    }

    public BlockData getRoadOuterBlock() {
        return this.roadOuterBlock;
    }

    public void setRoadOuterBlock(BlockData roadOuterBlock) {
        this.roadOuterBlock = roadOuterBlock;
    }

    public BlockData getRoadInnerBlock() {
        return this.roadInnerBlock;
    }

    public void setRoadInnerBlock(BlockData roadInnerBlock) {
        this.roadInnerBlock = roadInnerBlock;
    }

    public BlockData getUnclaimedWall() {
        return this.unclaimedWall;
    }

    public void setUnclaimedWall(BlockData unclaimedWall) {
        this.unclaimedWall = unclaimedWall;
    }

    public BlockData getClaimedWall() {
        return this.claimedWall;
    }

    public void setClaimedWall(BlockData claimedWall) {
        this.claimedWall = claimedWall;
    }

    public PlotId nextAutoClaimPlot() {
        if (!this.isPlotWorld()) {
            return null;
        }
        while (true) {
            int z;
            PlotId id;
            int x;
            for (x = -this.autoClaimDistance; x <= this.autoClaimDistance; ++x) {
                id = new PlotId(x, this.autoClaimDistance);
                if (this.getPlot(id) != null) continue;
                return id;
            }
            for (z = this.autoClaimDistance; z >= -this.autoClaimDistance; --z) {
                id = new PlotId(this.autoClaimDistance, z);
                if (this.getPlot(id) != null) continue;
                return id;
            }
            for (x = this.autoClaimDistance; x >= -this.autoClaimDistance; --x) {
                id = new PlotId(x, -this.autoClaimDistance);
                if (this.getPlot(id) != null) continue;
                return id;
            }
            for (z = -this.autoClaimDistance; z <= this.autoClaimDistance; ++z) {
                id = new PlotId(-this.autoClaimDistance, z);
                if (this.getPlot(id) != null) continue;
                return id;
            }
            ++this.autoClaimDistance;
        }
    }

    public void load(ConfigurationSection config) {
        try {
            this.plotSize = config.getInt("plot_size");
            this.roadSize = config.getInt("road_size");
            this.floorHeight = config.getInt("floor_height");
            this.roadInnerBlock = Bukkit.createBlockData((String)config.getString("road_inner_block"));
            this.roadOuterBlock = Bukkit.createBlockData((String)config.getString("road_outer_block"));
            this.unclaimedWall = Bukkit.createBlockData((String)config.getString("wall_unclaimed"));
            this.claimedWall = Bukkit.createBlockData((String)config.getString("wall_claimed"));
        }
        catch (Exception e) {
            JustPlots.getPlugin().getLogger().severe("FAILED TO LOAD CONFIGURATION FOR WORLD " + this.world);
            e.printStackTrace();
        }
    }

    public void save() {
        ConfigurationSection config;
        FileConfiguration pluginConfig = JustPlots.getPlugin().getConfig();
        ConfigurationSection worlds = pluginConfig.getConfigurationSection("worlds");
        if (worlds == null) {
            worlds = pluginConfig.createSection("worlds");
        }
        if ((config = worlds.getConfigurationSection(this.world)) == null) {
            config = worlds.createSection(this.world);
        }
        config.set("plot_size", (Object)this.plotSize);
        config.set("road_size", (Object)this.roadSize);
        config.set("floor_height", (Object)this.floorHeight);
        config.set("road_inner_block", (Object)this.roadInnerBlock.getAsString());
        config.set("road_outer_block", (Object)this.roadOuterBlock.getAsString());
        config.set("wall_unclaimed", (Object)this.unclaimedWall.getAsString());
        config.set("wall_claimed", (Object)this.claimedWall.getAsString());
        JustPlots.getPlugin().saveConfig();
    }
}

