/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.PlotWorld;
import net.justminecraft.plots.util.WorldHeight;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class PlotWorldGenerator
extends ChunkGenerator {
    private static final double sqrt2 = Math.sqrt(2.0);
    private ArrayList<BlockPopulator> blockPopulators = new ArrayList();

    public PlotWorldGenerator() {
        for (PlotWorld plotWorld : JustPlots.getPlotWorlds()) {
            if (!plotWorld.isPlotWorld() || Bukkit.getWorld((String)plotWorld.getWorld()) != null) continue;
            boolean firstTimeGenerating = !new File(plotWorld.getWorld()).isDirectory();
            World world = Bukkit.createWorld((WorldCreator)new WorldCreator(plotWorld.getWorld()).generator((ChunkGenerator)this));
            if (world == null) {
                JustPlots.getPlugin().getLogger().warning("Failed to load world " + plotWorld.getWorld());
                continue;
            }
            world.setKeepSpawnInMemory(false);
            if (!firstTimeGenerating) continue;
            world.setGameRule(GameRule.DISABLE_RAIDS, (Object)true);
            world.setGameRule(GameRule.DO_FIRE_TICK, (Object)false);
            world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            world.setGameRule(GameRule.DO_PATROL_SPAWNING, (Object)false);
            world.setGameRule(GameRule.MOB_GRIEFING, (Object)false);
            world.setSpawnLocation(0, plotWorld.getFloorHeight() + 1, 0);
        }
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        return this.blockPopulators;
    }

    public void addBlockPopulator(BlockPopulator blockPopulator) {
        this.blockPopulators.add(blockPopulator);
        for (World world : Bukkit.getWorlds()) {
            if (world.getGenerator() != this) continue;
            world.getPopulators().add(blockPopulator);
        }
    }

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int cx, int cz, @NotNull ChunkGenerator.BiomeGrid biomeGrid) {
        PlotWorld plotWorld = JustPlots.getPlotWorld(world);
        if (!plotWorld.isPlotWorld()) {
            throw new IllegalArgumentException("World " + world.getName() + " is not a PlotWorld");
        }
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        this.generateBase(plotWorld, chunkData, world);
        this.generateBiomes(plotWorld, biomeGrid, world);
        this.generateRoad(plotWorld, cx, cz, chunkData);
        return chunkData;
    }

    private void generateBase(PlotWorld plotWorld, ChunkGenerator.ChunkData chunkData, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunkData.setBlock(x, WorldHeight.getMinHeight(world), z, Material.BEDROCK);
                for (int y = WorldHeight.getMinHeight(world) + 1; y < plotWorld.getFloorHeight(); ++y) {
                    chunkData.setBlock(x, y, z, Material.DIRT);
                }
                chunkData.setBlock(x, plotWorld.getFloorHeight(), z, Material.GRASS_BLOCK);
            }
        }
    }

    private void generateBiomes(PlotWorld plotWorld, ChunkGenerator.BiomeGrid biomeGrid, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = WorldHeight.getMinHeight(world); y < WorldHeight.getMaxHeight(world); ++y) {
                    biomeGrid.setBiome(x, y, z, Biome.PLAINS);
                }
            }
        }
    }

    private void generateRoad(PlotWorld plotWorld, int cx, int cz, ChunkGenerator.ChunkData chunkData) {
        int roadSize = (int)Math.ceil((double)plotWorld.getRoadSize() / 2.0) - 1;
        int size = plotWorld.getPlotSize() + plotWorld.getRoadSize();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int x = cx << 4 | i;
                int y = plotWorld.getFloorHeight();
                int z = cz << 4 | j;
                int dx = Math.floorMod(x, size);
                int dz = Math.floorMod(z, size);
                if (dx > size / 2) {
                    dx = size - dx;
                    if (plotWorld.getRoadSize() % 2 == 0) {
                        --dx;
                    }
                }
                if (dz > size / 2) {
                    dz = size - dz;
                    if (plotWorld.getRoadSize() % 2 == 0) {
                        --dz;
                    }
                }
                if (dx == roadSize && dz >= roadSize || dz == roadSize && dx >= roadSize) {
                    chunkData.setBlock(i, y + 1, j, plotWorld.getUnclaimedWall());
                }
                int block = -1;
                if (dx <= roadSize && dz <= roadSize) {
                    double distance = Math.sqrt(dx * dx + dz * dz) / sqrt2;
                    block = (int)Math.floor(distance) % 2;
                } else if (dx < roadSize - 1 || dz < roadSize - 1) {
                    block = 0;
                } else if (dx < roadSize || dz < roadSize) {
                    block = 1;
                }
                if (block == 0) {
                    chunkData.setBlock(i, y, j, plotWorld.getRoadInnerBlock());
                    continue;
                }
                if (block != 1) continue;
                chunkData.setBlock(i, y, j, plotWorld.getRoadOuterBlock());
            }
        }
    }
}

