/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.commands.AddCommand;
import net.justminecraft.plots.commands.AutoCommand;
import net.justminecraft.plots.commands.ClaimCommand;
import net.justminecraft.plots.commands.ClearCommand;
import net.justminecraft.plots.commands.DisposeCommand;
import net.justminecraft.plots.commands.HelpCommand;
import net.justminecraft.plots.commands.InfoCommand;
import net.justminecraft.plots.commands.ListCommand;
import net.justminecraft.plots.commands.MiddleCommand;
import net.justminecraft.plots.commands.PluginInfoCommand;
import net.justminecraft.plots.commands.RemoveCommand;
import net.justminecraft.plots.commands.ResetCommand;
import net.justminecraft.plots.commands.SubCommand;
import net.justminecraft.plots.commands.VisitCommand;
import net.justminecraft.plots.commands.WeanywhereCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JustPlotsCommand
implements CommandExecutor,
TabCompleter {
    private final JustPlots plots;
    private HashMap<String, SubCommand> commands = new HashMap();
    private HelpCommand helpCommand = new HelpCommand();
    private boolean addCustomCommands;

    public JustPlotsCommand(JustPlots plots) {
        this.plots = plots;
        PluginCommand justPlots = plots.getCommand("p");
        if (justPlots == null) {
            throw new RuntimeException("Could not find command /justplots (is it registered in the plugin.yml?)");
        }
        justPlots.setExecutor((CommandExecutor)this);
        justPlots.setTabCompleter((TabCompleter)this);
        this.addCommand(new InfoCommand());
        this.addCommand(new ListCommand());
        this.addCommand(new ClaimCommand());
        this.addCommand(new AutoCommand());
        this.addCommand(new VisitCommand());
        this.addCommand(new AddCommand());
        this.addCommand(new RemoveCommand());
        this.addCommand(new ClearCommand());
        this.addCommand(new ResetCommand());
        this.addCommand(new DisposeCommand());
        this.addCommand(new MiddleCommand());
        this.addCommand(new WeanywhereCommand());
        this.addCommand(new PluginInfoCommand());
        this.addCommand(this.helpCommand);
        this.addCustomCommands = true;
    }

    public void addCommand(@NotNull SubCommand command) {
        command.setCustomCommand(this.addCustomCommands);
        for (String alias : command.getAliases()) {
            this.commands.put(alias, command);
        }
        this.helpCommand.addCommand(command);
    }

    @Nullable
    public SubCommand getCommand(@NotNull String alias) {
        return this.commands.get(alias);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        SubCommand subCommand;
        if (args.length >= 1 && (subCommand = this.getCommand(args[0].toLowerCase())) != null) {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plots, () -> {
                try {
                    subCommand.onCommand(sender, args[0], newArgs);
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "Unhandled expection: " + e.getClass().getSimpleName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            });
            return true;
        }
        return this.helpCommand.onCommand(sender, "", args);
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> tabCompletion = new ArrayList<String>();
        if (args.length >= 2) {
            SubCommand subCommand2 = this.commands.get(args[0].toLowerCase());
            if (subCommand2 != null) {
                String[] newArgs = new String[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
                subCommand2.onTabComplete(sender, newArgs, tabCompletion);
            }
        } else if (args.length == 1) {
            this.commands.forEach((key, subCommand) -> {
                if ((subCommand.getPermission() == null || sender.hasPermission(subCommand.getPermission())) && key.startsWith(args[0].toLowerCase())) {
                    tabCompletion.add((String)key);
                }
            });
        }
        return tabCompletion;
    }
}

