/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class Database {
    private Connection connection = null;

    public abstract Connection openConnection() throws SQLException;

    private void checkConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.openConnection();
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkConnection();
        return this.connection.prepareStatement(sql);
    }

    public void createTables() {
        try {
            this.checkConnection();
            try (Statement statement = this.connection.createStatement();){
                statement.addBatch("CREATE TABLE IF NOT EXISTS justplots_plots (world VARCHAR(45) NOT NULL,x INT NOT NULL,z INT NOT NULL,owner CHAR(36) NOT NULL,creation timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (world, x, z))");
                statement.addBatch("CREATE TABLE IF NOT EXISTS justplots_added (world VARCHAR(45) NOT NULL,x INT NOT NULL,z INT NOT NULL,uuid CHAR(36) NOT NULL,UNIQUE (world, x, z, uuid))");
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

