/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.database;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.justminecraft.plots.database.Database;

public class SQLiteDatabase
extends Database {
    private File dbFile;

    public SQLiteDatabase(File dbFile) {
        this.dbFile = dbFile;
    }

    @Override
    public Connection openConnection() throws SQLException {
        if (!this.dbFile.exists()) {
            try {
                if (!this.dbFile.getParentFile().isDirectory() && !this.dbFile.getParentFile().mkdirs()) {
                    throw new IOException("Could not create database file's parent directory");
                }
                if (!this.dbFile.createNewFile()) {
                    throw new IOException("Could not create database file");
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        return DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
    }
}

