/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.listeners;

import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.events.PlotEnterEvent;
import net.justminecraft.plots.events.PlotExitEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    public PlayerListener(JustPlots plots) {
        plots.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plots);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        Plot to;
        if (!this.hasMovedBlock(e.getFrom(), e.getTo())) {
            return;
        }
        Plot from = JustPlots.getPlotAt(e.getFrom());
        if (from != (to = JustPlots.getPlotAt(e.getTo()))) {
            if (from != null) {
                PlotExitEvent exitEvent = new PlotExitEvent(from, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)exitEvent);
                if (exitEvent.isCancelled()) {
                    e.setCancelled(true);
                    return;
                }
            }
            if (to != null) {
                PlotEnterEvent enterEvent = new PlotEnterEvent(to, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)enterEvent);
                if (enterEvent.isCancelled()) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent e) {
        Plot to;
        if (!this.hasMovedBlock(e.getFrom(), e.getTo())) {
            return;
        }
        Plot from = JustPlots.getPlotAt(e.getFrom());
        if (from != (to = JustPlots.getPlotAt(e.getTo()))) {
            if (from != null) {
                PlotExitEvent exitEvent = new PlotExitEvent(from, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)exitEvent);
                if (exitEvent.isCancelled()) {
                    e.setCancelled(true);
                    return;
                }
            }
            if (to != null) {
                PlotEnterEvent enterEvent = new PlotEnterEvent(to, e.getPlayer());
                Bukkit.getServer().getPluginManager().callEvent((Event)enterEvent);
                if (enterEvent.isCancelled()) {
                    e.setTo(to.getHome());
                }
            }
        }
    }

    private boolean hasMovedBlock(Location from, Location to) {
        return from.getBlockX() != to.getBlockX() || from.getBlockZ() != to.getBlockZ();
    }
}

