/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.voxelsniper;

import java.util.Collection;
import java.util.List;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.voxelsniper.JLocation;
import net.justminecraft.plots.voxelsniper.JWorld;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class JBlock
implements Block {
    private final JWorld world;
    private final Block block;

    public JBlock(JWorld world, Block block) {
        this.world = world;
        this.block = block;
    }

    public boolean canModifiy() {
        Plot plot;
        return !JustPlots.isPlotWorld((World)this.block.getWorld()) || (plot = JustPlots.getPlotAt((Location)this.block.getLocation())) != null && plot.isAdded((OfflinePlayer)this.world.getPlayer());
    }

    public byte getData() {
        if (this.canModifiy()) {
            return this.block.getData();
        }
        return 0;
    }

    public BlockData getBlockData() {
        if (this.canModifiy()) {
            return this.block.getBlockData();
        }
        return Material.AIR.createBlockData();
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return new JBlock(this.world, this.block.getRelative(modX, modY, modY));
    }

    public Block getRelative(BlockFace face) {
        return new JBlock(this.world, this.block.getRelative(face));
    }

    public Block getRelative(BlockFace face, int distance) {
        throw new UnsupportedOperationException();
    }

    public Material getType() {
        if (this.canModifiy()) {
            return this.block.getType();
        }
        return Material.AIR;
    }

    public byte getLightLevel() {
        throw new UnsupportedOperationException();
    }

    public byte getLightFromSky() {
        throw new UnsupportedOperationException();
    }

    public byte getLightFromBlocks() {
        throw new UnsupportedOperationException();
    }

    public JWorld getWorld() {
        return this.world;
    }

    public int getX() {
        return this.block.getX();
    }

    public int getY() {
        return this.block.getY();
    }

    public int getZ() {
        return this.block.getZ();
    }

    public Location getLocation() {
        return new JLocation(this.getWorld(), this.block.getLocation());
    }

    public Location getLocation(Location loc) {
        throw new UnsupportedOperationException();
    }

    public Chunk getChunk() {
        return this.world.getChunkAt(this);
    }

    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        if (this.canModifiy()) {
            this.block.setBlockData(data, applyPhysics);
        }
    }

    public void setType(Material type) {
        this.setType(type, true);
    }

    public void setType(Material type, boolean applyPhysics) {
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    public BlockFace getFace(Block block) {
        if (block instanceof JBlock) {
            block = ((JBlock)block).block;
        }
        return this.block.getFace(block);
    }

    public BlockState getState() {
        return this.block.getState();
    }

    public Biome getBiome() {
        throw new UnsupportedOperationException();
    }

    public void setBiome(Biome bio) {
        throw new UnsupportedOperationException();
    }

    public boolean isBlockPowered() {
        if (this.canModifiy()) {
            return this.block.isBlockPowered();
        }
        return false;
    }

    public boolean isBlockIndirectlyPowered() {
        if (this.canModifiy()) {
            return this.block.isBlockIndirectlyPowered();
        }
        return false;
    }

    public boolean isBlockFacePowered(BlockFace face) {
        if (this.canModifiy()) {
            return this.block.isBlockFacePowered(face);
        }
        return false;
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        if (this.canModifiy()) {
            return this.block.isBlockFaceIndirectlyPowered(face);
        }
        return false;
    }

    public int getBlockPower(BlockFace face) {
        if (this.canModifiy()) {
            return this.block.getBlockPower(face);
        }
        return 0;
    }

    public int getBlockPower() {
        if (this.canModifiy()) {
            return this.block.getBlockPower();
        }
        return 0;
    }

    public boolean isEmpty() {
        if (this.canModifiy()) {
            return this.block.isEmpty();
        }
        return true;
    }

    public boolean isLiquid() {
        if (this.canModifiy()) {
            return this.block.isLiquid();
        }
        return false;
    }

    public double getTemperature() {
        throw new UnsupportedOperationException();
    }

    public double getHumidity() {
        throw new UnsupportedOperationException();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnsupportedOperationException();
    }

    public boolean breakNaturally() {
        throw new UnsupportedOperationException();
    }

    public boolean breakNaturally(ItemStack tool) {
        throw new UnsupportedOperationException();
    }

    public Collection<ItemStack> getDrops() {
        throw new UnsupportedOperationException();
    }

    public Collection<ItemStack> getDrops(ItemStack tool) {
        throw new UnsupportedOperationException();
    }

    public Collection<ItemStack> getDrops(ItemStack tool, Entity entity) {
        throw new UnsupportedOperationException();
    }

    public boolean isPassable() {
        throw new UnsupportedOperationException();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        throw new UnsupportedOperationException();
    }

    public BoundingBox getBoundingBox() {
        throw new UnsupportedOperationException();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        throw new UnsupportedOperationException();
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        throw new UnsupportedOperationException();
    }

    public boolean hasMetadata(String metadataKey) {
        throw new UnsupportedOperationException();
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        throw new UnsupportedOperationException();
    }
}

