/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.voxelsniper;

import com.thevoxelbox.voxelsniper.VoxelProfileManager;
import com.thevoxelbox.voxelsniper.VoxelSniper;
import com.thevoxelbox.voxelsniper.event.SniperBrushSizeChangedEvent;
import com.thevoxelbox.voxelsniper.snipe.SnipeData;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.justminecraft.plots.bstats.bukkit.Metrics;
import net.justminecraft.plots.voxelsniper.JBlock;
import net.justminecraft.plots.voxelsniper.JPlayer;
import net.justminecraft.plots.voxelsniper.JSniper;
import net.justminecraft.plots.voxelsniper.JVoxelProfileManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class JustPlotsVoxelSniper
extends JavaPlugin
implements Listener {
    private static HashMap<Player, JPlayer> playerCache = new HashMap();
    public static int MAX_BRUSH_SIZE = 25;

    public static JPlayer getJPlayer(Player player) {
        return playerCache.computeIfAbsent(player, JPlayer::new);
    }

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        MAX_BRUSH_SIZE = this.getConfig().getInt("max-brush-size");
        this.injectVoxelProfileManager();
        PlayerInteractEvent.getHandlerList().unregister((Plugin)VoxelSniper.getInstance());
        new Metrics((JavaPlugin)this, 10956);
    }

    private void injectVoxelProfileManager() {
        try {
            Field instance = VoxelProfileManager.class.getDeclaredField("instance");
            instance.setAccessible(true);
            instance.set(null, (Object)new JVoxelProfileManager());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        playerCache.remove(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("voxelsniper.sniper")) {
            return;
        }
        try {
            JBlock clickedBlock;
            JSniper sniper = (JSniper)VoxelProfileManager.getInstance().getSniperForPlayer(player);
            JBlock jBlock = clickedBlock = event.getClickedBlock() == null ? null : new JBlock(sniper.getPlayer().getWorld(), event.getClickedBlock());
            if (sniper.isEnabled() && sniper.snipe(event.getAction(), event.getMaterial(), clickedBlock, event.getBlockFace())) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onSniperBrushSizeChange(SniperBrushSizeChangedEvent event) {
        if (event.getNewSize() > MAX_BRUSH_SIZE && MAX_BRUSH_SIZE > 0) {
            event.getSniper().getPlayer().sendMessage(ChatColor.RED + "[JustPlots-VoxelSniper] The maximum brush size is " + MAX_BRUSH_SIZE);
            String currentToolId = event.getSniper().getCurrentToolId();
            SnipeData snipeData = event.getSniper().getSnipeData(currentToolId);
            snipeData.setBrushSize(MAX_BRUSH_SIZE);
        }
    }
}

