/*
 * Decompiled with CFR 0.152.
 */
package clisk;

import clisk.Util;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.io.StringReader;

public class Generator {
    private static final String NAMESPACE = "clisk.demo";
    private static IFn imageGenerator = (IFn)Compiler.load((Reader)new StringReader("(use 'clisk.demo) clisk.core/img"));

    public static BufferedImage generate(String script) {
        return Generator.generate(script, 256, 256);
    }

    public static BufferedImage generate(String script, int width, int height) {
        Object result = Util.execute(script = "(in-ns 'clisk.demo) " + script);
        if (result instanceof BufferedImage) {
            return (BufferedImage)result;
        }
        return (BufferedImage)imageGenerator.invoke(result, (Object)width, (Object)height);
    }

    public static void main(String[] args) {
        Util.show(Generator.generate("vplasma"));
        Util.execute("(shutdown-agents)");
    }
}

