/*
 * Decompiled with CFR 0.152.
 */
package clisk;

public final class Perlin {
    private static final double[] G1 = new double[]{-1.0, 1.0};
    private static final double[][] G2 = new double[][]{{1.0, 0.0}, {-1.0, 0.0}, {0.0, 1.0}, {0.0, -1.0}};
    private static final double[][] G3 = new double[][]{{1.0, 1.0, 0.0}, {-1.0, 1.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, -1.0, 0.0}, {1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {1.0, 0.0, -1.0}, {-1.0, 0.0, -1.0}, {0.0, 1.0, 1.0}, {0.0, -1.0, 1.0}, {0.0, 1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, 1.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}, {0.0, -1.0, -1.0}};
    private static final double[][] G4 = new double[][]{{-1.0, -1.0, -1.0, 0.0}, {-1.0, -1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0, 0.0}, {-1.0, 1.0, 1.0, 0.0}, {1.0, -1.0, -1.0, 0.0}, {1.0, -1.0, 1.0, 0.0}, {1.0, 1.0, -1.0, 0.0}, {1.0, 1.0, 1.0, 0.0}, {-1.0, -1.0, 0.0, -1.0}, {-1.0, 1.0, 0.0, -1.0}, {1.0, -1.0, 0.0, -1.0}, {1.0, 1.0, 0.0, -1.0}, {-1.0, -1.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 1.0}, {1.0, -1.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 1.0}, {-1.0, 0.0, -1.0, -1.0}, {1.0, 0.0, -1.0, -1.0}, {-1.0, 0.0, -1.0, 1.0}, {1.0, 0.0, -1.0, 1.0}, {-1.0, 0.0, 1.0, -1.0}, {1.0, 0.0, 1.0, -1.0}, {-1.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 1.0}, {0.0, -1.0, -1.0, -1.0}, {0.0, -1.0, -1.0, 1.0}, {0.0, -1.0, 1.0, -1.0}, {0.0, -1.0, 1.0, 1.0}, {0.0, 1.0, -1.0, -1.0}, {0.0, 1.0, -1.0, 1.0}, {0.0, 1.0, 1.0, -1.0}, {0.0, 1.0, 1.0, 1.0}};
    private static final int[] p;

    static {
        int[] nArray = new int[512];
        nArray[0] = 151;
        nArray[1] = 160;
        nArray[2] = 137;
        nArray[3] = 91;
        nArray[4] = 90;
        nArray[5] = 15;
        nArray[6] = 131;
        nArray[7] = 13;
        nArray[8] = 201;
        nArray[9] = 95;
        nArray[10] = 96;
        nArray[11] = 53;
        nArray[12] = 194;
        nArray[13] = 233;
        nArray[14] = 7;
        nArray[15] = 225;
        nArray[16] = 140;
        nArray[17] = 36;
        nArray[18] = 103;
        nArray[19] = 30;
        nArray[20] = 69;
        nArray[21] = 142;
        nArray[22] = 8;
        nArray[23] = 99;
        nArray[24] = 37;
        nArray[25] = 240;
        nArray[26] = 21;
        nArray[27] = 10;
        nArray[28] = 23;
        nArray[29] = 190;
        nArray[30] = 6;
        nArray[31] = 148;
        nArray[32] = 247;
        nArray[33] = 120;
        nArray[34] = 234;
        nArray[35] = 75;
        nArray[37] = 26;
        nArray[38] = 197;
        nArray[39] = 62;
        nArray[40] = 94;
        nArray[41] = 252;
        nArray[42] = 219;
        nArray[43] = 203;
        nArray[44] = 117;
        nArray[45] = 35;
        nArray[46] = 11;
        nArray[47] = 32;
        nArray[48] = 57;
        nArray[49] = 177;
        nArray[50] = 33;
        nArray[51] = 88;
        nArray[52] = 237;
        nArray[53] = 149;
        nArray[54] = 56;
        nArray[55] = 87;
        nArray[56] = 174;
        nArray[57] = 20;
        nArray[58] = 125;
        nArray[59] = 136;
        nArray[60] = 171;
        nArray[61] = 168;
        nArray[62] = 68;
        nArray[63] = 175;
        nArray[64] = 74;
        nArray[65] = 165;
        nArray[66] = 71;
        nArray[67] = 134;
        nArray[68] = 139;
        nArray[69] = 48;
        nArray[70] = 27;
        nArray[71] = 166;
        nArray[72] = 77;
        nArray[73] = 146;
        nArray[74] = 158;
        nArray[75] = 231;
        nArray[76] = 83;
        nArray[77] = 111;
        nArray[78] = 229;
        nArray[79] = 122;
        nArray[80] = 60;
        nArray[81] = 211;
        nArray[82] = 133;
        nArray[83] = 230;
        nArray[84] = 220;
        nArray[85] = 105;
        nArray[86] = 92;
        nArray[87] = 41;
        nArray[88] = 55;
        nArray[89] = 46;
        nArray[90] = 245;
        nArray[91] = 40;
        nArray[92] = 244;
        nArray[93] = 102;
        nArray[94] = 143;
        nArray[95] = 54;
        nArray[96] = 65;
        nArray[97] = 25;
        nArray[98] = 63;
        nArray[99] = 161;
        nArray[100] = 1;
        nArray[101] = 216;
        nArray[102] = 80;
        nArray[103] = 73;
        nArray[104] = 209;
        nArray[105] = 76;
        nArray[106] = 132;
        nArray[107] = 187;
        nArray[108] = 208;
        nArray[109] = 89;
        nArray[110] = 18;
        nArray[111] = 169;
        nArray[112] = 200;
        nArray[113] = 196;
        nArray[114] = 135;
        nArray[115] = 130;
        nArray[116] = 116;
        nArray[117] = 188;
        nArray[118] = 159;
        nArray[119] = 86;
        nArray[120] = 164;
        nArray[121] = 100;
        nArray[122] = 109;
        nArray[123] = 198;
        nArray[124] = 173;
        nArray[125] = 186;
        nArray[126] = 3;
        nArray[127] = 64;
        nArray[128] = 52;
        nArray[129] = 217;
        nArray[130] = 226;
        nArray[131] = 250;
        nArray[132] = 124;
        nArray[133] = 123;
        nArray[134] = 5;
        nArray[135] = 202;
        nArray[136] = 38;
        nArray[137] = 147;
        nArray[138] = 118;
        nArray[139] = 126;
        nArray[140] = 255;
        nArray[141] = 82;
        nArray[142] = 85;
        nArray[143] = 212;
        nArray[144] = 207;
        nArray[145] = 206;
        nArray[146] = 59;
        nArray[147] = 227;
        nArray[148] = 47;
        nArray[149] = 16;
        nArray[150] = 58;
        nArray[151] = 17;
        nArray[152] = 182;
        nArray[153] = 189;
        nArray[154] = 28;
        nArray[155] = 42;
        nArray[156] = 223;
        nArray[157] = 183;
        nArray[158] = 170;
        nArray[159] = 213;
        nArray[160] = 119;
        nArray[161] = 248;
        nArray[162] = 152;
        nArray[163] = 2;
        nArray[164] = 44;
        nArray[165] = 154;
        nArray[166] = 163;
        nArray[167] = 70;
        nArray[168] = 221;
        nArray[169] = 153;
        nArray[170] = 101;
        nArray[171] = 155;
        nArray[172] = 167;
        nArray[173] = 43;
        nArray[174] = 172;
        nArray[175] = 9;
        nArray[176] = 129;
        nArray[177] = 22;
        nArray[178] = 39;
        nArray[179] = 253;
        nArray[180] = 19;
        nArray[181] = 98;
        nArray[182] = 108;
        nArray[183] = 110;
        nArray[184] = 79;
        nArray[185] = 113;
        nArray[186] = 224;
        nArray[187] = 232;
        nArray[188] = 178;
        nArray[189] = 185;
        nArray[190] = 112;
        nArray[191] = 104;
        nArray[192] = 218;
        nArray[193] = 246;
        nArray[194] = 97;
        nArray[195] = 228;
        nArray[196] = 251;
        nArray[197] = 34;
        nArray[198] = 242;
        nArray[199] = 193;
        nArray[200] = 238;
        nArray[201] = 210;
        nArray[202] = 144;
        nArray[203] = 12;
        nArray[204] = 191;
        nArray[205] = 179;
        nArray[206] = 162;
        nArray[207] = 241;
        nArray[208] = 81;
        nArray[209] = 51;
        nArray[210] = 145;
        nArray[211] = 235;
        nArray[212] = 249;
        nArray[213] = 14;
        nArray[214] = 239;
        nArray[215] = 107;
        nArray[216] = 49;
        nArray[217] = 192;
        nArray[218] = 214;
        nArray[219] = 31;
        nArray[220] = 181;
        nArray[221] = 199;
        nArray[222] = 106;
        nArray[223] = 157;
        nArray[224] = 184;
        nArray[225] = 84;
        nArray[226] = 204;
        nArray[227] = 176;
        nArray[228] = 115;
        nArray[229] = 121;
        nArray[230] = 50;
        nArray[231] = 45;
        nArray[232] = 127;
        nArray[233] = 4;
        nArray[234] = 150;
        nArray[235] = 254;
        nArray[236] = 138;
        nArray[237] = 236;
        nArray[238] = 205;
        nArray[239] = 93;
        nArray[240] = 222;
        nArray[241] = 114;
        nArray[242] = 67;
        nArray[243] = 29;
        nArray[244] = 24;
        nArray[245] = 72;
        nArray[246] = 243;
        nArray[247] = 141;
        nArray[248] = 128;
        nArray[249] = 195;
        nArray[250] = 78;
        nArray[251] = 66;
        nArray[252] = 215;
        nArray[253] = 61;
        nArray[254] = 156;
        nArray[255] = 180;
        nArray[256] = 151;
        nArray[257] = 160;
        nArray[258] = 137;
        nArray[259] = 91;
        nArray[260] = 90;
        nArray[261] = 15;
        nArray[262] = 131;
        nArray[263] = 13;
        nArray[264] = 201;
        nArray[265] = 95;
        nArray[266] = 96;
        nArray[267] = 53;
        nArray[268] = 194;
        nArray[269] = 233;
        nArray[270] = 7;
        nArray[271] = 225;
        nArray[272] = 140;
        nArray[273] = 36;
        nArray[274] = 103;
        nArray[275] = 30;
        nArray[276] = 69;
        nArray[277] = 142;
        nArray[278] = 8;
        nArray[279] = 99;
        nArray[280] = 37;
        nArray[281] = 240;
        nArray[282] = 21;
        nArray[283] = 10;
        nArray[284] = 23;
        nArray[285] = 190;
        nArray[286] = 6;
        nArray[287] = 148;
        nArray[288] = 247;
        nArray[289] = 120;
        nArray[290] = 234;
        nArray[291] = 75;
        nArray[293] = 26;
        nArray[294] = 197;
        nArray[295] = 62;
        nArray[296] = 94;
        nArray[297] = 252;
        nArray[298] = 219;
        nArray[299] = 203;
        nArray[300] = 117;
        nArray[301] = 35;
        nArray[302] = 11;
        nArray[303] = 32;
        nArray[304] = 57;
        nArray[305] = 177;
        nArray[306] = 33;
        nArray[307] = 88;
        nArray[308] = 237;
        nArray[309] = 149;
        nArray[310] = 56;
        nArray[311] = 87;
        nArray[312] = 174;
        nArray[313] = 20;
        nArray[314] = 125;
        nArray[315] = 136;
        nArray[316] = 171;
        nArray[317] = 168;
        nArray[318] = 68;
        nArray[319] = 175;
        nArray[320] = 74;
        nArray[321] = 165;
        nArray[322] = 71;
        nArray[323] = 134;
        nArray[324] = 139;
        nArray[325] = 48;
        nArray[326] = 27;
        nArray[327] = 166;
        nArray[328] = 77;
        nArray[329] = 146;
        nArray[330] = 158;
        nArray[331] = 231;
        nArray[332] = 83;
        nArray[333] = 111;
        nArray[334] = 229;
        nArray[335] = 122;
        nArray[336] = 60;
        nArray[337] = 211;
        nArray[338] = 133;
        nArray[339] = 230;
        nArray[340] = 220;
        nArray[341] = 105;
        nArray[342] = 92;
        nArray[343] = 41;
        nArray[344] = 55;
        nArray[345] = 46;
        nArray[346] = 245;
        nArray[347] = 40;
        nArray[348] = 244;
        nArray[349] = 102;
        nArray[350] = 143;
        nArray[351] = 54;
        nArray[352] = 65;
        nArray[353] = 25;
        nArray[354] = 63;
        nArray[355] = 161;
        nArray[356] = 1;
        nArray[357] = 216;
        nArray[358] = 80;
        nArray[359] = 73;
        nArray[360] = 209;
        nArray[361] = 76;
        nArray[362] = 132;
        nArray[363] = 187;
        nArray[364] = 208;
        nArray[365] = 89;
        nArray[366] = 18;
        nArray[367] = 169;
        nArray[368] = 200;
        nArray[369] = 196;
        nArray[370] = 135;
        nArray[371] = 130;
        nArray[372] = 116;
        nArray[373] = 188;
        nArray[374] = 159;
        nArray[375] = 86;
        nArray[376] = 164;
        nArray[377] = 100;
        nArray[378] = 109;
        nArray[379] = 198;
        nArray[380] = 173;
        nArray[381] = 186;
        nArray[382] = 3;
        nArray[383] = 64;
        nArray[384] = 52;
        nArray[385] = 217;
        nArray[386] = 226;
        nArray[387] = 250;
        nArray[388] = 124;
        nArray[389] = 123;
        nArray[390] = 5;
        nArray[391] = 202;
        nArray[392] = 38;
        nArray[393] = 147;
        nArray[394] = 118;
        nArray[395] = 126;
        nArray[396] = 255;
        nArray[397] = 82;
        nArray[398] = 85;
        nArray[399] = 212;
        nArray[400] = 207;
        nArray[401] = 206;
        nArray[402] = 59;
        nArray[403] = 227;
        nArray[404] = 47;
        nArray[405] = 16;
        nArray[406] = 58;
        nArray[407] = 17;
        nArray[408] = 182;
        nArray[409] = 189;
        nArray[410] = 28;
        nArray[411] = 42;
        nArray[412] = 223;
        nArray[413] = 183;
        nArray[414] = 170;
        nArray[415] = 213;
        nArray[416] = 119;
        nArray[417] = 248;
        nArray[418] = 152;
        nArray[419] = 2;
        nArray[420] = 44;
        nArray[421] = 154;
        nArray[422] = 163;
        nArray[423] = 70;
        nArray[424] = 221;
        nArray[425] = 153;
        nArray[426] = 101;
        nArray[427] = 155;
        nArray[428] = 167;
        nArray[429] = 43;
        nArray[430] = 172;
        nArray[431] = 9;
        nArray[432] = 129;
        nArray[433] = 22;
        nArray[434] = 39;
        nArray[435] = 253;
        nArray[436] = 19;
        nArray[437] = 98;
        nArray[438] = 108;
        nArray[439] = 110;
        nArray[440] = 79;
        nArray[441] = 113;
        nArray[442] = 224;
        nArray[443] = 232;
        nArray[444] = 178;
        nArray[445] = 185;
        nArray[446] = 112;
        nArray[447] = 104;
        nArray[448] = 218;
        nArray[449] = 246;
        nArray[450] = 97;
        nArray[451] = 228;
        nArray[452] = 251;
        nArray[453] = 34;
        nArray[454] = 242;
        nArray[455] = 193;
        nArray[456] = 238;
        nArray[457] = 210;
        nArray[458] = 144;
        nArray[459] = 12;
        nArray[460] = 191;
        nArray[461] = 179;
        nArray[462] = 162;
        nArray[463] = 241;
        nArray[464] = 81;
        nArray[465] = 51;
        nArray[466] = 145;
        nArray[467] = 235;
        nArray[468] = 249;
        nArray[469] = 14;
        nArray[470] = 239;
        nArray[471] = 107;
        nArray[472] = 49;
        nArray[473] = 192;
        nArray[474] = 214;
        nArray[475] = 31;
        nArray[476] = 181;
        nArray[477] = 199;
        nArray[478] = 106;
        nArray[479] = 157;
        nArray[480] = 184;
        nArray[481] = 84;
        nArray[482] = 204;
        nArray[483] = 176;
        nArray[484] = 115;
        nArray[485] = 121;
        nArray[486] = 50;
        nArray[487] = 45;
        nArray[488] = 127;
        nArray[489] = 4;
        nArray[490] = 150;
        nArray[491] = 254;
        nArray[492] = 138;
        nArray[493] = 236;
        nArray[494] = 205;
        nArray[495] = 93;
        nArray[496] = 222;
        nArray[497] = 114;
        nArray[498] = 67;
        nArray[499] = 29;
        nArray[500] = 24;
        nArray[501] = 72;
        nArray[502] = 243;
        nArray[503] = 141;
        nArray[504] = 128;
        nArray[505] = 195;
        nArray[506] = 78;
        nArray[507] = 66;
        nArray[508] = 215;
        nArray[509] = 61;
        nArray[510] = 156;
        nArray[511] = 180;
        p = nArray;
    }

    public static final double snoise(double x) {
        int xf = (int)Math.floor(x);
        int X = xf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        int A = p[X];
        int B = p[X + 1];
        return Perlin.lerp(u, Perlin.grad(p[A], x), Perlin.grad(p[B], x - 1.0));
    }

    public static final double snoise(double x, double y) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        int A = p[X] + Y;
        int B = p[X + 1] + Y;
        return Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[A], x, y), Perlin.grad(p[B], x - 1.0, y)), Perlin.lerp(u, Perlin.grad(p[A + 1], x, y - 1.0), Perlin.grad(p[B + 1], x - 1.0, y - 1.0)));
    }

    public static final double snoise(double x, double y, double z) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int zf = (int)Math.floor(z);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        int Z = zf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        double w = Perlin.fade(z -= (double)zf);
        int A = p[X] + Y;
        int AA = p[A] + Z;
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        return Perlin.lerp(w, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AA], x, y, z), Perlin.grad(p[BA], x - 1.0, y, z)), Perlin.lerp(u, Perlin.grad(p[AB], x, y - 1.0, z), Perlin.grad(p[BB], x - 1.0, y - 1.0, z))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AA + 1], x, y, z - 1.0), Perlin.grad(p[BA + 1], x - 1.0, y, z - 1.0)), Perlin.lerp(u, Perlin.grad(p[AB + 1], x, y - 1.0, z - 1.0), Perlin.grad(p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public static final double snoise(double x, double y, double z, double w) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int zf = (int)Math.floor(z);
        int wf = (int)Math.floor(w);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        int Z = zf & 0xFF;
        int W = wf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        double t = Perlin.fade(z -= (double)zf);
        double s = Perlin.fade(w -= (double)wf);
        int A = p[X] + Y;
        int AA = p[A] + Z;
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        int AAA = p[AA] + W;
        int AAB = p[AA + 1] + W;
        int ABA = p[AB] + W;
        int ABB = p[AB + 1] + W;
        int BAA = p[BA] + W;
        int BAB = p[BA + 1] + W;
        int BBA = p[BB] + W;
        int BBB = p[BB + 1] + W;
        return Perlin.lerp(s, Perlin.lerp(t, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAA], x, y, z, w), Perlin.grad(p[BAA], x - 1.0, y, z, w)), Perlin.lerp(u, Perlin.grad(p[ABA], x, y - 1.0, z, w), Perlin.grad(p[BBA], x - 1.0, y - 1.0, z, w))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAB], x, y, z - 1.0, w), Perlin.grad(p[BAB], x - 1.0, y, z - 1.0, w)), Perlin.lerp(u, Perlin.grad(p[ABB], x, y - 1.0, z - 1.0, w), Perlin.grad(p[BBB], x - 1.0, y - 1.0, z - 1.0, w)))), Perlin.lerp(t, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAA + 1], x, y, z, w - 1.0), Perlin.grad(p[BAA + 1], x - 1.0, y, z, w - 1.0)), Perlin.lerp(u, Perlin.grad(p[ABA + 1], x, y - 1.0, z, w - 1.0), Perlin.grad(p[BBA + 1], x - 1.0, y - 1.0, z, w - 1.0))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAB + 1], x, y, z - 1.0, w - 1.0), Perlin.grad(p[BAB + 1], x - 1.0, y, z - 1.0, w - 1.0)), Perlin.lerp(u, Perlin.grad(p[ABB + 1], x, y - 1.0, z - 1.0, w - 1.0), Perlin.grad(p[BBB + 1], x - 1.0, y - 1.0, z - 1.0, w - 1.0)))));
    }

    public static final double noise(double x) {
        return 0.5 + 0.5 * Perlin.snoise(x);
    }

    public static final double noise(double x, double y) {
        return 0.5 + 0.5 * Perlin.snoise(x, y);
    }

    public static final double noise(double x, double y, double z) {
        return 0.5 + 0.5 * Perlin.snoise(x, y, z);
    }

    public static final double noise(double x, double y, double z, double t) {
        return 0.5 + 0.5 * Perlin.snoise(x, y, z, t);
    }

    public static final double pnoise(double xi, double period) {
        double x = xi % period + (xi < 0.0 ? period : 0.0);
        return ((period - x) * Perlin.noise(x) + x * Perlin.noise(x - period)) / period;
    }

    public static final double pnoise(double xi, double yi, double w, double h) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double x_w = x - w;
        double y_h = y - h;
        return (Perlin.noise(x, y) * w_x * h_y + Perlin.noise(x_w, y) * x * h_y + Perlin.noise(x_w, y_h) * x * y + Perlin.noise(x, y_h) * w_x * y) / (w * h);
    }

    public static final double pnoise(double xi, double yi, double zi, double w, double h, double d) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double xy = x * y;
        double h_yXd_z = h_y * d_z;
        double h_yXz = h_y * z;
        double w_xXy = w_x * y;
        return (Perlin.noise(x, y, z) * w_x * h_yXd_z + Perlin.noise(x, y_h, z) * w_xXy * d_z + Perlin.noise(x_w, y, z) * x * h_yXd_z + Perlin.noise(x_w, y_h, z) * xy * d_z + Perlin.noise(x_w, y_h, z_d) * xy * z + Perlin.noise(x, y, z_d) * w_x * h_yXz + Perlin.noise(x, y_h, z_d) * w_xXy * z + Perlin.noise(x_w, y, z_d) * x * h_yXz) / (w * h * d);
    }

    public static final double pnoise(double xi, double yi, double zi, double ti, double w, double h, double d, double p) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double t = ti % p + (ti < 0.0 ? p : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double p_t = p - t;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double t_p = t - p;
        double xy = x * y;
        double d_zXp_t = d_z * p_t;
        double zXp_t = z * p_t;
        double zXt = z * t;
        double d_zXt = d_z * t;
        double w_xXy = w_x * y;
        double w_xXh_y = w_x * h_y;
        double xXh_y = x * h_y;
        return (Perlin.noise(x, y, z, t) * w_xXh_y * d_zXp_t + Perlin.noise(x_w, y, z, t) * xXh_y * d_zXp_t + Perlin.noise(x_w, y_h, z, t) * xy * d_zXp_t + Perlin.noise(x, y_h, z, t) * w_xXy * d_zXp_t + Perlin.noise(x_w, y_h, z_d, t) * xy * zXp_t + Perlin.noise(x, y, z_d, t) * w_xXh_y * zXp_t + Perlin.noise(x, y_h, z_d, t) * w_xXy * zXp_t + Perlin.noise(x_w, y, z_d, t) * xXh_y * zXp_t + Perlin.noise(x, y, z, t_p) * w_xXh_y * d_zXt + Perlin.noise(x_w, y, z, t_p) * xXh_y * d_zXt + Perlin.noise(x_w, y_h, z, t_p) * xy * d_zXt + Perlin.noise(x, y_h, z, t_p) * w_xXy * d_zXt + Perlin.noise(x_w, y_h, z_d, t_p) * xy * zXt + Perlin.noise(x, y, z_d, t_p) * w_xXh_y * zXt + Perlin.noise(x, y_h, z_d, t_p) * w_xXy * zXt + Perlin.noise(x_w, y, z_d, t_p) * xXh_y * zXt) / (w * h * d * t);
    }

    public static final double spnoise(double xi, double period) {
        double x = xi % period + (xi < 0.0 ? period : 0.0);
        return ((period - x) * Perlin.snoise(x) + x * Perlin.snoise(x - period)) / period;
    }

    public static final double spnoise(double xi, double yi, double w, double h) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double x_w = x - w;
        double y_h = y - h;
        return (Perlin.snoise(x, y) * w_x * h_y + Perlin.snoise(x_w, y) * x * h_y + Perlin.snoise(x_w, y_h) * x * y + Perlin.snoise(x, y_h) * w_x * y) / (w * h);
    }

    public static final double spnoise(double xi, double yi, double zi, double w, double h, double d) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double xy = x * y;
        double h_yXd_z = h_y * d_z;
        double h_yXz = h_y * z;
        double w_xXy = w_x * y;
        return (Perlin.snoise(x, y, z) * w_x * h_yXd_z + Perlin.snoise(x, y_h, z) * w_xXy * d_z + Perlin.snoise(x_w, y, z) * x * h_yXd_z + Perlin.snoise(x_w, y_h, z) * xy * d_z + Perlin.snoise(x_w, y_h, z_d) * xy * z + Perlin.snoise(x, y, z_d) * w_x * h_yXz + Perlin.snoise(x, y_h, z_d) * w_xXy * z + Perlin.snoise(x_w, y, z_d) * x * h_yXz) / (w * h * d);
    }

    public static final double spnoise(double xi, double yi, double zi, double ti, double w, double h, double d, double p) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double t = ti % p + (ti < 0.0 ? p : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double p_t = p - t;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double t_p = t - p;
        double xy = x * y;
        double d_zXp_t = d_z * p_t;
        double zXp_t = z * p_t;
        double zXt = z * t;
        double d_zXt = d_z * t;
        double w_xXy = w_x * y;
        double w_xXh_y = w_x * h_y;
        double xXh_y = x * h_y;
        return (Perlin.snoise(x, y, z, t) * w_xXh_y * d_zXp_t + Perlin.snoise(x_w, y, z, t) * xXh_y * d_zXp_t + Perlin.snoise(x_w, y_h, z, t) * xy * d_zXp_t + Perlin.snoise(x, y_h, z, t) * w_xXy * d_zXp_t + Perlin.snoise(x_w, y_h, z_d, t) * xy * zXp_t + Perlin.snoise(x, y, z_d, t) * w_xXh_y * zXp_t + Perlin.snoise(x, y_h, z_d, t) * w_xXy * zXp_t + Perlin.snoise(x_w, y, z_d, t) * xXh_y * zXp_t + Perlin.snoise(x, y, z, t_p) * w_xXh_y * d_zXt + Perlin.snoise(x_w, y, z, t_p) * xXh_y * d_zXt + Perlin.snoise(x_w, y_h, z, t_p) * xy * d_zXt + Perlin.snoise(x, y_h, z, t_p) * w_xXy * d_zXt + Perlin.snoise(x_w, y_h, z_d, t_p) * xy * zXt + Perlin.snoise(x, y, z_d, t_p) * w_xXh_y * zXt + Perlin.snoise(x, y_h, z_d, t_p) * w_xXy * zXt + Perlin.snoise(x_w, y, z_d, t_p) * xXh_y * zXt) / (w * h * d * t);
    }

    private static final double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private static final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static final double grad(int hash, double x) {
        int h = hash & 1;
        return x * G1[h];
    }

    private static final double grad(int hash, double x, double y) {
        int h = hash & 3;
        return x * G2[h][0] + y * G2[h][1];
    }

    private static final double grad(int hash, double x, double y, double z) {
        int h = hash & 0xF;
        return x * G3[h][0] + y * G3[h][1] + z * G3[h][2];
    }

    private static final double grad(int hash, double x, double y, double z, double w) {
        int h = hash & 0x1F;
        return x * G4[h][0] + y * G4[h][1] + z * G4[h][2] + w * G4[h][3];
    }
}

