/*
 * Decompiled with CFR 0.152.
 */
package clisk.noise;

public class Simplex {
    private static Grad[] grad3 = new Grad[]{new Grad(1.0, 1.0, 0.0), new Grad(-1.0, 1.0, 0.0), new Grad(1.0, -1.0, 0.0), new Grad(-1.0, -1.0, 0.0), new Grad(1.0, 0.0, 1.0), new Grad(-1.0, 0.0, 1.0), new Grad(1.0, 0.0, -1.0), new Grad(-1.0, 0.0, -1.0), new Grad(0.0, 1.0, 1.0), new Grad(0.0, -1.0, 1.0), new Grad(0.0, 1.0, -1.0), new Grad(0.0, -1.0, -1.0)};
    private static Grad[] grad4 = new Grad[]{new Grad(0.0, 1.0, 1.0, 1.0), new Grad(0.0, 1.0, 1.0, -1.0), new Grad(0.0, 1.0, -1.0, 1.0), new Grad(0.0, 1.0, -1.0, -1.0), new Grad(0.0, -1.0, 1.0, 1.0), new Grad(0.0, -1.0, 1.0, -1.0), new Grad(0.0, -1.0, -1.0, 1.0), new Grad(0.0, -1.0, -1.0, -1.0), new Grad(1.0, 0.0, 1.0, 1.0), new Grad(1.0, 0.0, 1.0, -1.0), new Grad(1.0, 0.0, -1.0, 1.0), new Grad(1.0, 0.0, -1.0, -1.0), new Grad(-1.0, 0.0, 1.0, 1.0), new Grad(-1.0, 0.0, 1.0, -1.0), new Grad(-1.0, 0.0, -1.0, 1.0), new Grad(-1.0, 0.0, -1.0, -1.0), new Grad(1.0, 1.0, 0.0, 1.0), new Grad(1.0, 1.0, 0.0, -1.0), new Grad(1.0, -1.0, 0.0, 1.0), new Grad(1.0, -1.0, 0.0, -1.0), new Grad(-1.0, 1.0, 0.0, 1.0), new Grad(-1.0, 1.0, 0.0, -1.0), new Grad(-1.0, -1.0, 0.0, 1.0), new Grad(-1.0, -1.0, 0.0, -1.0), new Grad(1.0, 1.0, 1.0, 0.0), new Grad(1.0, 1.0, -1.0, 0.0), new Grad(1.0, -1.0, 1.0, 0.0), new Grad(1.0, -1.0, -1.0, 0.0), new Grad(-1.0, 1.0, 1.0, 0.0), new Grad(-1.0, 1.0, -1.0, 0.0), new Grad(-1.0, -1.0, 1.0, 0.0), new Grad(-1.0, -1.0, -1.0, 0.0)};
    private static short[] p;
    private static short[] perm;
    private static short[] permMod12;
    private static final double F2;
    private static final double G2;
    private static final double F3 = 0.3333333333333333;
    private static final double G3 = 0.16666666666666666;
    private static final double F4;
    private static final double G4;

    static {
        short[] sArray = new short[256];
        sArray[0] = 151;
        sArray[1] = 160;
        sArray[2] = 137;
        sArray[3] = 91;
        sArray[4] = 90;
        sArray[5] = 15;
        sArray[6] = 131;
        sArray[7] = 13;
        sArray[8] = 201;
        sArray[9] = 95;
        sArray[10] = 96;
        sArray[11] = 53;
        sArray[12] = 194;
        sArray[13] = 233;
        sArray[14] = 7;
        sArray[15] = 225;
        sArray[16] = 140;
        sArray[17] = 36;
        sArray[18] = 103;
        sArray[19] = 30;
        sArray[20] = 69;
        sArray[21] = 142;
        sArray[22] = 8;
        sArray[23] = 99;
        sArray[24] = 37;
        sArray[25] = 240;
        sArray[26] = 21;
        sArray[27] = 10;
        sArray[28] = 23;
        sArray[29] = 190;
        sArray[30] = 6;
        sArray[31] = 148;
        sArray[32] = 247;
        sArray[33] = 120;
        sArray[34] = 234;
        sArray[35] = 75;
        sArray[37] = 26;
        sArray[38] = 197;
        sArray[39] = 62;
        sArray[40] = 94;
        sArray[41] = 252;
        sArray[42] = 219;
        sArray[43] = 203;
        sArray[44] = 117;
        sArray[45] = 35;
        sArray[46] = 11;
        sArray[47] = 32;
        sArray[48] = 57;
        sArray[49] = 177;
        sArray[50] = 33;
        sArray[51] = 88;
        sArray[52] = 237;
        sArray[53] = 149;
        sArray[54] = 56;
        sArray[55] = 87;
        sArray[56] = 174;
        sArray[57] = 20;
        sArray[58] = 125;
        sArray[59] = 136;
        sArray[60] = 171;
        sArray[61] = 168;
        sArray[62] = 68;
        sArray[63] = 175;
        sArray[64] = 74;
        sArray[65] = 165;
        sArray[66] = 71;
        sArray[67] = 134;
        sArray[68] = 139;
        sArray[69] = 48;
        sArray[70] = 27;
        sArray[71] = 166;
        sArray[72] = 77;
        sArray[73] = 146;
        sArray[74] = 158;
        sArray[75] = 231;
        sArray[76] = 83;
        sArray[77] = 111;
        sArray[78] = 229;
        sArray[79] = 122;
        sArray[80] = 60;
        sArray[81] = 211;
        sArray[82] = 133;
        sArray[83] = 230;
        sArray[84] = 220;
        sArray[85] = 105;
        sArray[86] = 92;
        sArray[87] = 41;
        sArray[88] = 55;
        sArray[89] = 46;
        sArray[90] = 245;
        sArray[91] = 40;
        sArray[92] = 244;
        sArray[93] = 102;
        sArray[94] = 143;
        sArray[95] = 54;
        sArray[96] = 65;
        sArray[97] = 25;
        sArray[98] = 63;
        sArray[99] = 161;
        sArray[100] = 1;
        sArray[101] = 216;
        sArray[102] = 80;
        sArray[103] = 73;
        sArray[104] = 209;
        sArray[105] = 76;
        sArray[106] = 132;
        sArray[107] = 187;
        sArray[108] = 208;
        sArray[109] = 89;
        sArray[110] = 18;
        sArray[111] = 169;
        sArray[112] = 200;
        sArray[113] = 196;
        sArray[114] = 135;
        sArray[115] = 130;
        sArray[116] = 116;
        sArray[117] = 188;
        sArray[118] = 159;
        sArray[119] = 86;
        sArray[120] = 164;
        sArray[121] = 100;
        sArray[122] = 109;
        sArray[123] = 198;
        sArray[124] = 173;
        sArray[125] = 186;
        sArray[126] = 3;
        sArray[127] = 64;
        sArray[128] = 52;
        sArray[129] = 217;
        sArray[130] = 226;
        sArray[131] = 250;
        sArray[132] = 124;
        sArray[133] = 123;
        sArray[134] = 5;
        sArray[135] = 202;
        sArray[136] = 38;
        sArray[137] = 147;
        sArray[138] = 118;
        sArray[139] = 126;
        sArray[140] = 255;
        sArray[141] = 82;
        sArray[142] = 85;
        sArray[143] = 212;
        sArray[144] = 207;
        sArray[145] = 206;
        sArray[146] = 59;
        sArray[147] = 227;
        sArray[148] = 47;
        sArray[149] = 16;
        sArray[150] = 58;
        sArray[151] = 17;
        sArray[152] = 182;
        sArray[153] = 189;
        sArray[154] = 28;
        sArray[155] = 42;
        sArray[156] = 223;
        sArray[157] = 183;
        sArray[158] = 170;
        sArray[159] = 213;
        sArray[160] = 119;
        sArray[161] = 248;
        sArray[162] = 152;
        sArray[163] = 2;
        sArray[164] = 44;
        sArray[165] = 154;
        sArray[166] = 163;
        sArray[167] = 70;
        sArray[168] = 221;
        sArray[169] = 153;
        sArray[170] = 101;
        sArray[171] = 155;
        sArray[172] = 167;
        sArray[173] = 43;
        sArray[174] = 172;
        sArray[175] = 9;
        sArray[176] = 129;
        sArray[177] = 22;
        sArray[178] = 39;
        sArray[179] = 253;
        sArray[180] = 19;
        sArray[181] = 98;
        sArray[182] = 108;
        sArray[183] = 110;
        sArray[184] = 79;
        sArray[185] = 113;
        sArray[186] = 224;
        sArray[187] = 232;
        sArray[188] = 178;
        sArray[189] = 185;
        sArray[190] = 112;
        sArray[191] = 104;
        sArray[192] = 218;
        sArray[193] = 246;
        sArray[194] = 97;
        sArray[195] = 228;
        sArray[196] = 251;
        sArray[197] = 34;
        sArray[198] = 242;
        sArray[199] = 193;
        sArray[200] = 238;
        sArray[201] = 210;
        sArray[202] = 144;
        sArray[203] = 12;
        sArray[204] = 191;
        sArray[205] = 179;
        sArray[206] = 162;
        sArray[207] = 241;
        sArray[208] = 81;
        sArray[209] = 51;
        sArray[210] = 145;
        sArray[211] = 235;
        sArray[212] = 249;
        sArray[213] = 14;
        sArray[214] = 239;
        sArray[215] = 107;
        sArray[216] = 49;
        sArray[217] = 192;
        sArray[218] = 214;
        sArray[219] = 31;
        sArray[220] = 181;
        sArray[221] = 199;
        sArray[222] = 106;
        sArray[223] = 157;
        sArray[224] = 184;
        sArray[225] = 84;
        sArray[226] = 204;
        sArray[227] = 176;
        sArray[228] = 115;
        sArray[229] = 121;
        sArray[230] = 50;
        sArray[231] = 45;
        sArray[232] = 127;
        sArray[233] = 4;
        sArray[234] = 150;
        sArray[235] = 254;
        sArray[236] = 138;
        sArray[237] = 236;
        sArray[238] = 205;
        sArray[239] = 93;
        sArray[240] = 222;
        sArray[241] = 114;
        sArray[242] = 67;
        sArray[243] = 29;
        sArray[244] = 24;
        sArray[245] = 72;
        sArray[246] = 243;
        sArray[247] = 141;
        sArray[248] = 128;
        sArray[249] = 195;
        sArray[250] = 78;
        sArray[251] = 66;
        sArray[252] = 215;
        sArray[253] = 61;
        sArray[254] = 156;
        sArray[255] = 180;
        p = sArray;
        perm = new short[512];
        permMod12 = new short[512];
        int i = 0;
        while (i < 512) {
            Simplex.perm[i] = p[i & 0xFF];
            Simplex.permMod12[i] = (short)(perm[i] % 12);
            ++i;
        }
        F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
        G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
        F4 = (Math.sqrt(5.0) - 1.0) / 4.0;
        G4 = (5.0 - Math.sqrt(5.0)) / 20.0;
    }

    private static int fastfloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static double dot(Grad g, double x, double y) {
        return g.x * x + g.y * y;
    }

    private static double dot(Grad g, double x, double y, double z) {
        return g.x * x + g.y * y + g.z * z;
    }

    private static double dot(Grad g, double x, double y, double z, double w) {
        return g.x * x + g.y * y + g.z * z + g.w * w;
    }

    public static double noise(double x, double y) {
        return 0.5 + 0.5 * Simplex.snoise(x, y);
    }

    public static double snoise(double xin, double yin) {
        double n2;
        double n1;
        double n0;
        int j1;
        int i1;
        double Y0;
        double y0;
        int j;
        double t;
        double s = (xin + yin) * F2;
        int i = Simplex.fastfloor(xin + s);
        double X0 = (double)i - (t = (double)(i + (j = Simplex.fastfloor(yin + s))) * G2);
        double x0 = xin - X0;
        if (x0 > (y0 = yin - (Y0 = (double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 - 1.0 + 2.0 * G2;
        double y2 = y0 - 1.0 + 2.0 * G2;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        short gi0 = permMod12[ii + perm[jj]];
        short gi1 = permMod12[ii + i1 + perm[jj + j1]];
        short gi2 = permMod12[ii + 1 + perm[jj + 1]];
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad3[gi0], x0, y0);
        }
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad3[gi1], x1, y1);
        }
        double t2 = 0.5 - x2 * x2 - y2 * y2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad3[gi2], x2, y2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    public static double noise(double x, double y, double z) {
        return 0.5 + 0.5 * Simplex.snoise(x, y, z);
    }

    public static double snoise(double xin, double yin, double zin) {
        double n3;
        double n2;
        double n1;
        double n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        double s = (xin + yin + zin) * 0.3333333333333333;
        int i = Simplex.fastfloor(xin + s);
        int j = Simplex.fastfloor(yin + s);
        int k = Simplex.fastfloor(zin + s);
        double t = (double)(i + j + k) * 0.16666666666666666;
        double X0 = (double)i - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double x0 = xin - X0;
        double y0 = yin - Y0;
        double z0 = zin - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 - 1.0 + 0.5;
        double y3 = y0 - 1.0 + 0.5;
        double z3 = z0 - 1.0 + 0.5;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        short gi0 = permMod12[ii + perm[jj + perm[kk]]];
        short gi1 = permMod12[ii + i1 + perm[jj + j1 + perm[kk + k1]]];
        short gi2 = permMod12[ii + i2 + perm[jj + j2 + perm[kk + k2]]];
        short gi3 = permMod12[ii + 1 + perm[jj + 1 + perm[kk + 1]]];
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad3[gi0], x0, y0, z0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad3[gi1], x1, y1, z1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad3[gi2], x2, y2, z2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * Simplex.dot(grad3[gi3], x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    public static double noise(double x, double y, double z, double w) {
        return 0.5 + 0.5 * Simplex.snoise(x, y, z, w);
    }

    public static double snoise(double x, double y, double z, double w) {
        double n4;
        double n3;
        double n2;
        double n1;
        double n0;
        double s = (x + y + z + w) * F4;
        int i = Simplex.fastfloor(x + s);
        int j = Simplex.fastfloor(y + s);
        int k = Simplex.fastfloor(z + s);
        int l = Simplex.fastfloor(w + s);
        double t = (double)(i + j + k + l) * G4;
        double X0 = (double)i - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double W0 = (double)l - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        double w0 = w - W0;
        int rankx = 0;
        int ranky = 0;
        int rankz = 0;
        int rankw = 0;
        if (x0 > y0) {
            ++rankx;
        } else {
            ++ranky;
        }
        if (x0 > z0) {
            ++rankx;
        } else {
            ++rankz;
        }
        if (x0 > w0) {
            ++rankx;
        } else {
            ++rankw;
        }
        if (y0 > z0) {
            ++ranky;
        } else {
            ++rankz;
        }
        if (y0 > w0) {
            ++ranky;
        } else {
            ++rankw;
        }
        if (z0 > w0) {
            ++rankz;
        } else {
            ++rankw;
        }
        int i1 = rankx >= 3 ? 1 : 0;
        int j1 = ranky >= 3 ? 1 : 0;
        int k1 = rankz >= 3 ? 1 : 0;
        int l1 = rankw >= 3 ? 1 : 0;
        int i2 = rankx >= 2 ? 1 : 0;
        int j2 = ranky >= 2 ? 1 : 0;
        int k2 = rankz >= 2 ? 1 : 0;
        int l2 = rankw >= 2 ? 1 : 0;
        int i3 = rankx >= 1 ? 1 : 0;
        int j3 = ranky >= 1 ? 1 : 0;
        int k3 = rankz >= 1 ? 1 : 0;
        int l3 = rankw >= 1 ? 1 : 0;
        double x1 = x0 - (double)i1 + G4;
        double y1 = y0 - (double)j1 + G4;
        double z1 = z0 - (double)k1 + G4;
        double w1 = w0 - (double)l1 + G4;
        double x2 = x0 - (double)i2 + 2.0 * G4;
        double y2 = y0 - (double)j2 + 2.0 * G4;
        double z2 = z0 - (double)k2 + 2.0 * G4;
        double w2 = w0 - (double)l2 + 2.0 * G4;
        double x3 = x0 - (double)i3 + 3.0 * G4;
        double y3 = y0 - (double)j3 + 3.0 * G4;
        double z3 = z0 - (double)k3 + 3.0 * G4;
        double w3 = w0 - (double)l3 + 3.0 * G4;
        double x4 = x0 - 1.0 + 4.0 * G4;
        double y4 = y0 - 1.0 + 4.0 * G4;
        double z4 = z0 - 1.0 + 4.0 * G4;
        double w4 = w0 - 1.0 + 4.0 * G4;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int ll = l & 0xFF;
        int gi0 = perm[ii + perm[jj + perm[kk + perm[ll]]]] % 32;
        int gi1 = perm[ii + i1 + perm[jj + j1 + perm[kk + k1 + perm[ll + l1]]]] % 32;
        int gi2 = perm[ii + i2 + perm[jj + j2 + perm[kk + k2 + perm[ll + l2]]]] % 32;
        int gi3 = perm[ii + i3 + perm[jj + j3 + perm[kk + k3 + perm[ll + l3]]]] % 32;
        int gi4 = perm[ii + 1 + perm[jj + 1 + perm[kk + 1 + perm[ll + 1]]]] % 32;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad4[gi0], x0, y0, z0, w0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad4[gi1], x1, y1, z1, w1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad4[gi2], x2, y2, z2, w2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * Simplex.dot(grad4[gi3], x3, y3, z3, w3);
        }
        double t4 = 0.6 - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t4 < 0.0) {
            n4 = 0.0;
        } else {
            t4 *= t4;
            n4 = t4 * t4 * Simplex.dot(grad4[gi4], x4, y4, z4, w4);
        }
        return 27.0 * (n0 + n1 + n2 + n3 + n4);
    }

    private static class Grad {
        double x;
        double y;
        double z;
        double w;

        Grad(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Grad(double x, double y, double z, double w) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
        }
    }
}

