/*
 * Decompiled with CFR 0.152.
 */
package clisk;

import clisk.Generator;
import clisk.Maths;
import clojure.lang.Compiler;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Util {
    private static final double LONG_SCALE_FACTOR = 1.0842021724855044E-19;

    public static BufferedImage newImage(int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 2);
        return result;
    }

    public static BufferedImage scaleImage(BufferedImage img, int w, int h) {
        int sw = img.getWidth();
        int sh = img.getHeight();
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Rectangle r = new Rectangle(0, 0, sw, sh);
        g.drawImage(img, 0, 0, w, h, null);
        return result;
    }

    public static int clamp(int v) {
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public static int toARGB(double r, double g, double b) {
        return Util.getARGBQuick(Util.clamp((int)(r * 256.0)), Util.clamp((int)(g * 256.0)), Util.clamp((int)(b * 256.0)), 255);
    }

    public static int toARGB(double r, double g, double b, double a) {
        return Util.getARGBQuick(Util.clamp((int)(r * 256.0)), Util.clamp((int)(g * 256.0)), Util.clamp((int)(b * 256.0)), Util.clamp((int)(a * 256.0)));
    }

    public static int getARGBQuick(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static JFrame frame(final BufferedImage image) {
        final JFrame f = new JFrame("Clisk Image");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem jmi = new JMenuItem("Save As...");
        menu.add(jmi);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileDialog fileDialog = new FileDialog((Frame)f, "Save Image As...", 1);
                fileDialog.setFile("*.png");
                fileDialog.setVisible(true);
                String fileName = fileDialog.getFile();
                if (fileName != null) {
                    File outputFile = new File(fileDialog.getDirectory(), fileName);
                    try {
                        ImageIO.write((RenderedImage)image, "png", outputFile);
                        System.out.println("Saving: " + outputFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JComponent c = new JComponent(){

            @Override
            public void paint(Graphics g) {
                g.drawImage(image, 0, 0, null);
            }
        };
        c.setMinimumSize(new Dimension(image.getWidth(null), image.getHeight(null)));
        f.setMinimumSize(new Dimension(image.getWidth(null) + 20, image.getHeight(null) + 100));
        f.add(c);
        f.setJMenuBar(menuBar);
        f.setDefaultCloseOperation(2);
        f.pack();
        return f;
    }

    public static JFrame show(BufferedImage image) {
        JFrame f = Util.frame(image);
        f.setVisible(true);
        f.pack();
        return f;
    }

    public static JFrame show(String script) {
        return Util.show(Generator.generate(script));
    }

    public static final long longHash(long a) {
        a ^= a << 21;
        a ^= a >>> 35;
        a ^= a << 4;
        return a;
    }

    public static final long hash(double x) {
        return Util.longHash(Util.longHash(32768L + Long.rotateLeft(Util.longHash(Double.doubleToRawLongBits(x)), 17)));
    }

    public static final long hash(double x, double y) {
        return Util.longHash(Util.longHash(Util.hash(x) + Long.rotateLeft(Util.longHash(Double.doubleToRawLongBits(y)), 17)));
    }

    public static final long hash(double x, double y, double z) {
        return Util.longHash(Util.longHash(Util.hash(x, y) + Long.rotateLeft(Util.longHash(Double.doubleToRawLongBits(z)), 17)));
    }

    public static final long hash(double x, double y, double z, double t) {
        return Util.longHash(Util.longHash(Util.hash(x, y, z) + Long.rotateLeft(Util.longHash(Double.doubleToRawLongBits(t)), 17)));
    }

    public static final double dhash(double x) {
        long h = Util.hash(x);
        return (double)(h & Long.MAX_VALUE) * 1.0842021724855044E-19;
    }

    public static final double dhash(double x, double y) {
        long h = Util.hash(x, y);
        return (double)(h & Long.MAX_VALUE) * 1.0842021724855044E-19;
    }

    public static final double dhash(double x, double y, double z) {
        long h = Util.hash(x, y, z);
        return (double)(h & Long.MAX_VALUE) * 1.0842021724855044E-19;
    }

    public static final double dhash(double x, double y, double z, double t) {
        long h = Util.hash(x, y, z, t);
        return (double)(h & Long.MAX_VALUE) * 1.0842021724855044E-19;
    }

    public static Object execute(String script) {
        return Compiler.load((Reader)new StringReader(script));
    }

    private static double componentFromPQT(double p, double q, double h) {
        if ((h = Maths.mod(h, 1.0)) < 0.16666666666666666) {
            return p + (q - p) * 6.0 * h;
        }
        if (h < 0.5) {
            return q;
        }
        if (h < 0.6666666666666666) {
            return p + (q - p) * (0.6666666666666666 - h) * 6.0;
        }
        return p;
    }

    public static double redFromHSL(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        return Util.componentFromPQT(p, q, h + 0.3333333333333333);
    }

    public static double greenFromHSL(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        return Util.componentFromPQT(p, q, h);
    }

    public static double blueFromHSL(double h, double s, double l) {
        if (s == 0.0) {
            return l;
        }
        double q = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double p = 2.0 * l - q;
        return Util.componentFromPQT(p, q, h - 0.3333333333333333);
    }
}

