/*
 * Decompiled with CFR 0.152.
 */
package clisk.generator;

import clisk.CliskError;
import clisk.IFunction;
import clisk.Util;
import java.util.Random;

public final class Voronoi2D {
    private final int count;
    private final double[] xs;
    private final double[] ys;

    public Voronoi2D(int numPoints) {
        if (numPoints < 3) {
            throw new CliskError("Voronoi map must have at least 3 features");
        }
        if (numPoints > 1000) {
            throw new CliskError("Voronoi map has maximum of 1000 features");
        }
        this.count = numPoints;
        this.xs = new double[numPoints];
        this.ys = new double[numPoints];
        Random r = new Random();
        r.setSeed(0xFFFFFFFFCAFEBABEL ^ Util.longHash(numPoints));
        int i = 0;
        while (i < this.count) {
            this.xs[i] = r.nextDouble();
            this.ys[i] = r.nextDouble();
            ++i;
        }
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        if ((dx -= Math.floor(dx)) > 0.5) {
            dx = 1.0 - dx;
        }
        double dy = y2 - y1;
        if ((dy -= Math.floor(dy)) > 0.5) {
            dy = 1.0 - dy;
        }
        return dx * dx + dy * dy;
    }

    private int seek(double x, double y) {
        int i0 = 0;
        int i1 = 1;
        int i2 = 2;
        double dd0 = Voronoi2D.dist2(x, y, this.xs[0], this.ys[0]);
        double dd1 = Voronoi2D.dist2(x, y, this.xs[1], this.ys[1]);
        double dd2 = Voronoi2D.dist2(x, y, this.xs[2], this.ys[2]);
        if (dd2 < dd1) {
            i1 = 2;
            i2 = 1;
            double t = dd1;
            dd1 = dd2;
            dd2 = t;
        }
        if (dd1 < dd0) {
            int ti = i0;
            i0 = i1;
            i1 = ti;
            double t = dd0;
            dd0 = dd1;
            dd1 = t;
        }
        int i = 3;
        while (i < this.count) {
            double px = this.xs[i];
            double py = this.ys[i];
            double dd = Voronoi2D.dist2(px, py, x, y);
            if (dd < dd2) {
                if (dd < dd1) {
                    if (dd < dd0) {
                        i2 = i1;
                        dd2 = dd1;
                        i1 = i0;
                        dd1 = dd0;
                        i0 = i;
                        dd0 = dd;
                    } else {
                        i2 = i1;
                        dd2 = dd1;
                        i1 = i;
                        dd1 = dd;
                    }
                } else {
                    i2 = i;
                    dd2 = dd;
                }
            }
            ++i;
        }
        return i0 + (i1 << 10) + (i2 << 20);
    }

    protected int seekFirst(double x, double y) {
        return this.seek(x, y) & 0x3FF;
    }

    protected int seekSecond(double x, double y) {
        return this.seek(x, y) >> 10 & 0x3FF;
    }

    protected int seekThird(double x, double y) {
        return this.seek(x, y) >> 10 & 0x3FF;
    }

    public double nearestX(double x, double y) {
        return this.xs[this.seekFirst(x, y)];
    }

    public double nearestY(double x, double y) {
        return this.ys[this.seekFirst(x, y)];
    }

    public double nearestDistanceSquared(double x, double y) {
        int i = this.seekFirst(x, y);
        return Voronoi2D.dist2(x, y, this.xs[i], this.ys[i]);
    }

    public double nearestDistance(double x, double y) {
        return Math.sqrt(this.nearestDistanceSquared(x, y));
    }

    public double firstSecondFunction(double x, double y, IFunction func) {
        int i = this.seek(x, y);
        int i0 = i & 0x3FF;
        int i1 = i >> 10 & 0x3FF;
        int i2 = i >> 20 & 0x3FF;
        double d0 = Math.sqrt(Voronoi2D.dist2(x, y, this.xs[i0], this.ys[i0]));
        double d1 = Math.sqrt(Voronoi2D.dist2(x, y, this.xs[i1], this.ys[i1]));
        double d2 = Math.sqrt(Voronoi2D.dist2(x, y, this.xs[i2], this.ys[i2]));
        return func.calc(d0, d1, d2);
    }
}

