/*
 * Decompiled with CFR 0.152.
 */
package clisk.noise;

public final class Perlin {
    private static final double[] G1 = new double[]{-1.0, 1.0};
    private static final double[][] G2 = new double[][]{{1.0, 0.0}, {-1.0, 0.0}, {0.0, 1.0}, {0.0, -1.0}};
    private static final double[][] G3 = new double[][]{{1.0, 1.0, 0.0}, {-1.0, 1.0, 0.0}, {1.0, -1.0, 0.0}, {-1.0, -1.0, 0.0}, {1.0, 0.0, 1.0}, {-1.0, 0.0, 1.0}, {1.0, 0.0, -1.0}, {-1.0, 0.0, -1.0}, {0.0, 1.0, 1.0}, {0.0, -1.0, 1.0}, {0.0, 1.0, -1.0}, {0.0, -1.0, -1.0}, {1.0, 1.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}, {0.0, -1.0, -1.0}};
    private static final double[][] G4 = new double[][]{{-1.0, -1.0, -1.0, 0.0}, {-1.0, -1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0, 0.0}, {-1.0, 1.0, 1.0, 0.0}, {1.0, -1.0, -1.0, 0.0}, {1.0, -1.0, 1.0, 0.0}, {1.0, 1.0, -1.0, 0.0}, {1.0, 1.0, 1.0, 0.0}, {-1.0, -1.0, 0.0, -1.0}, {-1.0, 1.0, 0.0, -1.0}, {1.0, -1.0, 0.0, -1.0}, {1.0, 1.0, 0.0, -1.0}, {-1.0, -1.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 1.0}, {1.0, -1.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 1.0}, {-1.0, 0.0, -1.0, -1.0}, {1.0, 0.0, -1.0, -1.0}, {-1.0, 0.0, -1.0, 1.0}, {1.0, 0.0, -1.0, 1.0}, {-1.0, 0.0, 1.0, -1.0}, {1.0, 0.0, 1.0, -1.0}, {-1.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 1.0}, {0.0, -1.0, -1.0, -1.0}, {0.0, -1.0, -1.0, 1.0}, {0.0, -1.0, 1.0, -1.0}, {0.0, -1.0, 1.0, 1.0}, {0.0, 1.0, -1.0, -1.0}, {0.0, 1.0, -1.0, 1.0}, {0.0, 1.0, 1.0, -1.0}, {0.0, 1.0, 1.0, 1.0}};
    private static final int[] p = new int[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180, 151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};

    public static final double snoise(double x) {
        int xf = (int)Math.floor(x);
        int X = xf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        int A = p[X];
        int B = p[X + 1];
        return Perlin.lerp(u, Perlin.grad(p[A], x), Perlin.grad(p[B], x - 1.0));
    }

    public static final double snoise(double x, double y) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        int A = p[X] + Y;
        int B = p[X + 1] + Y;
        return Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[A], x, y), Perlin.grad(p[B], x - 1.0, y)), Perlin.lerp(u, Perlin.grad(p[A + 1], x, y - 1.0), Perlin.grad(p[B + 1], x - 1.0, y - 1.0)));
    }

    public static final double snoise(double x, double y, double z) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int zf = (int)Math.floor(z);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        int Z = zf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        double w = Perlin.fade(z -= (double)zf);
        int A = p[X] + Y;
        int AA = p[A] + Z;
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        return Perlin.lerp(w, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AA], x, y, z), Perlin.grad(p[BA], x - 1.0, y, z)), Perlin.lerp(u, Perlin.grad(p[AB], x, y - 1.0, z), Perlin.grad(p[BB], x - 1.0, y - 1.0, z))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AA + 1], x, y, z - 1.0), Perlin.grad(p[BA + 1], x - 1.0, y, z - 1.0)), Perlin.lerp(u, Perlin.grad(p[AB + 1], x, y - 1.0, z - 1.0), Perlin.grad(p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public static final double snoise(double x, double y, double z, double w) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int zf = (int)Math.floor(z);
        int wf = (int)Math.floor(w);
        int X = xf & 0xFF;
        int Y = yf & 0xFF;
        int Z = zf & 0xFF;
        int W = wf & 0xFF;
        double u = Perlin.fade(x -= (double)xf);
        double v = Perlin.fade(y -= (double)yf);
        double t = Perlin.fade(z -= (double)zf);
        double s = Perlin.fade(w -= (double)wf);
        int A = p[X] + Y;
        int AA = p[A] + Z;
        int AB = p[A + 1] + Z;
        int B = p[X + 1] + Y;
        int BA = p[B] + Z;
        int BB = p[B + 1] + Z;
        int AAA = p[AA] + W;
        int AAB = p[AA + 1] + W;
        int ABA = p[AB] + W;
        int ABB = p[AB + 1] + W;
        int BAA = p[BA] + W;
        int BAB = p[BA + 1] + W;
        int BBA = p[BB] + W;
        int BBB = p[BB + 1] + W;
        return Perlin.lerp(s, Perlin.lerp(t, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAA], x, y, z, w), Perlin.grad(p[BAA], x - 1.0, y, z, w)), Perlin.lerp(u, Perlin.grad(p[ABA], x, y - 1.0, z, w), Perlin.grad(p[BBA], x - 1.0, y - 1.0, z, w))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAB], x, y, z - 1.0, w), Perlin.grad(p[BAB], x - 1.0, y, z - 1.0, w)), Perlin.lerp(u, Perlin.grad(p[ABB], x, y - 1.0, z - 1.0, w), Perlin.grad(p[BBB], x - 1.0, y - 1.0, z - 1.0, w)))), Perlin.lerp(t, Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAA + 1], x, y, z, w - 1.0), Perlin.grad(p[BAA + 1], x - 1.0, y, z, w - 1.0)), Perlin.lerp(u, Perlin.grad(p[ABA + 1], x, y - 1.0, z, w - 1.0), Perlin.grad(p[BBA + 1], x - 1.0, y - 1.0, z, w - 1.0))), Perlin.lerp(v, Perlin.lerp(u, Perlin.grad(p[AAB + 1], x, y, z - 1.0, w - 1.0), Perlin.grad(p[BAB + 1], x - 1.0, y, z - 1.0, w - 1.0)), Perlin.lerp(u, Perlin.grad(p[ABB + 1], x, y - 1.0, z - 1.0, w - 1.0), Perlin.grad(p[BBB + 1], x - 1.0, y - 1.0, z - 1.0, w - 1.0)))));
    }

    public static final double noise(double x) {
        return 0.5 + 0.5 * Perlin.snoise(x);
    }

    public static final double noise(double x, double y) {
        return 0.5 + 0.5 * Perlin.snoise(x, y);
    }

    public static final double noise(double x, double y, double z) {
        return 0.5 + 0.5 * Perlin.snoise(x, y, z);
    }

    public static final double noise(double x, double y, double z, double t) {
        return 0.5 + 0.5 * Perlin.snoise(x, y, z, t);
    }

    public static final double pnoise(double xi, double period) {
        double x = xi % period + (xi < 0.0 ? period : 0.0);
        return ((period - x) * Perlin.noise(x) + x * Perlin.noise(x - period)) / period;
    }

    public static final double pnoise(double xi, double yi, double w, double h) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double x_w = x - w;
        double y_h = y - h;
        return (Perlin.noise(x, y) * w_x * h_y + Perlin.noise(x_w, y) * x * h_y + Perlin.noise(x_w, y_h) * x * y + Perlin.noise(x, y_h) * w_x * y) / (w * h);
    }

    public static final double pnoise(double xi, double yi, double zi, double w, double h, double d) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double xy = x * y;
        double h_yXd_z = h_y * d_z;
        double h_yXz = h_y * z;
        double w_xXy = w_x * y;
        return (Perlin.noise(x, y, z) * w_x * h_yXd_z + Perlin.noise(x, y_h, z) * w_xXy * d_z + Perlin.noise(x_w, y, z) * x * h_yXd_z + Perlin.noise(x_w, y_h, z) * xy * d_z + Perlin.noise(x_w, y_h, z_d) * xy * z + Perlin.noise(x, y, z_d) * w_x * h_yXz + Perlin.noise(x, y_h, z_d) * w_xXy * z + Perlin.noise(x_w, y, z_d) * x * h_yXz) / (w * h * d);
    }

    public static final double pnoise(double xi, double yi, double zi, double ti, double w, double h, double d, double p) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double t = ti % p + (ti < 0.0 ? p : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double p_t = p - t;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double t_p = t - p;
        double xy = x * y;
        double d_zXp_t = d_z * p_t;
        double zXp_t = z * p_t;
        double zXt = z * t;
        double d_zXt = d_z * t;
        double w_xXy = w_x * y;
        double w_xXh_y = w_x * h_y;
        double xXh_y = x * h_y;
        return (Perlin.noise(x, y, z, t) * w_xXh_y * d_zXp_t + Perlin.noise(x_w, y, z, t) * xXh_y * d_zXp_t + Perlin.noise(x_w, y_h, z, t) * xy * d_zXp_t + Perlin.noise(x, y_h, z, t) * w_xXy * d_zXp_t + Perlin.noise(x_w, y_h, z_d, t) * xy * zXp_t + Perlin.noise(x, y, z_d, t) * w_xXh_y * zXp_t + Perlin.noise(x, y_h, z_d, t) * w_xXy * zXp_t + Perlin.noise(x_w, y, z_d, t) * xXh_y * zXp_t + Perlin.noise(x, y, z, t_p) * w_xXh_y * d_zXt + Perlin.noise(x_w, y, z, t_p) * xXh_y * d_zXt + Perlin.noise(x_w, y_h, z, t_p) * xy * d_zXt + Perlin.noise(x, y_h, z, t_p) * w_xXy * d_zXt + Perlin.noise(x_w, y_h, z_d, t_p) * xy * zXt + Perlin.noise(x, y, z_d, t_p) * w_xXh_y * zXt + Perlin.noise(x, y_h, z_d, t_p) * w_xXy * zXt + Perlin.noise(x_w, y, z_d, t_p) * xXh_y * zXt) / (w * h * d * t);
    }

    public static final double spnoise(double xi, double period) {
        double x = xi % period + (xi < 0.0 ? period : 0.0);
        return ((period - x) * Perlin.snoise(x) + x * Perlin.snoise(x - period)) / period;
    }

    public static final double spnoise(double xi, double yi, double w, double h) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double x_w = x - w;
        double y_h = y - h;
        return (Perlin.snoise(x, y) * w_x * h_y + Perlin.snoise(x_w, y) * x * h_y + Perlin.snoise(x_w, y_h) * x * y + Perlin.snoise(x, y_h) * w_x * y) / (w * h);
    }

    public static final double spnoise(double xi, double yi, double zi, double w, double h, double d) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double xy = x * y;
        double h_yXd_z = h_y * d_z;
        double h_yXz = h_y * z;
        double w_xXy = w_x * y;
        return (Perlin.snoise(x, y, z) * w_x * h_yXd_z + Perlin.snoise(x, y_h, z) * w_xXy * d_z + Perlin.snoise(x_w, y, z) * x * h_yXd_z + Perlin.snoise(x_w, y_h, z) * xy * d_z + Perlin.snoise(x_w, y_h, z_d) * xy * z + Perlin.snoise(x, y, z_d) * w_x * h_yXz + Perlin.snoise(x, y_h, z_d) * w_xXy * z + Perlin.snoise(x_w, y, z_d) * x * h_yXz) / (w * h * d);
    }

    public static final double spnoise(double xi, double yi, double zi, double ti, double w, double h, double d, double p) {
        double x = xi % w + (xi < 0.0 ? w : 0.0);
        double y = yi % h + (yi < 0.0 ? h : 0.0);
        double z = zi % d + (zi < 0.0 ? d : 0.0);
        double t = ti % p + (ti < 0.0 ? p : 0.0);
        double w_x = w - x;
        double h_y = h - y;
        double d_z = d - z;
        double p_t = p - t;
        double x_w = x - w;
        double y_h = y - h;
        double z_d = z - d;
        double t_p = t - p;
        double xy = x * y;
        double d_zXp_t = d_z * p_t;
        double zXp_t = z * p_t;
        double zXt = z * t;
        double d_zXt = d_z * t;
        double w_xXy = w_x * y;
        double w_xXh_y = w_x * h_y;
        double xXh_y = x * h_y;
        return (Perlin.snoise(x, y, z, t) * w_xXh_y * d_zXp_t + Perlin.snoise(x_w, y, z, t) * xXh_y * d_zXp_t + Perlin.snoise(x_w, y_h, z, t) * xy * d_zXp_t + Perlin.snoise(x, y_h, z, t) * w_xXy * d_zXp_t + Perlin.snoise(x_w, y_h, z_d, t) * xy * zXp_t + Perlin.snoise(x, y, z_d, t) * w_xXh_y * zXp_t + Perlin.snoise(x, y_h, z_d, t) * w_xXy * zXp_t + Perlin.snoise(x_w, y, z_d, t) * xXh_y * zXp_t + Perlin.snoise(x, y, z, t_p) * w_xXh_y * d_zXt + Perlin.snoise(x_w, y, z, t_p) * xXh_y * d_zXt + Perlin.snoise(x_w, y_h, z, t_p) * xy * d_zXt + Perlin.snoise(x, y_h, z, t_p) * w_xXy * d_zXt + Perlin.snoise(x_w, y_h, z_d, t_p) * xy * zXt + Perlin.snoise(x, y, z_d, t_p) * w_xXh_y * zXt + Perlin.snoise(x, y_h, z_d, t_p) * w_xXy * zXt + Perlin.snoise(x_w, y, z_d, t_p) * xXh_y * zXt) / (w * h * d * t);
    }

    private static final double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private static final double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private static final double grad(int hash, double x) {
        int h = hash & 1;
        return x * G1[h];
    }

    private static final double grad(int hash, double x, double y) {
        int h = hash & 3;
        return x * G2[h][0] + y * G2[h][1];
    }

    private static final double grad(int hash, double x, double y, double z) {
        int h = hash & 0xF;
        return x * G3[h][0] + y * G3[h][1] + z * G3[h][2];
    }

    private static final double grad(int hash, double x, double y, double z, double w) {
        int h = hash & 0x1F;
        return x * G4[h][0] + y * G4[h][1] + z * G4[h][2] + w * G4[h][3];
    }
}

