/*
 * Decompiled with CFR 0.152.
 */
package clisk;

import clisk.Function;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;

public class VectorFunction
extends mikera.vectorz.functions.VectorFunction {
    private final int inputDimensions;
    private final int outputDimensions;
    private final Function[] functions;

    private VectorFunction(int inputs, int outputs, Function[] functions) {
        this.inputDimensions = inputs;
        this.outputDimensions = outputs;
        this.functions = functions;
    }

    public VectorFunction create(int inputDims, List<Function> functions) {
        Function[] funcs = functions.toArray(new Function[functions.size()]);
        return new VectorFunction(inputDims, funcs.length, funcs);
    }

    public Function getFunction(int i) {
        return this.functions[i];
    }

    public void transform(AVector source, AVector dest) {
        for (int i = 0; i < this.outputDimensions; ++i) {
            double v = this.functions[i].calc(source);
            dest.set(i, v);
        }
    }

    public void transform(AVector source, Vector3 dest) {
        dest.x = this.functions[0].calc(source);
        dest.y = this.functions[1].calc(source);
        dest.z = this.functions[2].calc(source);
    }

    public void transform(Vector3 source, Vector3 dest) {
        dest.x = this.functions[0].calc(source);
        dest.y = this.functions[1].calc(source);
        dest.z = this.functions[2].calc(source);
    }

    public int inputDimensions() {
        return this.inputDimensions;
    }

    public int outputDimensions() {
        return this.outputDimensions;
    }
}

