/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data;

import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static String DOM2String(Node node) throws TransformerException, TransformerFactoryConfigurationError {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        transFactory.newTransformer().transform(new DOMSource(node), new StreamResult(writer));
        String result = writer.getBuffer().toString();
        return result;
    }

    public static String DOM2HTML(Node node) throws TransformerException {
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        StreamSource xsltSource = new StreamSource(Utils.class.getResourceAsStream("xml2html.xslt"));
        Transformer transformer = transFactory.newTransformer(xsltSource);
        StreamResult result = new StreamResult(System.out);
        transformer.transform(new DOMSource(node), result);
        return writer.getBuffer().toString();
    }

    public static String leftPad(String str, int length) {
        return Utils.leftPad(str, length, ' ');
    }

    public static String leftPad(String str, int length, char ch) {
        int padding = length - str.length();
        if (padding > 0) {
            char[] buf = new char[padding];
            for (int i = 0; i < padding; ++i) {
                buf[i] = ch;
            }
            return new String(buf) + str;
        }
        return str;
    }

    public static void writeXmlFile(Document doc, String filename) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        File file = new File(filename);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }

    public static void writeXmlFileAsHtml(Document doc, String filename) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        File file = new File(filename);
        StreamResult result = new StreamResult(file);
        StreamSource xsltSource = new StreamSource(Utils.class.getResourceAsStream("xml2html.xslt"));
        Transformer xformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        xformer.transform(source, result);
    }

    public static void setDDIIdentifiableId(Element e, String id) {
        e.setAttribute("id", id);
        e.setAttribute("isIdentifiable", "true");
    }

    public static void setDDIMaintainableId(Element e, String id) {
        e.setAttribute("id", id);
        e.setAttribute("isMaintainable", "true");
    }

    public static void setDDIVersionableId(Element e, String id) {
        e.setAttribute("id", id);
        e.setAttribute("isVersionable", "true");
    }
}

