/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSUtils;

public class SPSSRecordType2
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int variableTypeCode;
    int hasLabel;
    int missingValueFormatCode;
    int printFormatCode;
    int printFormatDecimals;
    int printFormatWidth;
    int printFormatType;
    int printFormatZero;
    int writeFormatCode;
    int writeFormatDecimals;
    int writeFormatWidth;
    int writeFormatType;
    int writeFormatZero;
    String name;
    int labelLength;
    String label;
    byte[][] missingValue = new byte[3][8];
    SPSSFile file;
    SPSSRecordType3 valueLabelSet;

    public String getFormatTypeCode(int value) {
        String label = "UNK";
        switch (value) {
            case 0: {
                label = "";
                break;
            }
            case 1: {
                label = "A";
                break;
            }
            case 2: {
                label = "AHEX";
                break;
            }
            case 3: {
                label = "COMMA";
                break;
            }
            case 4: {
                label = "DOLLAR";
                break;
            }
            case 5: {
                label = "F";
                break;
            }
            case 6: {
                label = "IB";
                break;
            }
            case 7: {
                label = "PIBHEX";
                break;
            }
            case 8: {
                label = "P";
                break;
            }
            case 9: {
                label = "PIB";
                break;
            }
            case 10: {
                label = "PK";
                break;
            }
            case 11: {
                label = "RB";
                break;
            }
            case 12: {
                label = "RBHEX";
                break;
            }
            case 15: {
                label = "Z";
                break;
            }
            case 16: {
                label = "N";
                break;
            }
            case 17: {
                label = "E";
                break;
            }
            case 20: {
                label = "DATE";
                break;
            }
            case 21: {
                label = "TIME";
                break;
            }
            case 22: {
                label = "DATETIME";
                break;
            }
            case 23: {
                label = "ADATE";
                break;
            }
            case 24: {
                label = "JDATE";
                break;
            }
            case 25: {
                label = "DTIME";
                break;
            }
            case 26: {
                label = "WKDAY";
                break;
            }
            case 27: {
                label = "MONTH";
                break;
            }
            case 28: {
                label = "MOYR";
                break;
            }
            case 29: {
                label = "QYR";
                break;
            }
            case 30: {
                label = "WKYR";
                break;
            }
            case 31: {
                label = "PCT";
                break;
            }
            case 32: {
                label = "DOT";
                break;
            }
            case 33: {
                label = "CCA";
                break;
            }
            case 34: {
                label = "CCB";
                break;
            }
            case 35: {
                label = "CCC";
                break;
            }
            case 36: {
                label = "CCD";
                break;
            }
            case 37: {
                label = "CCE";
                break;
            }
            case 38: {
                label = "EDATE";
                break;
            }
            case 39: {
                label = "SDATE";
            }
        }
        return label;
    }

    public String getFormatTypeLabel(int value) {
        String label = "Unknown";
        switch (value) {
            case 0: {
                label = "Continuation of string variable";
                break;
            }
            case 1: {
                label = "Alphanumeric";
                break;
            }
            case 2: {
                label = "Alphanumeric hexadecimal";
                break;
            }
            case 3: {
                label = "F format with comma";
                break;
            }
            case 4: {
                label = "Integer binary";
                break;
            }
            case 5: {
                label = "F (default numeric) format";
                break;
            }
            case 6: {
                label = "Integer binary";
                break;
            }
            case 7: {
                label = "Positive integer binary - hexadecimal";
                break;
            }
            case 8: {
                label = "Packed decimal";
                break;
            }
            case 9: {
                label = "Positive integer binary (unsigned)";
                break;
            }
            case 10: {
                label = "Positive packed decimal (unsigned)";
                break;
            }
            case 11: {
                label = "Floating point binary";
                break;
            }
            case 12: {
                label = "Floating point binary - hex";
                break;
            }
            case 15: {
                label = "Zoned decimal";
                break;
            }
            case 16: {
                label = "N format - unsigned with leading zeroes";
                break;
            }
            case 17: {
                label = "E fromat - with explicit power of 10";
                break;
            }
            case 20: {
                label = "Date format dd-mmm-yyyy";
                break;
            }
            case 21: {
                label = "Time format hh:mm:ss.s";
                break;
            }
            case 22: {
                label = "Date and time";
                break;
            }
            case 23: {
                label = "Date in mm/dd/yyyy form";
                break;
            }
            case 24: {
                label = "Julian date - yyyyddd";
                break;
            }
            case 25: {
                label = "Date-time dd hh:mm:ss.s";
                break;
            }
            case 26: {
                label = "Day of the week";
                break;
            }
            case 27: {
                label = "Month";
                break;
            }
            case 28: {
                label = "mmm yyyy";
                break;
            }
            case 29: {
                label = "q Q yyyy";
                break;
            }
            case 30: {
                label = "ww WK yyyy";
                break;
            }
            case 31: {
                label = "Percent - F followed by '%'";
                break;
            }
            case 32: {
                label = "Like COMMA, swicthing dot for comma";
                break;
            }
            case 33: {
                label = "User-programmable currency format (1)";
                break;
            }
            case 34: {
                label = "User-programmable currency format (2)";
                break;
            }
            case 35: {
                label = "User-programmable currency format (3)";
                break;
            }
            case 36: {
                label = "User-programmable currency format (4)";
                break;
            }
            case 37: {
                label = "User-programmable currency format (5)";
                break;
            }
            case 38: {
                label = "Date in dd.mm.yyyy style";
                break;
            }
            case 39: {
                label = "Date in yyyy/mm/dd style";
            }
        }
        return label;
    }

    public int getWriteFormatType() {
        return this.writeFormatType;
    }

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.file = is;
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 2) {
            throw new SPSSFileException("Error reading variable Record: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 2.");
        }
        this.variableTypeCode = is.readSPSSInt();
        this.hasLabel = is.readSPSSInt();
        this.missingValueFormatCode = is.readSPSSInt();
        if (Math.abs(this.missingValueFormatCode) > 3) {
            throw new SPSSFileException("Error reading variable Record: invalid missing value format code [" + this.missingValueFormatCode + "]. Range is -3 to 3.");
        }
        this.printFormatCode = is.readSPSSInt();
        this.printFormatDecimals = this.printFormatCode >> 0 & 0xFF;
        this.printFormatWidth = this.printFormatCode >> 8 & 0xFF;
        this.printFormatType = this.printFormatCode >> 16 & 0xFF;
        this.printFormatZero = this.printFormatCode >> 24 & 0xFF;
        this.writeFormatCode = is.readSPSSInt();
        this.writeFormatDecimals = this.writeFormatCode >> 0 & 0xFF;
        this.writeFormatWidth = this.writeFormatCode >> 8 & 0xFF;
        this.writeFormatType = this.writeFormatCode >> 16 & 0xFF;
        this.writeFormatZero = this.writeFormatCode >> 24 & 0xFF;
        this.name = is.readSPSSString(8).replaceAll("\\s+$", "");
        if (this.hasLabel == 1) {
            this.labelLength = is.readSPSSInt();
            this.label = is.readSPSSString(this.labelLength);
            if (this.labelLength % 4 != 0) {
                is.skipBytes(4 - this.labelLength % 4);
            }
        }
        for (int i = 0; i < Math.abs(this.missingValueFormatCode); ++i) {
            is.read(this.missingValue[i]);
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 2 - VARIABLE";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nVariable Type   : " + this.variableTypeCode;
        str = str + "\nHas Label       : " + this.hasLabel;
        str = str + "\nMissing Format  : " + this.missingValueFormatCode;
        str = str + "\nPrint Format    : " + this.printFormatCode;
        str = str + "\n- Decimals      : " + this.printFormatDecimals;
        str = str + "\n- Width         : " + this.printFormatWidth;
        str = str + "\n- Type          : " + this.printFormatType + " [" + this.getFormatTypeCode(this.printFormatType) + "/" + this.getFormatTypeLabel(this.printFormatType) + "]";
        str = str + "\n- Zero          : " + this.printFormatZero;
        str = str + "\nWrite Format    : " + this.writeFormatCode;
        str = str + "\n- Decimals      : " + this.writeFormatDecimals;
        str = str + "\n- Width         : " + this.writeFormatWidth;
        str = str + "\n- Type          : " + this.writeFormatType + " [" + this.getFormatTypeCode(this.writeFormatType) + "/" + this.getFormatTypeLabel(this.writeFormatType) + "]";
        str = str + "\n- Zero          : " + this.writeFormatZero;
        str = str + "\nName            : " + this.name;
        if (this.hasLabel == 1) {
            str = str + "\nLabel length    : " + this.labelLength;
            str = str + "\nLabel           : " + this.label;
        }
        if (this.missingValueFormatCode > 0) {
            for (int i = 0; i < this.missingValueFormatCode; ++i) {
                str = str + "\nMissing " + i + "       :";
                str = this.variableTypeCode == 0 ? str + "" + SPSSUtils.byte8ToDouble(this.missingValue[i]) : str + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[i]) : SPSSUtils.byte8ToString(this.missingValue[i], this.file.charset));
            }
        } else if (this.missingValueFormatCode <= -2) {
            str = str + "\nMissing range   : ";
            str = this.variableTypeCode == 0 ? str + "" + SPSSUtils.byte8ToDouble(this.missingValue[0]) : str + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[0]) : SPSSUtils.byte8ToString(this.missingValue[0], this.file.charset));
            str = str + " - ";
            str = this.variableTypeCode == 0 ? str + "" + SPSSUtils.byte8ToDouble(this.missingValue[1]) : str + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[1]) : SPSSUtils.byte8ToString(this.missingValue[1], this.file.charset));
            if (this.missingValueFormatCode == -3) {
                str = str + "\nMissing 3       : ";
                str = this.variableTypeCode == 0 ? str + "" + SPSSUtils.byte8ToDouble(this.missingValue[2]) : str + (this.file.charset == null ? SPSSUtils.byte8ToString(this.missingValue[2]) : SPSSUtils.byte8ToString(this.missingValue[2], this.file.charset));
            }
        }
        return str;
    }
}

