/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.Iterator;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSNumericVariable;
import org.opendatafoundation.data.spss.SPSSStringVariable;
import org.opendatafoundation.data.spss.SPSSVariable;

public class SPSSDataRecord {
    SPSSFile file;
    long fileLocation;
    static byte[] cluster = new byte[8];
    static byte clusterIndex = (byte)8;

    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.read(is, false);
    }

    public void read(SPSSFile is, boolean fromDisk) throws IOException, SPSSFileException {
        this.file = is;
        this.fileLocation = this.file.getFilePointer();
        Iterator<Integer> varIterator = this.file.variableMap.keySet().iterator();
        while (varIterator.hasNext()) {
            SPSSVariable var = this.file.variableMap.get(varIterator.next());
            DataValue<?> value = this.readData(var);
            if (var.type == SPSSVariable.VariableType.NUMERIC) {
                this.setVariableValue(var, fromDisk, value);
                continue;
            }
            DataValue.Builder dataValueBuilder = new DataValue.Builder(SPSSVariable.VariableType.STRING);
            dataValueBuilder.setValue((String)((DataValue)value).getData());
            SPSSStringVariable stringVariable = (SPSSStringVariable)var;
            for (SPSSVariable segment : stringVariable.segments) {
                dataValueBuilder.appendValue((String)((DataValue)this.readData(segment)).getData());
            }
            this.setStringVariableValue(stringVariable, fromDisk, (String)((DataValue)dataValueBuilder.build()).getData());
        }
    }

    private DataValue<?> readData(SPSSVariable var) throws SPSSFileException, IOException {
        int blocksToRead = 0;
        int charactersToRead = 0;
        DataValue.Builder dataValueBuilder = new DataValue.Builder(var.type);
        if (var.type == SPSSVariable.VariableType.NUMERIC) {
            blocksToRead = 1;
        } else {
            charactersToRead = var.variableRecord.variableTypeCode;
            blocksToRead = (charactersToRead - 1) / 8 + 1;
        }
        while (blocksToRead > 0) {
            if (this.file.isCompressed()) {
                if (clusterIndex > 7) {
                    this.file.read(cluster);
                    clusterIndex = 0;
                }
                int byteValue = 0xFF & cluster[clusterIndex];
                clusterIndex = (byte)(clusterIndex + 1);
                switch (byteValue) {
                    case 0: {
                        break;
                    }
                    case 252: {
                        throw new SPSSFileException("Error reading data: unexpected end of compressed data file (cluster code 252)");
                    }
                    case 253: {
                        if (var.type == SPSSVariable.VariableType.NUMERIC) {
                            dataValueBuilder.setValue(this.file.readSPSSDouble());
                            break;
                        }
                        int blockStringLength = Math.min(8, charactersToRead);
                        dataValueBuilder.appendValue(this.file.readSPSSString(blockStringLength));
                        if (charactersToRead < 8) {
                            this.file.skipBytes(8 - charactersToRead);
                        }
                        charactersToRead -= blockStringLength;
                        break;
                    }
                    case 254: {
                        if (var.type == SPSSVariable.VariableType.NUMERIC) {
                            dataValueBuilder.setValue(0.0);
                            break;
                        }
                        dataValueBuilder.appendValue("        ");
                        break;
                    }
                    case 255: {
                        if (var.type == SPSSVariable.VariableType.NUMERIC) {
                            dataValueBuilder.setValue(Double.NaN);
                            break;
                        }
                        throw new SPSSFileException("Error reading data: unexpected SYSMISS for string variable");
                    }
                    default: {
                        if (var.type == SPSSVariable.VariableType.NUMERIC) {
                            dataValueBuilder.setValue((double)byteValue - this.file.infoRecord.compressionBias);
                            break;
                        }
                        throw new SPSSFileException("Error reading data: unexpected compression code for string variable");
                    }
                }
            } else if (var.type == SPSSVariable.VariableType.NUMERIC) {
                dataValueBuilder.setValue(this.file.readSPSSDouble());
            } else {
                int blockStringLength = Math.min(8, charactersToRead);
                dataValueBuilder.appendValue(this.file.readSPSSString(blockStringLength));
                if (charactersToRead < 8) {
                    // empty if block
                }
                charactersToRead -= blockStringLength;
            }
            --blocksToRead;
        }
        return dataValueBuilder.build();
    }

    private void setVariableValue(SPSSVariable var, boolean fromDisk, DataValue<?> dataValue) {
        if (var.type == SPSSVariable.VariableType.NUMERIC) {
            this.setNumericVariableValue((SPSSNumericVariable)var, fromDisk, (Double)((DataValue)dataValue).getData());
        } else {
            this.setStringVariableValue((SPSSStringVariable)var, fromDisk, (String)((DataValue)dataValue).getData());
        }
    }

    private void setNumericVariableValue(SPSSNumericVariable variable, boolean fromDisk, Double value) {
        if (fromDisk) {
            variable.value = value;
        } else {
            variable.data.add(Double.NaN);
            variable.data.set(variable.data.size() - 1, value);
        }
    }

    private void setStringVariableValue(SPSSStringVariable variable, boolean fromDisk, String value) {
        if (fromDisk) {
            variable.value = value;
        } else {
            variable.data.add("");
            variable.data.set(variable.data.size() - 1, value);
        }
    }

    private static class DataValue<T> {
        private final T data;

        public DataValue(T data) {
            this.data = data;
        }

        private T getData() {
            return this.data;
        }

        private static class Builder {
            private SPSSVariable.VariableType type;
            private Double doubleValue;
            private StringBuilder stringValueBuilder = new StringBuilder();

            public Builder(SPSSVariable.VariableType type) {
                this.type = type;
            }

            public Builder setValue(Double value) {
                this.doubleValue = value;
                return this;
            }

            public Builder setValue(String value) {
                this.stringValueBuilder.append(value);
                return this;
            }

            public Builder appendValue(String value) {
                this.stringValueBuilder.append(value);
                return this;
            }

            public DataValue<?> build() {
                if (this.type == SPSSVariable.VariableType.NUMERIC) {
                    return new DataValue<Double>(this.doubleValue);
                }
                return new DataValue<String>(this.postProcessString(this.stringValueBuilder.toString()));
            }

            private String postProcessString(String value) {
                if (this.type == SPSSVariable.VariableType.STRING) {
                    if (value.trim().length() == 0) {
                        return "";
                    }
                    return value.replaceAll("\\s+$", "");
                }
                return value;
            }
        }
    }
}

