/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;

public class SPSSRecordType3
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfLabels;
    Map<byte[], String> valueLabel = new LinkedHashMap<byte[], String>();

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 3) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 3.");
        }
        this.numberOfLabels = is.readSPSSInt();
        for (int i = 0; i < this.numberOfLabels; ++i) {
            byte[] value = new byte[8];
            is.read(value);
            if (is.isBigEndian) {
                for (int j = 0; j < 3; ++j) {
                    byte tmp = value[j];
                    value[j] = value[7 - j];
                    value[7 - j] = tmp;
                }
            }
            int labelLength = is.read();
            String label = is.readSPSSString(labelLength);
            if ((labelLength + 1) % 8 != 0) {
                is.skipBytes(8 - (labelLength + 1) % 8);
            }
            this.valueLabel.put(value, label);
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 3 - VALUE LABEL RECORD";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nNumber labels   : " + this.numberOfLabels;
        for (Map.Entry<byte[], String> entry : this.valueLabel.entrySet()) {
            byte[] value = entry.getKey();
            String label = entry.getValue();
            str = str + "\n " + SPSSUtils.byte8ToDouble(value) + "=" + label;
        }
        return str;
    }
}

