/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType6
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfLines;
    String[] line;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 6) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 6.");
        }
        this.numberOfLines = is.readSPSSInt();
        this.line = new String[this.numberOfLines];
        for (int i = 0; i < this.numberOfLines; ++i) {
            this.line[i] = is.readSPSSString(80);
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 6 - DOCUMENT RECORD";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nNumber of lines : " + this.numberOfLines;
        for (int i = 0; i < this.numberOfLines; ++i) {
            str = str + this.line[i] + "\n";
        }
        return str;
    }
}

