/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;

public class SPSSStringVariable
extends SPSSVariable {
    public List<String> data;
    public List<SPSSVariable> segments;
    public String value;

    public SPSSStringVariable(SPSSFile file) {
        super(file);
        this.type = SPSSVariable.VariableType.STRING;
        this.data = new ArrayList<String>();
        this.segments = new ArrayList<SPSSVariable>();
    }

    @Override
    public int getNumberOfObservations() {
        return this.data.size();
    }

    public void setLength(int value) {
        this.variableRecord.writeFormatWidth = value;
    }

    @Override
    public SPSSVariableCategory addCategory(byte[] byteValue, String label) {
        String strValue = this.file.charset == null ? SPSSUtils.byte8ToString(byteValue) : SPSSUtils.byte8ToString(byteValue, this.file.charset);
        SPSSVariableCategory cat = (SPSSVariableCategory)this.categoryMap.get(strValue);
        if (cat == null) {
            cat = new SPSSVariableCategory();
            this.categoryMap.put(strValue, cat);
        }
        cat.strValue = strValue;
        cat.label = label;
        return cat;
    }

    @Override
    public SPSSVariableCategory getCategory(byte[] byteValue) {
        String strValue = this.file.charset == null ? SPSSUtils.byte8ToString(byteValue) : SPSSUtils.byte8ToString(byteValue, this.file.charset);
        return this.getCategory(strValue);
    }

    public SPSSVariableCategory getCategory(String strValue) {
        return (SPSSVariableCategory)this.categoryMap.get(strValue);
    }

    @Override
    public String getSPSSFormat() {
        return "A" + this.variableRecord.writeFormatWidth;
    }

    @Override
    public String getValueAsString(int obsNumber, FileFormatInfo dataFormat) throws SPSSFileException {
        String strValue;
        if (obsNumber < 0 || obsNumber > this.data.size()) {
            throw new SPSSFileException("Invalid observation number [" + obsNumber + ". Range is 1 to " + this.data.size() + "] or 0.");
        }
        if (obsNumber == 0) {
            strValue = this.value;
        } else {
            if (obsNumber > 0 && this.data.size() == 0) {
                throw new SPSSFileException("No data availble");
            }
            strValue = this.data.get(obsNumber - 1);
        }
        if (strValue == null) {
            return null;
        }
        if (dataFormat.format == FileFormatInfo.Format.ASCII) {
            if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.FIXED) {
                strValue = strValue + Utils.leftPad("", this.getLength() - strValue.length());
            } else if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                if (strValue.contains("\"")) {
                    strValue = strValue.replaceAll("\"", "\"\"");
                }
                if (strValue.contains(",") || strValue.contains("\"") || strValue.contains("\n")) {
                    strValue = "\"" + strValue + "\"";
                }
            }
        }
        return strValue;
    }
}

