/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType1
extends SPSSAbstractRecordType {
    String recordTypeCode;
    String productIdentification;
    int layoutCode;
    int OBSperObservation;
    int compressionSwitch;
    int weightVariableIndex;
    int numberOfCases;
    double compressionBias;
    String creationDate;
    String creationTime;
    String fileLabel;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSString(4);
        if (this.recordTypeCode.compareTo("$FL2") != 0) {
            throw new SPSSFileException("Read header error: this is not a valid SPSS file. Does not start with $FL2.");
        }
        this.productIdentification = is.readSPSSString(60).replaceAll("\\s+$", "");
        long filePointer = is.getFilePointer();
        this.layoutCode = is.readSPSSInt();
        if (this.layoutCode != 2 && this.layoutCode != 3) {
            is.isBigEndian = true;
            is.seek(filePointer);
            this.layoutCode = is.readSPSSInt();
        }
        this.OBSperObservation = is.readSPSSInt();
        this.compressionSwitch = is.readSPSSInt();
        this.weightVariableIndex = is.readSPSSInt();
        this.numberOfCases = is.readSPSSInt();
        this.compressionBias = is.readSPSSDouble();
        this.creationDate = is.readSPSSString(9);
        this.creationTime = is.readSPSSString(8);
        this.fileLabel = is.readSPSSString(64).replaceAll("\\s+$", "");
        is.skipBytes(3);
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 1 - GENERAL INFO";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nProduct ID      : " + this.productIdentification;
        str = str + "\nLayout code     : " + this.layoutCode;
        str = str + "\nOBS per obs     : " + this.OBSperObservation;
        str = str + "\nCompression     : " + this.compressionSwitch;
        str = str + "\nWeight Variable : " + this.weightVariableIndex;
        str = str + "\nNumber of cases : " + this.numberOfCases;
        str = str + "\nCompression bias: " + this.compressionBias;
        str = str + "\nCreation date   : " + this.creationDate;
        str = str + "\nCreation time   : " + this.creationTime;
        str = str + "\nFile label      : " + this.fileLabel;
        return str;
    }
}

