/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype4
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    double sysmiss;
    double highest;
    double lowest;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 4: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 4: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 4.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 8) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 8.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        if (this.numberOfDataElements != 3) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad number of data elements [" + this.dataElementLength + "]. Expecting 3.");
        }
        this.sysmiss = is.readSPSSDouble();
        this.highest = is.readSPSSDouble();
        this.lowest = is.readSPSSDouble();
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 SUBTYPE 4 - RELEASE AND MACHINE SPECIFIC FLOAT INFORMATION";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        str = str + "\nSysmiss         : " + this.sysmiss;
        str = str + "\nHighest         : " + this.highest;
        str = str + "\nLowest          : " + this.lowest;
        return str;
    }
}

