/*
 * Decompiled with CFR 0.152.
 */
package enlight.geom;

import enlight.geom.ISceneObject;
import enlight.geom.IntersectionInfo;
import enlight.maths.Point3D;

public class Sphere
implements ISceneObject {
    private final Point3D centre = new Point3D();
    private final double radius;

    public Sphere(Point3D centre, double radius) {
        this.centre.set(centre);
        this.radius = radius;
    }

    @Override
    public void getSupport(Point3D normal, Point3D supportOut) {
        supportOut.set(this.centre);
        supportOut.addMultiple(normal, this.radius);
    }

    @Override
    public void getIntersection(Point3D start, Point3D direction, double dist, IntersectionInfo result) {
        Point3D c = new Point3D(this.centre);
        c.sub(start);
        double centreDist = direction.dot(c);
        double disc = centreDist * centreDist - c.lengthSquared() + this.radius * this.radius;
        if (disc < 0.0) {
            result.hasIntersection = false;
            return;
        }
        double rootDisc = Math.sqrt(disc);
        if (dist >= centreDist + rootDisc) {
            result.hasIntersection = false;
            return;
        }
        double collDist = centreDist - rootDisc;
        if (dist >= collDist) {
            result.interior = true;
            collDist = centreDist + rootDisc;
        } else {
            result.interior = false;
        }
        if (dist > collDist) {
            throw new Error("Shouldn't be possible!");
        }
        result.hasIntersection = true;
        result.intersectionPoint.set(direction);
        result.intersectionPoint.mul(collDist);
        result.surfaceNormal.set(result.intersectionPoint);
        result.surfaceNormal.sub(c);
        result.surfaceNormal.normalize();
        if (result.interior) {
            result.surfaceNormal.mul(-1.0);
        }
        result.intersectionPoint.add(start);
        result.intersectionDistance = collDist;
    }
}

